/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetStringResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryNClob;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010,J\u0012\u0010-\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00108J\u001a\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0016J\u0012\u0010=\u001a\u0004\u0018\u0001012\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0016J\u001a\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010F\u001a\u0004\u0018\u0001012\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006G"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetStringConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getAsciiStream", "Ljava/io/InputStream;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBigDecimal", "Ljava/math/BigDecimal;", "getBinaryStream", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getUUID", "Ljava/util/UUID;", "getUtilDate", "Ljava/util/Date;", "getValue", "Frontend"})
public final class GetStringConverter
extends GetValueConverter {
    @NotNull
    public static final GetStringConverter INSTANCE = new GetStringConverter();
    @NotNull
    private static final List<SqlServerType> from;

    private GetStringConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public java.util.Date getUtilDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        LocalDateTime localDateTime = this.getLocalDateTime(response);
        if (localDateTime == null) {
            return null;
        }
        LocalDateTime localDateTime2 = localDateTime;
        return java.util.Date.from(localDateTime2.toInstant(ZoneOffset.UTC));
    }

    @Override
    @Nullable
    public Date getSqlDate(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Date.valueOf(SqlDateTimeFormatter.INSTANCE.getDatePart(value2));
    }

    @Override
    @Nullable
    public Time getTime(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        LocalTime localTime = this.getLocalTime(response);
        if (localTime == null) {
            return null;
        }
        LocalTime localTime2 = localTime;
        return new Time(localTime2.atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    @Override
    @Nullable
    public LocalTime getLocalTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return SqlDateTimeFormatter.INSTANCE.parseLocalTime(value2);
    }

    @Override
    @NotNull
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return false;
        }
        String value2 = string;
        return Boolean.parseBoolean(value2);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return new BigDecimal(value2);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Double.parseDouble(value2);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Float.valueOf(Float.parseFloat(value2));
    }

    @Override
    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Long.parseLong(value2);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Integer.parseInt(value2);
    }

    @Override
    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Short.parseShort(value2);
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Byte.parseByte(value2);
    }

    @Override
    @Nullable
    public UUID getUUID(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return UUID.fromString(value2);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public InputStream getAsciiStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getBytes(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        return new ByteArrayInputStream(value2);
    }

    @Override
    @Nullable
    public InputStream getBinaryStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        byte[] byArray = this.getBytes(response);
        if (byArray == null) {
            return null;
        }
        byte[] value2 = byArray;
        return new ByteArrayInputStream(value2);
    }

    @Override
    @Nullable
    public byte[] getBytes(@NotNull RdGetValueResponse response) {
        String value2;
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String string2 = value2 = string;
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Override
    @Nullable
    public NClob getNClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return new ProtocolInMemoryNClob(value2);
    }

    @Override
    @Nullable
    public Clob getClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return new ProtocolInMemoryClob(value2);
    }

    @Override
    @Nullable
    public Reader getCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return new StringReader(value2);
    }

    @Override
    @Nullable
    public Reader getNCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getCharacterStream(response);
    }

    @Override
    @Nullable
    public LocalDate getLocalDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return SqlDateTimeFormatter.INSTANCE.parseLocalDate(value2);
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return SqlDateTimeFormatter.INSTANCE.parseLocalDateTime(value2);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return Timestamp.valueOf(value2);
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getValue(response);
        if (string == null) {
            return null;
        }
        String value2 = string;
        return SqlDateTimeFormatter.INSTANCE.parseOffsetDateTime(value2);
    }

    private final String getValue(RdGetValueResponse response) {
        String string;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetStringResponse) {
            string = ((RdGetStringResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            string = null;
        } else {
            String string2 = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string2, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetStringResponse.Companion.get_type()).getName(), "RdGetStringResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string2, stringArray);
        }
        return string;
    }

    static {
        SqlServerType[] sqlServerTypeArray = new SqlServerType[]{SqlServerType.Char, SqlServerType.VarChar, SqlServerType.NVarChar, SqlServerType.NChar, SqlServerType.Text, SqlServerType.NText};
        from = CollectionsKt.listOf(sqlServerTypeArray);
    }
}

