/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdDotNetSqlDecimal;
import com.jetbrains.jdbc.base.models.RdGetBigDecimalResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.conversions.DecimalConverter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$H\u0016J\u0015\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010'J\u0017\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010*J\u0017\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010-J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u00100J\u0017\u00101\u001a\u0004\u0018\u0001022\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u00103J\u0017\u00104\u001a\u0004\u0018\u0001052\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u00106J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010#\u001a\u00020$H\u0016J\u0017\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\u0004\u0018\u0001082\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006R\u0011\u0010 \u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006\u00a8\u0006@"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetDecimalConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "byteMaxValue", "Ljava/math/BigDecimal;", "getByteMaxValue", "()Ljava/math/BigDecimal;", "byteMinValue", "getByteMinValue", "doubleMaxValue", "getDoubleMaxValue", "doubleMinValue", "getDoubleMinValue", "floatMaxValue", "getFloatMaxValue", "floatMinValue", "getFloatMinValue", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "intMaxValue", "getIntMaxValue", "intMinValue", "getIntMinValue", "longMaxValue", "getLongMaxValue", "longMinValue", "getLongMinValue", "shortMaxValue", "getShortMaxValue", "shortMinValue", "getShortMinValue", "getBigDecimal", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNString", "", "getObject", "", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getString", "getValue", "Frontend"})
public final class GetDecimalConverter
extends GetValueConverter {
    @NotNull
    public static final GetDecimalConverter INSTANCE = new GetDecimalConverter();
    @NotNull
    private static final List<SqlServerType> from;
    @NotNull
    private static final BigDecimal byteMinValue;
    @NotNull
    private static final BigDecimal byteMaxValue;
    @NotNull
    private static final BigDecimal shortMinValue;
    @NotNull
    private static final BigDecimal shortMaxValue;
    @NotNull
    private static final BigDecimal intMinValue;
    @NotNull
    private static final BigDecimal intMaxValue;
    @NotNull
    private static final BigDecimal longMinValue;
    @NotNull
    private static final BigDecimal longMaxValue;
    @NotNull
    private static final BigDecimal floatMinValue;
    @NotNull
    private static final BigDecimal floatMaxValue;
    @NotNull
    private static final BigDecimal doubleMinValue;
    @NotNull
    private static final BigDecimal doubleMaxValue;

    private GetDecimalConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @NotNull
    public final BigDecimal getByteMinValue() {
        return byteMinValue;
    }

    @NotNull
    public final BigDecimal getByteMaxValue() {
        return byteMaxValue;
    }

    @NotNull
    public final BigDecimal getShortMinValue() {
        return shortMinValue;
    }

    @NotNull
    public final BigDecimal getShortMaxValue() {
        return shortMaxValue;
    }

    @NotNull
    public final BigDecimal getIntMinValue() {
        return intMinValue;
    }

    @NotNull
    public final BigDecimal getIntMaxValue() {
        return intMaxValue;
    }

    @NotNull
    public final BigDecimal getLongMinValue() {
        return longMinValue;
    }

    @NotNull
    public final BigDecimal getLongMaxValue() {
        return longMaxValue;
    }

    @NotNull
    public final BigDecimal getFloatMinValue() {
        return floatMinValue;
    }

    @NotNull
    public final BigDecimal getFloatMaxValue() {
        return floatMaxValue;
    }

    @NotNull
    public final BigDecimal getDoubleMinValue() {
        return doubleMinValue;
    }

    @NotNull
    public final BigDecimal getDoubleMaxValue() {
        return doubleMaxValue;
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(byteMinValue) >= 0 && value2.compareTo(byteMaxValue) <= 0) {
            return value2.byteValue();
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Byte.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Byte::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(shortMinValue) >= 0 && value2.compareTo(shortMaxValue) <= 0) {
            return value2.shortValue();
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Short.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Short::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(intMinValue) >= 0 && value2.compareTo(intMaxValue) <= 0) {
            return value2.intValue();
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Integer.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Int::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(longMinValue) >= 0 && value2.compareTo(longMaxValue) <= 0) {
            return value2.longValue();
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Long::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(floatMinValue) >= 0 && value2.compareTo(floatMaxValue) <= 0) {
            return Float.valueOf(value2.floatValue());
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Float.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Float::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        if (value2.compareTo(doubleMinValue) >= 0 && value2.compareTo(doubleMaxValue) <= 0) {
            return value2.doubleValue();
        }
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        String string2 = Double.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Double::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getBigDecimal(response);
    }

    @Override
    @NotNull
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return false;
        }
        BigDecimal value2 = bigDecimal;
        return value2.signum() == 1;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        BigDecimal bigDecimal = this.getValue(response);
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal value2 = bigDecimal;
        return value2.toString();
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    private final BigDecimal getValue(RdGetValueResponse response) {
        BigDecimal bigDecimal;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetBigDecimalResponse) {
            RdDotNetSqlDecimal rdDotNetSqlDecimal = ((RdGetBigDecimalResponse)response).getValue();
            bigDecimal = rdDotNetSqlDecimal != null ? DecimalConverter.INSTANCE.toBigDecimal(rdDotNetSqlDecimal) : null;
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            bigDecimal = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetBigDecimalResponse.Companion.get_type()).getName(), "RdGetBigDecimalResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return bigDecimal;
    }

    static {
        SqlServerType[] sqlServerTypeArray = new SqlServerType[]{SqlServerType.Decimal, SqlServerType.Money, SqlServerType.SmallMoney};
        from = CollectionsKt.listOf(sqlServerTypeArray);
        byteMinValue = new BigDecimal(-128);
        byteMaxValue = new BigDecimal(127);
        shortMinValue = new BigDecimal(Short.MIN_VALUE);
        shortMaxValue = new BigDecimal(Short.MAX_VALUE);
        intMinValue = new BigDecimal(Integer.MIN_VALUE);
        intMaxValue = new BigDecimal(Integer.MAX_VALUE);
        longMinValue = new BigDecimal(Long.MIN_VALUE);
        longMaxValue = new BigDecimal(Long.MAX_VALUE);
        floatMinValue = new BigDecimal(1.4E-45f);
        floatMaxValue = new BigDecimal(3.4028234663852886E38);
        doubleMinValue = new BigDecimal(Double.MIN_VALUE);
        doubleMaxValue = new BigDecimal(Double.MAX_VALUE);
    }
}

