/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetLongResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetBigIntConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getBigDecimal", "Ljava/math/BigDecimal;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNString", "", "getObject", "", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getString", "getValue", "Frontend"})
public final class GetBigIntConverter
extends GetValueConverter {
    @NotNull
    public static final GetBigIntConverter INSTANCE = new GetBigIntConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.BigInt);

    private GetBigIntConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        if (value2 >= -128L && value2 <= 127L) {
            return (byte)value2;
        }
        String string = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Long::class.java.name");
        String string2 = Byte.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Byte::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        if (value2 >= -32768L && value2 <= 32767L) {
            return (short)value2;
        }
        String string = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Long::class.java.name");
        String string2 = Short.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Short::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        if (value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE) {
            return (int)value2;
        }
        String string = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Long::class.java.name");
        String string2 = Integer.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Int::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Override
    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        return Float.valueOf(value2);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        return value2;
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        return value2 > 0L;
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        return new BigDecimal(value2);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getValue(response);
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Long l = this.getValue(response);
        if (l == null) {
            return null;
        }
        long value2 = l;
        return String.valueOf(value2);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    private final Long getValue(RdGetValueResponse response) {
        Long l;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetLongResponse) {
            l = ((RdGetLongResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            l = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetLongResponse.Companion.get_type()).getName(), "RdGetLongResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return l;
    }
}

