/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.pooling;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdBasicStatement;
import com.jetbrains.jdbc.base.models.RdBasicStatementInitialState;
import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.BasicStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IBasicStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.ProtocolPool;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/pooling/BasicStatementPool;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ProtocolPool;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IBasicStatementPool;", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "poolSize", "", "(Lcom/jetbrains/jdbc/base/models/JdbcModel;I)V", "createInitialState", "Lcom/jetbrains/jdbc/base/models/RdBasicStatementInitialState;", "rdStatement", "Lcom/jetbrains/jdbc/base/models/RdBasicStatement;", "type", "concurrency", "holdability", "rent", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/BasicStatementInitializationData;", "connection", "Lcom/jetbrains/jdbc/base/models/RdConnection;", "returnStatement", "", "statement", "Frontend"})
public final class BasicStatementPool
extends ProtocolPool
implements IBasicStatementPool {
    public BasicStatementPool(@NotNull JdbcModel model, int poolSize) {
        Intrinsics.checkNotNullParameter(model, "model");
        super(model, poolSize);
    }

    @Override
    @NotNull
    public BasicStatementInitializationData rent(@NotNull RdConnection connection, int type2, int concurrency, int holdability) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        return (BasicStatementInitializationData)ProtocolUtilsKt.queueAndWait(this.getScheduler(), (Function0)new Function0<BasicStatementInitializationData>(this, type2, concurrency, holdability, connection){
            final /* synthetic */ BasicStatementPool this$0;
            final /* synthetic */ int $type;
            final /* synthetic */ int $concurrency;
            final /* synthetic */ int $holdability;
            final /* synthetic */ RdConnection $connection;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                this.$concurrency = $concurrency;
                this.$holdability = $holdability;
                this.$connection = $connection;
                super(0);
            }

            @NotNull
            public final BasicStatementInitializationData invoke() {
                RdBasicStatement rdBasicStatement;
                if (this.this$0.getFreeObjects().isEmpty()) {
                    BasicStatementPool basicStatementPool2 = this.this$0;
                    basicStatementPool2.setObjectId(basicStatementPool2.getObjectId() + 1);
                    RdBasicStatement rdBasicStatement2 = new RdBasicStatement(basicStatementPool2.getObjectId());
                    RdBasicStatementInitialState state = BasicStatementPool.access$createInitialState(this.this$0, rdBasicStatement2, this.$type, this.$concurrency, this.$holdability);
                    ((Map)this.this$0.getModel().getBasicStatements()).put(rdBasicStatement2.getId(), rdBasicStatement2);
                    this.$connection.getCreateBasicStatement().fire(state);
                    return new BasicStatementInitializationData(rdBasicStatement2, state);
                }
                Integer statementId = this.this$0.getFreeObjects().removeFirst();
                RdBasicStatement rdBasicStatement3 = rdBasicStatement = (RdBasicStatement)this.this$0.getModel().getBasicStatements().get(statementId);
                Intrinsics.checkNotNull(rdBasicStatement3);
                RdBasicStatementInitialState state = BasicStatementPool.access$createInitialState(this.this$0, rdBasicStatement3, this.$type, this.$concurrency, this.$holdability);
                this.$connection.getCreateBasicStatement().fire(state);
                return new BasicStatementInitializationData(rdBasicStatement, state);
            }
        });
    }

    @Override
    public void returnStatement(@NotNull RdBasicStatement statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        ProtocolUtilsKt.queueAndWait(this.getScheduler(), (Function0)new Function0<Object>(this, statement){
            final /* synthetic */ BasicStatementPool this$0;
            final /* synthetic */ RdBasicStatement $statement;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                Object object;
                if (this.this$0.getFreeObjects().size() >= this.this$0.getPoolSize()) {
                    object = this.this$0.getModel().getBasicStatements().remove(this.$statement.getId());
                } else {
                    this.$statement.getClose().fire(Unit.INSTANCE);
                    this.this$0.getFreeObjects().addLast(this.$statement.getId());
                    object = Unit.INSTANCE;
                }
                return object;
            }
        });
    }

    private final RdBasicStatementInitialState createInitialState(RdBasicStatement rdStatement, int type2, int concurrency, int holdability) {
        return new RdBasicStatementInitialState(0, 0, 100, 1002, 0, type2, concurrency, holdability, rdStatement.getId());
    }

    public static final /* synthetic */ RdBasicStatementInitialState access$createInitialState(BasicStatementPool $this, RdBasicStatement rdStatement, int type2, int concurrency, int holdability) {
        return $this.createInitialState(rdStatement, type2, concurrency, holdability);
    }
}

