/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.hosting;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.utils.logging.BackendLogListener;
import com.jetbrains.jdbc.base.utils.logging.ILoggerProvider;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.hosting.DotNetBackendStarter;
import com.jetbrains.rd.framework.IIdentities;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.ISerializers;
import com.jetbrains.rd.framework.IWire;
import com.jetbrains.rd.framework.IdKind;
import com.jetbrains.rd.framework.Identities;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdContext;
import com.jetbrains.rd.framework.Serializers;
import com.jetbrains.rd.framework.SocketWire;
import com.jetbrains.rd.framework.SocketWireKt;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.util.ConsoleLoggerFactory;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J'\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0006\u0010\u0018\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/hosting/ProtocolHost;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "loggerProvider", "Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;)V", "backendStarter", "Lcom/jetbrains/jdbc/base/utils/protocol/hosting/DotNetBackendStarter;", "prepareModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "scheduler", "Lcom/jetbrains/rd/util/threading/SingleThreadScheduler;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "prepareProtocol", "port", "", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "(Ljava/lang/Integer;Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/jetbrains/rd/util/lifetime/Lifetime;)Lcom/jetbrains/rd/framework/IProtocol;", "runScheduler", "setupLogListener", "", "model", "start", "Frontend"})
public final class ProtocolHost {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ILoggerProvider loggerProvider;
    @NotNull
    private final DotNetBackendStarter backendStarter;

    public ProtocolHost(@NotNull Lifetime lifetime, @NotNull ILoggerProvider loggerProvider) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(loggerProvider, "loggerProvider");
        this.lifetime = lifetime;
        this.loggerProvider = loggerProvider;
        this.backendStarter = new DotNetBackendStarter(this.loggerProvider);
    }

    @NotNull
    public final JdbcModel start() {
        RdCall.Companion.setRespectSyncCallTimeouts(false);
        ConsoleLoggerFactory.INSTANCE.setMinLevelToLog(LogLevel.Warn);
        SingleThreadScheduler scheduler = this.runScheduler(this.lifetime);
        IProtocol protocol = this.prepareProtocol(null, scheduler, this.lifetime);
        JdbcModel model = this.prepareModel(scheduler, protocol);
        this.lifetime.onTermination(new Function0<Unit>(scheduler, model){
            final /* synthetic */ SingleThreadScheduler $scheduler;
            final /* synthetic */ JdbcModel $model;
            {
                this.$scheduler = $scheduler;
                this.$model = $model;
                super(0);
            }

            public final void invoke() {
                ProtocolUtilsKt.queueAndWait(this.$scheduler, (Function0)new Function0<Unit>(this.$model){
                    final /* synthetic */ JdbcModel $model;
                    {
                        this.$model = $model;
                        super(0);
                    }

                    public final void invoke() {
                        this.$model.getTerminate().fire(Unit.INSTANCE);
                    }
                });
            }
        });
        this.backendStarter.start(SocketWireKt.getServerPort(protocol.getWire()));
        JdbcModelExtKt.waitUntilConnected(model, this.lifetime);
        JdbcModelExtKt.waitForDriver(model, this.lifetime);
        this.setupLogListener(model);
        return model;
    }

    private final SingleThreadScheduler runScheduler(Lifetime lifetime) {
        return new SingleThreadScheduler(lifetime, "Driver Frontend Protocol Thread");
    }

    private final IProtocol prepareProtocol(Integer port, IScheduler scheduler, Lifetime lifetime) {
        SocketWire.Server wire = new SocketWire.Server(lifetime, scheduler, port, null, false, 24, null);
        return new Protocol("ProtocolDriver.Backend", (ISerializers)new Serializers(), (IIdentities)new Identities(IdKind.Client), scheduler, (IWire)wire, lifetime, new RdContext[0]);
    }

    private final JdbcModel prepareModel(SingleThreadScheduler scheduler, IProtocol protocol) {
        return (JdbcModel)ProtocolUtilsKt.queueAndWait(scheduler, (Function0)new Function0<JdbcModel>(protocol){
            final /* synthetic */ IProtocol $protocol;
            {
                this.$protocol = $protocol;
                super(0);
            }

            @NotNull
            public final JdbcModel invoke() {
                return (JdbcModel)this.$protocol.getOrCreateExtension(Reflection.getOrCreateKotlinClass(JdbcModel.class), (Function0)new Function0<JdbcModel>(this.$protocol){
                    final /* synthetic */ IProtocol $protocol;
                    {
                        this.$protocol = $protocol;
                        super(0);
                    }

                    @NotNull
                    public final JdbcModel invoke() {
                        JdbcModel.Companion.register(this.$protocol.getSerializers());
                        return new JdbcModel();
                    }
                });
            }
        });
    }

    private final void setupLogListener(JdbcModel model) {
        new BackendLogListener(this.loggerProvider).listenToLogMessages(this.lifetime, model);
    }
}

