/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.exceptions;

import com.jetbrains.jdbc.base.models.RdApplicationError;
import com.jetbrains.jdbc.base.models.RdDbmsError;
import com.jetbrains.jdbc.base.models.RdError;
import com.jetbrains.jdbc.base.resources.DriverResources;
import com.jetbrains.jdbc.base.utils.exceptions.JbDriverException;
import com.jetbrains.rd.util.reactive.RdFault;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0015H\u0002\u001a-\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0002\u0010\"\u001a\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0015H\u0002\u001a-\u0010$\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0002\u0010%\u001a\u0006\u0010&\u001a\u00020\u0001\u001a\u000e\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0007\u001a\u0006\u0010)\u001a\u00020\u0001\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0007\u001a\u0006\u0010,\u001a\u00020\u0001\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/\u001a\u000e\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020/\u001a\u000e\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020/\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0007\u001a'\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u00042\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040 \"\u00020\u0004\u00a2\u0006\u0002\u00109\u001a\u000e\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u0004\u001a\u000e\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u0004\u001a\u0006\u0010>\u001a\u00020\u0001\u001a\u000e\u0010?\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007\u001a\u000e\u0010@\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u0006\u0010A\u001a\u00020\u0001\u001a\u0006\u0010B\u001a\u00020\u0001\u001a\u001a\u0010C\u001a\u00020\u0001\"\u0004\b\u0000\u0010D2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002HD0E\u001a\u0016\u0010C\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0007\u001a\u0016\u0010C\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004\u001a\u000e\u0010I\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007\u001a\u000e\u0010J\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007\u001a\u000e\u0010J\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u0006\u0010K\u001a\u00020\u001d\u001a\u0006\u0010L\u001a\u00020\u001d\u001a\u0006\u0010M\u001a\u00020\u0001\u001a\u0006\u0010N\u001a\u00020\u0001\u001a\u0006\u0010O\u001a\u00020\u0001\u001a\u0006\u0010P\u001a\u00020\u0001\u001a\u0006\u0010Q\u001a\u00020\u0001\u001a\u0006\u0010R\u001a\u00020\u0001\u001a\u0006\u0010S\u001a\u00020\u0001\u001a\u0006\u0010T\u001a\u00020\u0001\u001a\u0006\u0010U\u001a\u00020\u0001\u001a\u0006\u0010V\u001a\u00020\u0001\u001a\u000e\u0010W\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010X\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u000e\u0010Y\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u000e\u0010Z\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0006\u0010[\u001a\u00020\u0001\u001a\u0006\u0010\\\u001a\u00020\u0001\u001a\u0006\u0010]\u001a\u00020\u0001\u001a\u0006\u0010^\u001a\u00020\u0001\u001a\u0006\u0010_\u001a\u00020\u0001\u001a\n\u0010`\u001a\u00020\u0017*\u00020a\u00a8\u0006b"}, d2={"blobClosed", "Ljava/sql/SQLException;", "cantInstantiateParser", "info", "", "cantReadValueOfType", "type", "", "cantRollbackWhenAutoCommit", "cantSetSavepointWhenAutoCommit", "cantSetValueToType", "clobClosed", "columnNotFound", "index", "name", "connectionClosed", "duplicateConverterFound", "Ljava/sql/SQLType;", "failedToParseXml", "fetchWindowIsClosed", "findRdFault", "Lcom/jetbrains/rd/util/reactive/RdFault;", "throwable", "", "getDbmsException", "rdDbmsError", "Lcom/jetbrains/jdbc/base/models/RdDbmsError;", "rdFault", "getException", "Lcom/jetbrains/jdbc/base/utils/exceptions/JbDriverException;", "code", "parameters", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/jetbrains/jdbc/base/utils/exceptions/JbDriverException;", "getExpectedException", "getSQLException", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/sql/SQLException;", "invalidEscapeSyntax", "invalidHoldability", "holdability", "invalidOperationOnInsertRow", "invalidQueryTimeout", "timeout", "invalidSql", "invalidStreamLength", "length", "", "invalidStreamOffset", "offset", "invalidStreamPosition", "position", "invalidTransactionIsolationLevel", "isolationLevel", "invalidValueReceived", "receivedType", "expectedTypes", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/SQLException;", "keywordNotSupported", "keyword", "methodCannotTakeParameters", "methodName", "noCurrentRow", "noOutputValueForParameter", "noSuchColumn", "notInHexadecimal", "notOnInsertRow", "notSupportedConversion", "T", "Ljava/lang/Class;", "from", "toSqlType", "to", "parameterIsNotOutput", "parameterNotFound", "pathToBackendIsMissing", "pathToDotNetIsMissing", "resultSetClosed", "resultSetIsReadOnly", "resultSetOperationIsNotSupported", "rowIsDeleted", "savepointIsNamed", "savepointIsNotNamed", "sourceIsNotSupported", "statementFailedToExecute", "statementIsClosed", "statementWasNotExecutedYet", "unknownCursor", "unknownValueReceived", "unsupportedJdbcType", "wrapException", "xmlIsReadOnly", "xmlIsWriteOnly", "xmlWasAlreadyRead", "xmlWasAlreadyWritten", "xmlWasNotWritten", "toException", "Lcom/jetbrains/jdbc/base/models/RdError;", "Frontend"})
public final class ExceptionsKt {
    @NotNull
    public static final SQLException cantRollbackWhenAutoCommit() {
        return ExceptionsKt.getSQLException("CANT_ROLLBACK_WHEN_AUTO_COMMIT_MODE", new Object[0]);
    }

    @NotNull
    public static final SQLException cantSetSavepointWhenAutoCommit() {
        return ExceptionsKt.getSQLException("CANT_SET_SAVEPOINT_WHEN_AUTO_COMMIT_MODE", new Object[0]);
    }

    @NotNull
    public static final SQLException invalidTransactionIsolationLevel(int isolationLevel) {
        Object[] objectArray = new Object[]{isolationLevel};
        return ExceptionsKt.getSQLException("INVALID_ISOLATION_LEVEL", objectArray);
    }

    @NotNull
    public static final SQLException invalidHoldability(int holdability) {
        Object[] objectArray = new Object[]{holdability};
        return ExceptionsKt.getSQLException("INVALID_HOLDABILITY", objectArray);
    }

    @NotNull
    public static final SQLException invalidQueryTimeout(int timeout) {
        Object[] objectArray = new Object[]{timeout};
        return ExceptionsKt.getSQLException("INVALID_QUERY_TIMEOUT", objectArray);
    }

    @NotNull
    public static final SQLException connectionClosed() {
        return ExceptionsKt.getSQLException("CONNECTION_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException resultSetClosed() {
        return ExceptionsKt.getSQLException("RESULT_SET_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException blobClosed() {
        return ExceptionsKt.getSQLException("BLOB_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException clobClosed() {
        return ExceptionsKt.getSQLException("CLOB_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException sourceIsNotSupported() {
        return ExceptionsKt.getSQLException("SOURCE_IS_NOT_SUPPORTED", new Object[0]);
    }

    @NotNull
    public static final SQLException resultSetOperationIsNotSupported() {
        return ExceptionsKt.getSQLException("RESULT_SET_OPERATION_IS_NOT_SUPPORTED", new Object[0]);
    }

    @NotNull
    public static final SQLException xmlIsReadOnly() {
        return ExceptionsKt.getSQLException("XML_IS_READ_ONLY", new Object[0]);
    }

    @NotNull
    public static final SQLException xmlIsWriteOnly() {
        return ExceptionsKt.getSQLException("XML_IS_WRITE_ONLY", new Object[0]);
    }

    @NotNull
    public static final SQLException xmlWasNotWritten() {
        return ExceptionsKt.getSQLException("XML_WAS_NOT_WRITTEN", new Object[0]);
    }

    @NotNull
    public static final SQLException xmlWasAlreadyWritten() {
        return ExceptionsKt.getSQLException("XML_WAS_ALREADY_WRITTEN", new Object[0]);
    }

    @NotNull
    public static final SQLException xmlWasAlreadyRead() {
        return ExceptionsKt.getSQLException("XML_WAS_ALREADY_READ", new Object[0]);
    }

    @NotNull
    public static final SQLException failedToParseXml(@NotNull String info) {
        Intrinsics.checkNotNullParameter(info, "info");
        Object[] objectArray = new Object[]{info};
        return ExceptionsKt.getSQLException("FAILED_TO_PARSE_XML", objectArray);
    }

    @NotNull
    public static final SQLException cantInstantiateParser(@NotNull String info) {
        Intrinsics.checkNotNullParameter(info, "info");
        Object[] objectArray = new Object[]{info};
        return ExceptionsKt.getSQLException("CANT_INSTANTIATE_PARSER", objectArray);
    }

    @NotNull
    public static final <T> SQLException notSupportedConversion(@NotNull Class<T> type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Object[] objectArray = new Object[]{type2};
        return ExceptionsKt.getSQLException("NOT_SUPPORTED_CONVERSION", objectArray);
    }

    @NotNull
    public static final SQLException invalidSql() {
        return ExceptionsKt.getSQLException("INVALID_SQL", new Object[0]);
    }

    @NotNull
    public static final SQLException invalidStreamLength(long length) {
        Object[] objectArray = new Object[]{length};
        return ExceptionsKt.getSQLException("INVALID_STREAM_LENGTH", objectArray);
    }

    @NotNull
    public static final SQLException invalidStreamOffset(long offset) {
        Object[] objectArray = new Object[]{offset};
        return ExceptionsKt.getSQLException("INVALID_STREAM_OFFSET", objectArray);
    }

    @NotNull
    public static final SQLException invalidStreamPosition(long position) {
        Object[] objectArray = new Object[]{position};
        return ExceptionsKt.getSQLException("INVALID_STREAM_POSITION", objectArray);
    }

    @NotNull
    public static final SQLException noCurrentRow() {
        return ExceptionsKt.getSQLException("NO_CURRENT_ROW", new Object[0]);
    }

    @NotNull
    public static final SQLException notOnInsertRow() {
        return ExceptionsKt.getSQLException("NOT_ON_INSERT_ROW", new Object[0]);
    }

    @NotNull
    public static final SQLException rowIsDeleted() {
        return ExceptionsKt.getSQLException("ROW_IS_DELETED", new Object[0]);
    }

    @NotNull
    public static final SQLException noSuchColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{name};
        return ExceptionsKt.getSQLException("NO_SUCH_COLUMN", objectArray);
    }

    @NotNull
    public static final SQLException notSupportedConversion(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Object[] objectArray = new Object[]{from, to};
        return ExceptionsKt.getSQLException("NOT_SUPPORTED_CONVERSION_FROM_TO", objectArray);
    }

    @NotNull
    public static final SQLException notSupportedConversion(@NotNull String from, int toSqlType) {
        Intrinsics.checkNotNullParameter(from, "from");
        Object[] objectArray = new Object[]{from, toSqlType};
        return ExceptionsKt.getSQLException("NOT_SUPPORTED_CONVERSION_FROM_TO", objectArray);
    }

    @NotNull
    public static final SQLException notInHexadecimal() {
        return ExceptionsKt.getSQLException("NOT_IN_HEXADECIMAL", new Object[0]);
    }

    @NotNull
    public static final SQLException invalidOperationOnInsertRow() {
        return ExceptionsKt.getSQLException("INVALID_OPERATION_ON_INSERT_ROW", new Object[0]);
    }

    @NotNull
    public static final SQLException resultSetIsReadOnly() {
        return ExceptionsKt.getSQLException("RESULT_SET_IS_READ_ONLY", new Object[0]);
    }

    @NotNull
    public static final SQLException parameterIsNotOutput(int index) {
        Object[] objectArray = new Object[]{index};
        return ExceptionsKt.getSQLException("PARAMETER_IS_NOT_OUTPUT", objectArray);
    }

    @NotNull
    public static final SQLException noOutputValueForParameter(int index) {
        Object[] objectArray = new Object[]{index};
        return ExceptionsKt.getSQLException("NO_PARAMETER_OUTPUT_VALUE", objectArray);
    }

    @NotNull
    public static final SQLException statementWasNotExecutedYet() {
        return ExceptionsKt.getSQLException("STATEMENT_WAS_NOT_EXECUTED", new Object[0]);
    }

    @NotNull
    public static final SQLException statementFailedToExecute() {
        return ExceptionsKt.getSQLException("STATEMENT_FAILED_TO_EXECUTE", new Object[0]);
    }

    @NotNull
    public static final SQLException parameterNotFound(int index) {
        Object[] objectArray = new Object[]{index};
        return ExceptionsKt.getSQLException("NO_PARAMETER_WITH_INDEX", objectArray);
    }

    @NotNull
    public static final SQLException parameterNotFound(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{name};
        return ExceptionsKt.getSQLException("NO_PARAMETER_WITH_NAME", objectArray);
    }

    @NotNull
    public static final SQLException columnNotFound(int index) {
        Object[] objectArray = new Object[]{index};
        return ExceptionsKt.getSQLException("NO_COLUMN_WITH_INDEX", objectArray);
    }

    @NotNull
    public static final SQLException columnNotFound(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{name};
        return ExceptionsKt.getSQLException("NO_COLUMN_WITH_NAME", objectArray);
    }

    @NotNull
    public static final SQLException duplicateConverterFound(@NotNull SQLType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Object[] objectArray = new Object[]{type2.getName()};
        return ExceptionsKt.getSQLException("DUPLICATE_CONVERTER", objectArray);
    }

    @NotNull
    public static final SQLException cantReadValueOfType(int type2) {
        Object[] objectArray = new Object[]{type2};
        return ExceptionsKt.getSQLException("CANT_READ_VALUE", objectArray);
    }

    @NotNull
    public static final SQLException cantSetValueToType(int type2) {
        Object[] objectArray = new Object[]{type2};
        return ExceptionsKt.getSQLException("CANT_SET_VALUE", objectArray);
    }

    @NotNull
    public static final SQLException invalidValueReceived(@NotNull String receivedType, String ... expectedTypes) {
        Intrinsics.checkNotNullParameter(receivedType, "receivedType");
        Intrinsics.checkNotNullParameter(expectedTypes, "expectedTypes");
        Object[] objectArray = new Object[]{ArraysKt.joinToString$default(expectedTypes, null, null, null, 0, null, null, 63, null), receivedType};
        return ExceptionsKt.getSQLException("INVALID_VALUE_RECEIVED", objectArray);
    }

    @NotNull
    public static final SQLException unknownCursor(int type2) {
        Object[] objectArray = new Object[]{type2};
        return ExceptionsKt.getSQLException("UNKNOWN_CURSOR", objectArray);
    }

    @NotNull
    public static final SQLException unsupportedJdbcType(int name) {
        Object[] objectArray = new Object[]{name};
        return ExceptionsKt.getSQLException("UNSUPPORTED_JDBC_TYPE", objectArray);
    }

    @NotNull
    public static final SQLException statementIsClosed() {
        return ExceptionsKt.getSQLException("STATEMENT_IS_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException fetchWindowIsClosed() {
        return ExceptionsKt.getSQLException("FETCH_WINDOW_CLOSED", new Object[0]);
    }

    @NotNull
    public static final SQLException unknownValueReceived(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{name};
        return ExceptionsKt.getSQLException("UNKNOWN_VALUE_RECEIVED", objectArray);
    }

    @NotNull
    public static final SQLException invalidEscapeSyntax() {
        return ExceptionsKt.getSQLException("INVALID_ESCAPE_SEQUENCE", new Object[0]);
    }

    @NotNull
    public static final SQLException keywordNotSupported(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter(keyword, "keyword");
        Object[] objectArray = new Object[]{keyword};
        return ExceptionsKt.getSQLException("KEYWORD_NOT_SUPPORTED", objectArray);
    }

    @NotNull
    public static final SQLException methodCannotTakeParameters(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Object[] objectArray = new Object[]{methodName};
        return ExceptionsKt.getSQLException("CANNOT_TAKE_PARAMETERS", objectArray);
    }

    @NotNull
    public static final SQLException savepointIsNamed() {
        return ExceptionsKt.getSQLException("SAVEPOINT_IS_NAMED", new Object[0]);
    }

    @NotNull
    public static final SQLException savepointIsNotNamed() {
        return ExceptionsKt.getSQLException("SAVEPOINT_IS_NOT_NAMED", new Object[0]);
    }

    @NotNull
    public static final JbDriverException pathToBackendIsMissing() {
        return ExceptionsKt.getException("PATH_TO_BACKEND_MISSING", new Object[0]);
    }

    @NotNull
    public static final JbDriverException pathToDotNetIsMissing() {
        return ExceptionsKt.getException("PATH_TO_DOTNET_MISSING", new Object[0]);
    }

    private static final SQLException getSQLException(String code, Object ... parameters2) {
        String key = DriverResources.Companion.getValue$default(DriverResources.Companion, code, null, 2, null);
        Object[] objectArray = Arrays.copyOf(parameters2, parameters2.length);
        String string = String.format(key, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        String exceptionText = string;
        return new SQLException(exceptionText);
    }

    private static final JbDriverException getException(String code, Object ... parameters2) {
        String key = DriverResources.Companion.getValue$default(DriverResources.Companion, code, null, 2, null);
        Object[] objectArray = Arrays.copyOf(parameters2, parameters2.length);
        String string = String.format(key, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        String exceptionText = string;
        return new JbDriverException(exceptionText);
    }

    @NotNull
    public static final Throwable wrapException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        RdFault rdFault = ExceptionsKt.findRdFault(throwable);
        if (rdFault != null) {
            if (StringsKt.contains$default((CharSequence)rdFault.getReasonTypeFqn(), "DbmsException", false, 2, null)) {
                return ExceptionsKt.getDbmsException(rdFault);
            }
            if (StringsKt.contains$default((CharSequence)rdFault.getReasonTypeFqn(), "ExpectedException", false, 2, null)) {
                return ExceptionsKt.getExpectedException(rdFault);
            }
        }
        return new JbDriverException("Unexpected JetBrains Jdbc Driver error", throwable);
    }

    private static final SQLException getDbmsException(RdFault rdFault) {
        List<String> lines = StringsKt.lines(rdFault.getReasonAsText());
        int errorNumber = Integer.parseInt(StringsKt.substringAfter$default(lines.get(0), "ErrorNumber: ", null, 2, null));
        String statusCode = StringsKt.substringAfter$default(lines.get(1), "StateCode: ", null, 2, null);
        return new SQLException(rdFault.getReasonMessage(), statusCode, errorNumber);
    }

    private static final SQLException getDbmsException(RdDbmsError rdDbmsError) {
        return new SQLException(rdDbmsError.getReason(), rdDbmsError.getStatusCode(), rdDbmsError.getErrorNumber());
    }

    private static final SQLException getExpectedException(RdFault rdFault) {
        return new SQLException(rdFault.getReasonMessage());
    }

    private static final RdFault findRdFault(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof RdFault) {
            return (RdFault)throwable;
        }
        return ExceptionsKt.findRdFault(throwable.getCause());
    }

    @NotNull
    public static final Throwable toException(@NotNull RdError $this$toException) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter($this$toException, "<this>");
        RdError rdError = $this$toException;
        if (rdError instanceof RdDbmsError) {
            throwable = ExceptionsKt.getDbmsException((RdDbmsError)$this$toException);
        } else if (rdError instanceof RdApplicationError) {
            throwable = new JbDriverException(((RdApplicationError)$this$toException).getMessage());
        } else {
            throw new IllegalArgumentException();
        }
        return throwable;
    }
}

