/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.conversions;

import com.jetbrains.jdbc.base.models.RdDotNetSqlDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\n\u0010\r\u001a\u00020\u0004*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u000e*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/jdbc/base/utils/conversions/DecimalConverter;", "", "()V", "maxValue", "Ljava/math/BigDecimal;", "minValue", "sqlDecimalBitLength", "", "sqlDecimalPrecision", "getMantissaPart", "partNumber", "bytes", "", "toBigDecimal", "Lcom/jetbrains/jdbc/base/models/RdDotNetSqlDecimal;", "toDotNetDecimal", "Frontend"})
public final class DecimalConverter {
    @NotNull
    public static final DecimalConverter INSTANCE = new DecimalConverter();
    @NotNull
    private static final BigDecimal minValue = new BigDecimal("-99999999999999999999999999999999999999");
    @NotNull
    private static final BigDecimal maxValue = new BigDecimal("99999999999999999999999999999999999999");
    private static final int sqlDecimalPrecision = 38;
    private static final int sqlDecimalBitLength = 128;

    private DecimalConverter() {
    }

    @NotNull
    public final BigDecimal toBigDecimal(@NotNull RdDotNetSqlDecimal $this$toBigDecimal) {
        Intrinsics.checkNotNullParameter($this$toBigDecimal, "<this>");
        BigInteger integer = BigInteger.valueOf((long)$this$toBigDecimal.getMantissa1() & 0xFFFFFFFFL).add(BigInteger.valueOf((long)$this$toBigDecimal.getMantissa2() & 0xFFFFFFFFL).shiftLeft(32)).add(BigInteger.valueOf((long)$this$toBigDecimal.getMantissa3() & 0xFFFFFFFFL).shiftLeft(64)).add(BigInteger.valueOf((long)$this$toBigDecimal.getMantissa4() & 0xFFFFFFFFL).shiftLeft(96));
        BigDecimal decimal = new BigDecimal(integer, $this$toBigDecimal.getScale());
        if (!$this$toBigDecimal.isPositive()) {
            BigDecimal bigDecimal = decimal.negate();
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "decimal.negate()");
            decimal = bigDecimal;
        }
        return decimal;
    }

    @NotNull
    public final RdDotNetSqlDecimal toDotNetDecimal(@NotNull BigDecimal $this$toDotNetDecimal) {
        boolean isNegative;
        Intrinsics.checkNotNullParameter($this$toDotNetDecimal, "<this>");
        BigDecimal value2 = $this$toDotNetDecimal;
        if (value2.compareTo(minValue) < 0) {
            throw new Exception("Input number is out of range.");
        }
        if (value2.compareTo(maxValue) > 0) {
            throw new Exception("Input number is out of range.");
        }
        if (value2.precision() > 38) {
            BigDecimal bigDecimal = value2.setScale(value2.scale() - (value2.precision() - 38), RoundingMode.HALF_UP);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "value.setScale(value.sca\u2026n), RoundingMode.HALF_UP)");
            value2 = bigDecimal;
        }
        if (value2.unscaledValue().bitLength() > 128) {
            BigDecimal bigDecimal = value2.setScale(value2.scale() - 1, RoundingMode.HALF_UP);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "value.setScale(value.sca\u2026 1, RoundingMode.HALF_UP)");
            value2 = bigDecimal;
        }
        boolean bl = isNegative = value2.compareTo(BigDecimal.valueOf(0L)) < 0;
        if (isNegative) {
            BigDecimal bigDecimal = value2.negate();
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "value.negate()");
            value2 = bigDecimal;
        }
        BigInteger unscaledValue = value2.scale() > 0 ? value2.unscaledValue() : value2.unscaledValue().multiply(BigInteger.valueOf(10L).pow(-value2.scale()));
        byte[] bytes = unscaledValue.toByteArray();
        Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
        int mantissa1 = this.getMantissaPart(1, bytes);
        int mantissa2 = this.getMantissaPart(2, bytes);
        int mantissa3 = this.getMantissaPart(3, bytes);
        int mantissa4 = this.getMantissaPart(4, bytes);
        return new RdDotNetSqlDecimal(mantissa1, mantissa2, mantissa3, mantissa4, (byte)RangesKt.coerceAtLeast(value2.scale(), 0), !isNegative);
    }

    private final int getMantissaPart(int partNumber, byte[] bytes) {
        int startIndex = bytes[0] == 0 ? 1 : 0;
        int partStarts = bytes.length - 1 - (partNumber - 1) * 4;
        int partEnds = RangesKt.coerceAtLeast(bytes.length - partNumber * 4, startIndex);
        int part = 0;
        int shift = 0;
        int i = partStarts;
        if (partEnds <= i) {
            while (true) {
                part |= (bytes[i] & 0xFF) << shift;
                shift += 8;
                if (i == partEnds) break;
                --i;
            }
        }
        return part;
    }
}

