/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.conversions;

import com.jetbrains.jdbc.base.models.RdDate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\u0007\u001a\n\u0010\f\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0006\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"gregorianCutover", "Ljava/sql/Date;", "nanosInOneMillisecond", "", "pureGregorianCutover", "fromGregorianToPureGregorian", "Ljava/util/Calendar;", "Ljava/time/Instant;", "timeZone", "Ljava/util/TimeZone;", "fromPureGregorianToGregorian", "getLeftNanos", "resetTime", "setBaseDate", "toRdDate", "Lcom/jetbrains/jdbc/base/models/RdDate;", "Frontend"})
public final class DateTimeUtilsKt {
    private static final int nanosInOneMillisecond = 1000000;
    @NotNull
    private static final java.sql.Date pureGregorianCutover = new java.sql.Date(Long.MIN_VALUE);
    @NotNull
    private static final java.sql.Date gregorianCutover = new java.sql.Date(-12219292800000L);

    @NotNull
    public static final RdDate toRdDate(@NotNull java.sql.Date $this$toRdDate, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$toRdDate, "<this>");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        Instant instant = Instant.ofEpochMilli($this$toRdDate.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant truncated = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant().truncatedTo(ChronoUnit.DAYS);
        Date date = java.sql.Date.from(truncated);
        Intrinsics.checkNotNullExpressionValue(date, "from(truncated)");
        return new RdDate(date);
    }

    public static final int getLeftNanos(@NotNull Instant $this$getLeftNanos) {
        Intrinsics.checkNotNullParameter($this$getLeftNanos, "<this>");
        return $this$getLeftNanos.getNano() % 1000000;
    }

    @NotNull
    public static final Calendar fromPureGregorianToGregorian(@NotNull Instant $this$fromPureGregorianToGregorian, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$fromPureGregorianToGregorian, "<this>");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        LocalDateTime local = LocalDateTime.ofInstant($this$fromPureGregorianToGregorian, ZoneId.of("UTC"));
        GregorianCalendar cal = new GregorianCalendar(timeZone, Locale.US);
        cal.setGregorianChange(gregorianCutover);
        cal.set(1, local.getYear());
        cal.set(2, local.getMonthValue() - 1);
        cal.set(5, local.getDayOfMonth());
        cal.set(11, local.getHour());
        cal.set(12, local.getMinute());
        cal.set(13, local.getSecond());
        cal.set(14, local.getNano() / 1000000);
        return cal;
    }

    @NotNull
    public static final Calendar fromGregorianToPureGregorian(@NotNull Instant $this$fromGregorianToPureGregorian, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$fromGregorianToPureGregorian, "<this>");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setGregorianChange(gregorianCutover);
        gregorianCalendar.setTimeInMillis($this$fromGregorianToPureGregorian.toEpochMilli());
        GregorianCalendar pureGregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        pureGregorianCalendar.setGregorianChange(pureGregorianCutover);
        pureGregorianCalendar.set(1, gregorianCalendar.get(1));
        pureGregorianCalendar.set(2, gregorianCalendar.get(2));
        pureGregorianCalendar.set(5, gregorianCalendar.get(5));
        pureGregorianCalendar.set(11, gregorianCalendar.get(11));
        pureGregorianCalendar.set(12, gregorianCalendar.get(12));
        pureGregorianCalendar.set(13, gregorianCalendar.get(13));
        pureGregorianCalendar.set(14, gregorianCalendar.get(14));
        return pureGregorianCalendar;
    }

    @NotNull
    public static final Calendar setBaseDate(@NotNull Calendar $this$setBaseDate) {
        Intrinsics.checkNotNullParameter($this$setBaseDate, "<this>");
        $this$setBaseDate.set(1970, 0, 1);
        return $this$setBaseDate;
    }

    @NotNull
    public static final Calendar resetTime(@NotNull Calendar $this$resetTime) {
        Intrinsics.checkNotNullParameter($this$resetTime, "<this>");
        $this$resetTime.set(11, 0);
        $this$resetTime.set(12, 0);
        $this$resetTime.set(13, 0);
        $this$resetTime.set(14, 0);
        return $this$resetTime;
    }
}

