/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors.moves.refresh;

import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorMoveResult;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorState;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.refresh.IRefreshMove;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/refresh/RefreshMove;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/refresh/IRefreshMove;", "()V", "afterLast", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorMoveResult;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "state", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorState;", "beforeFirst", "fetchRefresh", "oldWindowPosition", "", "position", "inResultSet", "Frontend"})
public final class RefreshMove
implements IRefreshMove {
    @NotNull
    public static final RefreshMove INSTANCE = new RefreshMove();

    private RefreshMove() {
    }

    @Override
    @NotNull
    public CursorMoveResult beforeFirst(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        throw ExceptionsKt.noCurrentRow();
    }

    @Override
    @NotNull
    public CursorMoveResult afterLast(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        throw ExceptionsKt.noCurrentRow();
    }

    @Override
    @NotNull
    public CursorMoveResult inResultSet(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        return this.fetchRefresh(remoteCursor, state.getFetchWindow().getPosition(), state.getPosition());
    }

    private final CursorMoveResult fetchRefresh(IRemoteCursor remoteCursor, int oldWindowPosition, int position) {
        IFetchWindow newFetchWindow = remoteCursor.fetchRefresh();
        boolean hasMoreRows = newFetchWindow.next().reachedDestination();
        newFetchWindow.moveForward(oldWindowPosition - 1);
        return new CursorMoveResult(hasMoreRows, position, newFetchWindow);
    }

    @Override
    public boolean isSupported() {
        return IRefreshMove.DefaultImpls.isSupported(this);
    }
}

