/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors.crud;

import com.jetbrains.jdbc.base.models.RdDeleteRowRequest;
import com.jetbrains.jdbc.base.models.RdInsertRowRequest;
import com.jetbrains.jdbc.base.models.RdSetResultSetColumn;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.models.RdUpdateRowRequest;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.crud.CursorCrudResult;
import com.jetbrains.jdbc.base.resultsets.cursors.crud.ICursorCrudExecutor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorState;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetColumn;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetRow;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/crud/CursorCrudExecutor;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/crud/ICursorCrudExecutor;", "()V", "deleteRow", "Lcom/jetbrains/jdbc/base/resultsets/cursors/crud/CursorCrudResult;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "state", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorState;", "row", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;", "getColumnsWithPendingValues", "", "Lcom/jetbrains/jdbc/base/models/RdSetResultSetColumn;", "insertRow", "updateRow", "", "Frontend"})
public final class CursorCrudExecutor
implements ICursorCrudExecutor {
    @NotNull
    public static final CursorCrudExecutor INSTANCE = new CursorCrudExecutor();

    private CursorCrudExecutor() {
    }

    @Override
    @NotNull
    public CursorCrudResult insertRow(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state, @NotNull IResultSetRow row) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(row, "row");
        List<RdSetResultSetColumn> columns = this.getColumnsWithPendingValues(row);
        remoteCursor.insertRow(new RdInsertRowRequest(columns));
        return new CursorCrudResult(state.getRowsCount() + 1);
    }

    @Override
    public void updateRow(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state, @NotNull IResultSetRow row) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(row, "row");
        List<RdSetResultSetColumn> columns = this.getColumnsWithPendingValues(row);
        remoteCursor.updateRow(new RdUpdateRowRequest(row.getPositionInBatch(), columns));
    }

    @Override
    @NotNull
    public CursorCrudResult deleteRow(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state, @NotNull IResultSetRow row) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(row, "row");
        remoteCursor.deleteRow(new RdDeleteRowRequest(row.getPositionInBatch()));
        return new CursorCrudResult(state.getRowsCount());
    }

    private final List<RdSetResultSetColumn> getColumnsWithPendingValues(IResultSetRow row) {
        List columns = new ArrayList();
        int n = row.getColumns().size();
        for (int i = 0; i < n; ++i) {
            IResultSetColumn column = row.getColumns().get(i);
            RdSetValueRequest pendingValue = column.getPendingValue();
            if (pendingValue == null) continue;
            columns.add(new RdSetResultSetColumn(i, pendingValue));
        }
        return columns;
    }

    @Override
    public boolean isSupported() {
        return ICursorCrudExecutor.DefaultImpls.isSupported(this);
    }
}

