/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql.xml.apis;

import com.jetbrains.jdbc.base.models.sql.xml.XmlResult;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlResultGetter;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlSourceGetter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/apis/SAX;", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlSourceGetter;", "Ljavax/xml/transform/sax/SAXSource;", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlResultGetter;", "Ljavax/xml/transform/sax/SAXResult;", "()V", "getResult", "Lcom/jetbrains/jdbc/base/models/sql/xml/XmlResult;", "getSource", "value", "", "Frontend"})
public final class SAX
implements XmlSourceGetter<SAXSource>,
XmlResultGetter<SAXResult> {
    @Override
    @NotNull
    public SAXSource getSource(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        try {
            InputSource src = new InputSource(new StringReader(value2));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            return new SAXSource(reader, src);
        }
        catch (SAXException e) {
            String string = e.toString();
            Intrinsics.checkNotNullExpressionValue(string, "e.toString()");
            throw ExceptionsKt.failedToParseXml(string);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionsKt.cantInstantiateParser(e.toString());
        }
    }

    @Override
    @NotNull
    public XmlResult<SAXResult> getResult() {
        TransformerHandler transformerHandler;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Intrinsics.checkNotNull(transformerFactory, "null cannot be cast to non-null type javax.xml.transform.sax.SAXTransformerFactory");
            SAXTransformerFactory stf = (SAXTransformerFactory)transformerFactory;
            stf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerHandler = stf.newTransformerHandler();
            Intrinsics.checkNotNullExpressionValue(transformerHandler, "{\n            val stf = \u2026formerHandler()\n        }");
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionsKt.cantInstantiateParser(e.toString());
        }
        catch (ClassCastException e) {
            throw ExceptionsKt.cantInstantiateParser(e.toString());
        }
        TransformerHandler handler = transformerHandler;
        StringWriter writer = new StringWriter();
        handler.setResult(new StreamResult(writer));
        return new XmlResult<SAXResult>(new SAXResult(handler), writer);
    }
}

