/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql.xml;

import com.jetbrains.jdbc.base.models.sql.xml.apis.DOM;
import com.jetbrains.jdbc.base.models.sql.xml.apis.SAX;
import com.jetbrains.jdbc.base.models.sql.xml.apis.StAX;
import com.jetbrains.jdbc.base.models.sql.xml.apis.Stream;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlResultGetter;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlSourceGetter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007J \u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/XmlApiProvider;", "", "()V", "getResultGetter", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlResultGetter;", "T", "sourceClass", "Ljava/lang/Class;", "getSourceGetter", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlSourceGetter;", "Frontend"})
public final class XmlApiProvider {
    @NotNull
    public final <T> XmlSourceGetter<T> getSourceGetter(@NotNull Class<T> sourceClass) {
        XmlSourceGetter xmlSourceGetter;
        Intrinsics.checkNotNullParameter(sourceClass, "sourceClass");
        if (Intrinsics.areEqual(DOMSource.class, sourceClass)) {
            xmlSourceGetter = new DOM();
        } else if (Intrinsics.areEqual(SAXSource.class, sourceClass)) {
            xmlSourceGetter = new SAX();
        } else if (Intrinsics.areEqual(StAXSource.class, sourceClass)) {
            xmlSourceGetter = new StAX();
        } else if (Intrinsics.areEqual(StreamSource.class, sourceClass)) {
            xmlSourceGetter = new Stream();
        } else {
            throw ExceptionsKt.sourceIsNotSupported();
        }
        return xmlSourceGetter;
    }

    @NotNull
    public final <T> XmlResultGetter<T> getResultGetter(@NotNull Class<T> sourceClass) {
        XmlResultGetter xmlResultGetter;
        Intrinsics.checkNotNullParameter(sourceClass, "sourceClass");
        if (Intrinsics.areEqual(DOMSource.class, sourceClass)) {
            xmlResultGetter = new DOM();
        } else if (Intrinsics.areEqual(SAXSource.class, sourceClass)) {
            xmlResultGetter = new SAX();
        } else if (Intrinsics.areEqual(StAXSource.class, sourceClass)) {
            xmlResultGetter = new StAX();
        } else if (Intrinsics.areEqual(StreamSource.class, sourceClass)) {
            xmlResultGetter = new Stream();
        } else {
            throw ExceptionsKt.resultSetOperationIsNotSupported();
        }
        return xmlResultGetter;
    }
}

