/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql;

import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClobBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/SQLServerClobAsciiOutputStream;", "Ljava/io/OutputStream;", "clob", "Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryClobBase;", "streamPos", "", "(Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryClobBase;J)V", "bSingleByte", "", "write", "", "b", "off", "", "len", "Frontend"})
public final class SQLServerClobAsciiOutputStream
extends OutputStream {
    @NotNull
    private ProtocolInMemoryClobBase clob;
    private long streamPos;
    @NotNull
    private final byte[] bSingleByte;

    public SQLServerClobAsciiOutputStream(@NotNull ProtocolInMemoryClobBase clob, long streamPos) {
        Intrinsics.checkNotNullParameter(clob, "clob");
        this.clob = clob;
        this.streamPos = streamPos;
        this.bSingleByte = new byte[1];
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter(b, "b");
        long l3 = this.streamPos;
        SQLServerClobAsciiOutputStream sQLServerClobAsciiOutputStream = this;
        try {
            SQLServerClobAsciiOutputStream sQLServerClobAsciiOutputStream2 = sQLServerClobAsciiOutputStream;
            l2 = l3;
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
            Charset charset2 = charset;
            String s = new String(b, off, len, charset2);
            int charsWritten = this.clob.setString(this.streamPos, s);
            l = charsWritten;
        }
        catch (SQLException sQLException) {
            void ex;
            SQLServerClobAsciiOutputStream sQLServerClobAsciiOutputStream3 = sQLServerClobAsciiOutputStream;
            long l4 = l3;
            throw new IOException(ex.getMessage());
        }
        sQLServerClobAsciiOutputStream2.streamPos = l2 + l;
    }

    @Override
    public void write(int b) {
        this.bSingleByte[0] = (byte)(b & 0xFF);
        this.write(this.bSingleByte, 0, this.bSingleByte.length);
    }
}

