/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.conversions.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.conversions.set.SetValueConverterProvider;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ-\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0014\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0019J!\u0010\u001a\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010+J!\u0010,\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020/2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00100J\u001f\u00101\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u0002022\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00103J\u001f\u00104\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u0002052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00106J!\u00107\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001082\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00109J+\u0010:\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010!2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\"J!\u0010;\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010=J!\u0010>\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010@J\u0017\u0010A\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010BJ)\u0010C\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010D\u001a\u0004\u0018\u00010\n2\b\u0010E\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010FJ!\u0010G\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010IJ!\u0010J\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010K2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010LJ!\u0010M\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010N2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010OJ!\u0010P\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010Q2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010RJ!\u0010S\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010T2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010UJ!\u0010V\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010W2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010XJ-\u0010Y\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010Z2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\\2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010]J!\u0010^\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010?2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010@J-\u0010_\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010`2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\\2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010aJ-\u0010b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010c2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\\2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010dJ!\u0010e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010gJ-\u0010h\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ-\u0010i\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010j2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\\2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010kR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;", "", "setValueConverterProvider", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverterProvider;", "(Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverterProvider;)V", "setArray", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/sql/Array;", "targetType", "", "(Ljava/sql/Array;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setAsciiStream", "Ljava/io/InputStream;", "length", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setBigDecimal", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setBinaryStream", "setBlob", "Ljava/sql/Blob;", "(Ljava/sql/Blob;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setBoolean", "", "(Ljava/lang/Boolean;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setByte", "", "(Ljava/lang/Byte;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setBytes", "", "([BLjava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setCharacterStream", "Ljava/io/Reader;", "(Ljava/io/Reader;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setClob", "Ljava/sql/Clob;", "(Ljava/sql/Clob;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setDouble", "", "(Ljava/lang/Double;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setFloat", "", "(Ljava/lang/Float;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setInt", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setLocalDate", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setLocalDateTime", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setLocalTime", "Ljava/time/LocalTime;", "(Ljava/time/LocalTime;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setLong", "", "(Ljava/lang/Long;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setNCharacterStream", "setNClob", "Ljava/sql/NClob;", "(Ljava/sql/NClob;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setNString", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setNull", "(Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setObject", "targetSqlType", "scaleOrLength", "(Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setOffsetDateTime", "Ljava/time/OffsetDateTime;", "(Ljava/time/OffsetDateTime;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setOffsetTime", "Ljava/time/OffsetTime;", "(Ljava/time/OffsetTime;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setRef", "Ljava/sql/Ref;", "(Ljava/sql/Ref;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setRowId", "Ljava/sql/RowId;", "(Ljava/sql/RowId;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setSQLXML", "Ljava/sql/SQLXML;", "(Ljava/sql/SQLXML;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setShort", "", "(Ljava/lang/Short;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setSqlDate", "Ljava/sql/Date;", "cal", "Ljava/util/Calendar;", "(Ljava/sql/Date;Ljava/util/Calendar;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setString", "setTime", "Ljava/sql/Time;", "(Ljava/sql/Time;Ljava/util/Calendar;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setTimestamp", "Ljava/sql/Timestamp;", "(Ljava/sql/Timestamp;Ljava/util/Calendar;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setURL", "Ljava/net/URL;", "(Ljava/net/URL;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "setUnicodeStream", "setUtilDate", "Ljava/util/Date;", "(Ljava/util/Date;Ljava/util/Calendar;Ljava/lang/Integer;)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "Frontend"})
public final class ValueSetter {
    @NotNull
    private final SetValueConverterProvider setValueConverterProvider;

    public ValueSetter(@NotNull SetValueConverterProvider setValueConverterProvider) {
        Intrinsics.checkNotNullParameter(setValueConverterProvider, "setValueConverterProvider");
        this.setValueConverterProvider = setValueConverterProvider;
    }

    @NotNull
    public final RdSetValueRequest setNull(@Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.NULL.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromNull(type2);
    }

    public static /* synthetic */ RdSetValueRequest setNull$default(ValueSetter valueSetter, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return valueSetter.setNull(n);
    }

    @NotNull
    public final RdSetValueRequest setBoolean(@Nullable Boolean value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.BIT.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromBoolean(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setBoolean$default(ValueSetter valueSetter, Boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setBoolean(bl, n);
    }

    @NotNull
    public final RdSetValueRequest setByte(@Nullable Byte value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TINYINT.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromByte(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setByte$default(ValueSetter valueSetter, Byte by, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setByte(by, n);
    }

    @NotNull
    public final RdSetValueRequest setShort(@Nullable Short value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.SMALLINT.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromShort(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setShort$default(ValueSetter valueSetter, Short s, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setShort(s, n);
    }

    @NotNull
    public final RdSetValueRequest setInt(@Nullable Integer value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.INTEGER.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromInt(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setInt$default(ValueSetter valueSetter, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return valueSetter.setInt(n, n2);
    }

    @NotNull
    public final RdSetValueRequest setLong(@Nullable Long value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.BIGINT.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromLong(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setLong$default(ValueSetter valueSetter, Long l, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setLong(l, n);
    }

    @NotNull
    public final RdSetValueRequest setFloat(@Nullable Float value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.REAL.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromFloat(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setFloat$default(ValueSetter valueSetter, Float f, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setFloat(f, n);
    }

    @NotNull
    public final RdSetValueRequest setDouble(@Nullable Double value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.FLOAT.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromDouble(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setDouble$default(ValueSetter valueSetter, Double d, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setDouble(d, n);
    }

    @NotNull
    public final RdSetValueRequest setBigDecimal(@Nullable BigDecimal value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.DECIMAL.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromBigDecimal(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setBigDecimal$default(ValueSetter valueSetter, BigDecimal bigDecimal, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setBigDecimal(bigDecimal, n);
    }

    @NotNull
    public final RdSetValueRequest setString(@Nullable String value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.VARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromString(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setString$default(ValueSetter valueSetter, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setString(string, n);
    }

    @NotNull
    public final RdSetValueRequest setBytes(@Nullable byte[] value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.BINARY.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromBytes(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setBytes$default(ValueSetter valueSetter, byte[] byArray, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setBytes(byArray, n);
    }

    @NotNull
    public final RdSetValueRequest setSqlDate(@Nullable Date value2, @Nullable Calendar cal, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.DATE.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Intrinsics.checkNotNullExpressionValue(cloneable2, "cal?.timeZone ?: TimeZone.getDefault()");
        return converter.fromSqlDate(value2, (TimeZone)cloneable2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setSqlDate$default(ValueSetter valueSetter, Date date, Calendar calendar, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            calendar = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return valueSetter.setSqlDate(date, calendar, n);
    }

    @NotNull
    public final RdSetValueRequest setUtilDate(@Nullable java.util.Date value2, @Nullable Calendar cal, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIMESTAMP.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Intrinsics.checkNotNullExpressionValue(cloneable2, "cal?.timeZone ?: TimeZone.getDefault()");
        return converter.fromUtilDate(value2, (TimeZone)cloneable2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setUtilDate$default(ValueSetter valueSetter, java.util.Date date, Calendar calendar, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            calendar = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return valueSetter.setUtilDate(date, calendar, n);
    }

    @NotNull
    public final RdSetValueRequest setTime(@Nullable Time value2, @Nullable Calendar cal, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIME.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Intrinsics.checkNotNullExpressionValue(cloneable2, "cal?.timeZone ?: TimeZone.getDefault()");
        return converter.fromTime(value2, (TimeZone)cloneable2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setTime$default(ValueSetter valueSetter, Time time, Calendar calendar, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            calendar = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return valueSetter.setTime(time, calendar, n);
    }

    @NotNull
    public final RdSetValueRequest setTimestamp(@Nullable Timestamp value2, @Nullable Calendar cal, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIMESTAMP.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Intrinsics.checkNotNullExpressionValue(cloneable2, "cal?.timeZone ?: TimeZone.getDefault()");
        return converter.fromTimestamp(value2, (TimeZone)cloneable2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setTimestamp$default(ValueSetter valueSetter, Timestamp timestamp, Calendar calendar, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            calendar = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return valueSetter.setTimestamp(timestamp, calendar, n);
    }

    @NotNull
    public final RdSetValueRequest setLocalDateTime(@NotNull LocalDateTime value2, @Nullable Integer targetType) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIMESTAMP.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromLocalDateTime(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setLocalDateTime$default(ValueSetter valueSetter, LocalDateTime localDateTime, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setLocalDateTime(localDateTime, n);
    }

    @NotNull
    public final RdSetValueRequest setLocalDate(@NotNull LocalDate value2, @Nullable Integer targetType) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.DATE.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromLocalDate(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setLocalDate$default(ValueSetter valueSetter, LocalDate localDate, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setLocalDate(localDate, n);
    }

    @NotNull
    public final RdSetValueRequest setLocalTime(@NotNull LocalTime value2, @Nullable Integer targetType) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIME.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromLocalTime(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setLocalTime$default(ValueSetter valueSetter, LocalTime localTime, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setLocalTime(localTime, n);
    }

    @NotNull
    public final RdSetValueRequest setOffsetDateTime(@Nullable OffsetDateTime value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIMESTAMP_WITH_TIMEZONE.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromOffsetDateTime(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setOffsetDateTime$default(ValueSetter valueSetter, OffsetDateTime offsetDateTime, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setOffsetDateTime(offsetDateTime, n);
    }

    @NotNull
    public final RdSetValueRequest setOffsetTime(@Nullable OffsetTime value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.TIME_WITH_TIMEZONE.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromOffsetTime(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setOffsetTime$default(ValueSetter valueSetter, OffsetTime offsetTime, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setOffsetTime(offsetTime, n);
    }

    @NotNull
    public final RdSetValueRequest setAsciiStream(@Nullable InputStream value2, @Nullable Integer length, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.LONGVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Integer n2 = length;
        return converter.fromAsciiStream(value2, n2 != null ? n2 : Integer.MAX_VALUE, type2);
    }

    public static /* synthetic */ RdSetValueRequest setAsciiStream$default(ValueSetter valueSetter, InputStream inputStream, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return valueSetter.setAsciiStream(inputStream, n, n2);
    }

    @NotNull
    public final RdSetValueRequest setUnicodeStream(@Nullable InputStream value2, @Nullable Integer length, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.LONGNVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Integer n2 = length;
        return converter.fromUnicodeStream(value2, n2 != null ? n2 : Integer.MAX_VALUE, type2);
    }

    public static /* synthetic */ RdSetValueRequest setUnicodeStream$default(ValueSetter valueSetter, InputStream inputStream, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return valueSetter.setUnicodeStream(inputStream, n, n2);
    }

    @NotNull
    public final RdSetValueRequest setBinaryStream(@Nullable InputStream value2, @Nullable Integer length, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.LONGVARBINARY.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Integer n2 = length;
        return converter.fromBinaryStream(value2, n2 != null ? n2 : Integer.MAX_VALUE, type2);
    }

    public static /* synthetic */ RdSetValueRequest setBinaryStream$default(ValueSetter valueSetter, InputStream inputStream, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return valueSetter.setBinaryStream(inputStream, n, n2);
    }

    @NotNull
    public final RdSetValueRequest setCharacterStream(@Nullable Reader value2, @Nullable Integer length, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.LONGVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Integer n2 = length;
        return converter.fromCharacterStream(value2, n2 != null ? n2 : Integer.MAX_VALUE, type2);
    }

    public static /* synthetic */ RdSetValueRequest setCharacterStream$default(ValueSetter valueSetter, Reader reader, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return valueSetter.setCharacterStream(reader, n, n2);
    }

    @NotNull
    public final RdSetValueRequest setBlob(@Nullable Blob value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.BLOB.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromBlob(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setBlob$default(ValueSetter valueSetter, Blob blob, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setBlob(blob, n);
    }

    @NotNull
    public final RdSetValueRequest setClob(@Nullable Clob value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.CLOB.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromClob(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setClob$default(ValueSetter valueSetter, Clob clob, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setClob(clob, n);
    }

    @NotNull
    public final RdSetValueRequest setURL(@Nullable URL value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.NVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromUrl(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setURL$default(ValueSetter valueSetter, URL uRL, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setURL(uRL, n);
    }

    @NotNull
    public final RdSetValueRequest setRowId(@Nullable RowId value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.ROWID.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromRowId(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setRowId$default(ValueSetter valueSetter, RowId rowId, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setRowId(rowId, n);
    }

    @NotNull
    public final RdSetValueRequest setRef(@Nullable Ref value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.REF.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromRef(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setRef$default(ValueSetter valueSetter, Ref ref, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setRef(ref, n);
    }

    @NotNull
    public final RdSetValueRequest setArray(@Nullable Array value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.ARRAY.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromArray(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setArray$default(ValueSetter valueSetter, Array array2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setArray(array2, n);
    }

    @NotNull
    public final RdSetValueRequest setNString(@Nullable String value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.NVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromNString(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setNString$default(ValueSetter valueSetter, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setNString(string, n);
    }

    @NotNull
    public final RdSetValueRequest setNClob(@Nullable NClob value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.NCLOB.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromNClob(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setNClob$default(ValueSetter valueSetter, NClob nClob, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setNClob(nClob, n);
    }

    @NotNull
    public final RdSetValueRequest setSQLXML(@Nullable SQLXML value2, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.SQLXML.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        return converter.fromSQLXML(value2, type2);
    }

    public static /* synthetic */ RdSetValueRequest setSQLXML$default(ValueSetter valueSetter, SQLXML sQLXML, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueSetter.setSQLXML(sQLXML, n);
    }

    @NotNull
    public final RdSetValueRequest setNCharacterStream(@Nullable Reader value2, @Nullable Integer length, @Nullable Integer targetType) {
        Integer n = targetType;
        if (n == null) {
            n = JDBCType.LONGNVARCHAR.getVendorTypeNumber();
        }
        Integer type2 = n;
        Intrinsics.checkNotNullExpressionValue(type2, "type");
        SetValueConverter converter = this.setValueConverterProvider.getConverter(type2);
        Integer n2 = length;
        return converter.fromNCharacterStream(value2, n2 != null ? n2 : Integer.MAX_VALUE, type2);
    }

    public static /* synthetic */ RdSetValueRequest setNCharacterStream$default(ValueSetter valueSetter, Reader reader, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return valueSetter.setNCharacterStream(reader, n, n2);
    }

    @NotNull
    public final RdSetValueRequest setObject(@Nullable Object value2, @Nullable Integer targetSqlType, @Nullable Integer scaleOrLength) {
        if (value2 == null) {
            return this.setNull(targetSqlType);
        }
        Object object = value2;
        if (object instanceof String) {
            return this.setNString((String)value2, targetSqlType);
        }
        if (object instanceof Byte) {
            return this.setByte((Byte)value2, targetSqlType);
        }
        if (object instanceof Short) {
            return this.setShort((Short)value2, targetSqlType);
        }
        if (object instanceof Integer) {
            return this.setInt((Integer)value2, targetSqlType);
        }
        if (object instanceof Long) {
            return this.setLong((Long)value2, targetSqlType);
        }
        if (object instanceof BigDecimal) {
            return this.setBigDecimal((BigDecimal)value2, targetSqlType);
        }
        if (object instanceof Boolean) {
            return this.setBoolean((Boolean)value2, targetSqlType);
        }
        if (object instanceof Date) {
            return this.setSqlDate((Date)value2, null, targetSqlType);
        }
        if (object instanceof Time) {
            return this.setTime((Time)value2, null, targetSqlType);
        }
        if (object instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value2, null, targetSqlType);
        }
        if (object instanceof java.util.Date) {
            return this.setUtilDate((java.util.Date)value2, null, targetSqlType);
        }
        if (object instanceof LocalDateTime) {
            return this.setLocalDateTime((LocalDateTime)value2, targetSqlType);
        }
        if (object instanceof LocalTime) {
            return this.setLocalTime((LocalTime)value2, targetSqlType);
        }
        if (object instanceof LocalDate) {
            return this.setLocalDate((LocalDate)value2, targetSqlType);
        }
        if (object instanceof OffsetDateTime) {
            return this.setOffsetDateTime((OffsetDateTime)value2, targetSqlType);
        }
        if (object instanceof OffsetTime) {
            return this.setOffsetTime((OffsetTime)value2, targetSqlType);
        }
        if (object instanceof SQLXML) {
            return this.setSQLXML((SQLXML)value2, targetSqlType);
        }
        if (object instanceof Blob) {
            return this.setBlob((Blob)value2, targetSqlType);
        }
        if (object instanceof NClob) {
            return this.setNClob((NClob)value2, targetSqlType);
        }
        if (object instanceof Clob) {
            return this.setClob((Clob)value2, targetSqlType);
        }
        if (object instanceof byte[]) {
            return this.setBytes((byte[])value2, targetSqlType);
        }
        if (object instanceof Float) {
            return this.setFloat((Float)value2, targetSqlType);
        }
        if (object instanceof Double) {
            return this.setDouble((Double)value2, targetSqlType);
        }
        if (object instanceof Reader) {
            return this.setNCharacterStream((Reader)value2, scaleOrLength, targetSqlType);
        }
        if (object instanceof InputStream) {
            return this.setBinaryStream((InputStream)value2, scaleOrLength, targetSqlType);
        }
        throw ExceptionsKt.notSupportedConversion(value2.getClass());
    }
}

