/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.conversions.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.conversions.get.GetValueConverterProvider;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u00105\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bJ)\u00105\u001a\u0004\u0018\u0001H6\"\u0004\b\u0000\u001062\u0006\u0010\u0007\u001a\u00020\b2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H608\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010>\u001a\u00020?2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010@\u001a\u00020A2\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010DJ\u001c\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HJ\u0010\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010K\u001a\u0004\u0018\u0001042\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HJ\u001c\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HJ\u000e\u0010P\u001a\u00020Q2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010T\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;", "", "getValueConverterProvider", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverterProvider;", "(Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverterProvider;)V", "getArray", "Ljava/sql/Array;", "value", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getAsciiStream", "Ljava/io/InputStream;", "getBigDecimal", "Ljava/math/BigDecimal;", "scale", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;Ljava/lang/Integer;)Ljava/math/BigDecimal;", "getBinaryStream", "getBlob", "Ljava/sql/Blob;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "T", "type", "Ljava/lang/Class;", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;Ljava/lang/Class;)Ljava/lang/Object;", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getRef", "Ljava/sql/Ref;", "getRowId", "Ljava/sql/RowId;", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getSqlDate", "Ljava/sql/Date;", "cal", "Ljava/util/Calendar;", "getSqlXml", "Ljava/sql/SQLXML;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getURL", "Ljava/net/URL;", "getUUID", "Ljava/util/UUID;", "getUnicodeStream", "getUtilDate", "Ljava/util/Date;", "Frontend"})
public final class ValueGetter {
    @NotNull
    private final GetValueConverterProvider getValueConverterProvider;

    public ValueGetter(@NotNull GetValueConverterProvider getValueConverterProvider) {
        Intrinsics.checkNotNullParameter(getValueConverterProvider, "getValueConverterProvider");
        this.getValueConverterProvider = getValueConverterProvider;
    }

    @Nullable
    public final String getString(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getString(value2);
    }

    @Nullable
    public final Boolean getBoolean(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getBoolean(value2);
    }

    @Nullable
    public final Byte getByte(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getByte(value2);
    }

    @Nullable
    public final Short getShort(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getShort(value2);
    }

    @Nullable
    public final Integer getInt(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getInt(value2);
    }

    @Nullable
    public final Long getLong(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getLong(value2);
    }

    @Nullable
    public final Float getFloat(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getFloat(value2);
    }

    @Nullable
    public final Double getDouble(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getDouble(value2);
    }

    @Nullable
    public final BigDecimal getBigDecimal(@NotNull RdGetValueResponse value2, @Nullable Integer scale) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        BigDecimal result2 = converter.getBigDecimal(value2);
        if (result2 != null && scale != null) {
            return result2.setScale((int)scale, RoundingMode.HALF_DOWN);
        }
        return result2;
    }

    public static /* synthetic */ BigDecimal getBigDecimal$default(ValueGetter valueGetter, RdGetValueResponse rdGetValueResponse, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return valueGetter.getBigDecimal(rdGetValueResponse, n);
    }

    @Nullable
    public final byte[] getBytes(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getBytes(value2);
    }

    @Nullable
    public final Date getSqlDate(@NotNull RdGetValueResponse value2, @Nullable Calendar cal) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Cloneable timeZone = cloneable2;
        Intrinsics.checkNotNullExpressionValue(timeZone, "timeZone");
        return converter.getSqlDate(value2, (TimeZone)timeZone);
    }

    public static /* synthetic */ Date getSqlDate$default(ValueGetter valueGetter, RdGetValueResponse rdGetValueResponse, Calendar calendar, int n, Object object) {
        if ((n & 2) != 0) {
            calendar = null;
        }
        return valueGetter.getSqlDate(rdGetValueResponse, calendar);
    }

    @Nullable
    public final java.util.Date getUtilDate(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getUtilDate(value2);
    }

    @Nullable
    public final Time getTime(@NotNull RdGetValueResponse value2, @Nullable Calendar cal) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Cloneable timeZone = cloneable2;
        Intrinsics.checkNotNullExpressionValue(timeZone, "timeZone");
        return converter.getTime(value2, (TimeZone)timeZone);
    }

    public static /* synthetic */ Time getTime$default(ValueGetter valueGetter, RdGetValueResponse rdGetValueResponse, Calendar calendar, int n, Object object) {
        if ((n & 2) != 0) {
            calendar = null;
        }
        return valueGetter.getTime(rdGetValueResponse, calendar);
    }

    @Nullable
    public final Timestamp getTimestamp(@NotNull RdGetValueResponse value2, @Nullable Calendar cal) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        Cloneable cloneable2 = cal;
        if (cloneable2 == null || (cloneable2 = cloneable2.getTimeZone()) == null) {
            cloneable2 = TimeZone.getDefault();
        }
        Cloneable timeZone = cloneable2;
        Intrinsics.checkNotNullExpressionValue(timeZone, "timeZone");
        return converter.getTimestamp(value2, (TimeZone)timeZone);
    }

    public static /* synthetic */ Timestamp getTimestamp$default(ValueGetter valueGetter, RdGetValueResponse rdGetValueResponse, Calendar calendar, int n, Object object) {
        if ((n & 2) != 0) {
            calendar = null;
        }
        return valueGetter.getTimestamp(rdGetValueResponse, calendar);
    }

    @Nullable
    public final LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getLocalDateTime(value2);
    }

    @Nullable
    public final LocalDate getLocalDate(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getLocalDate(value2);
    }

    @Nullable
    public final LocalTime getLocalTime(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getLocalTime(value2);
    }

    @Nullable
    public final OffsetDateTime getOffsetDateTime(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getOffsetDateTime(value2);
    }

    @Nullable
    public final OffsetTime getOffsetTime(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getOffsetTime(value2);
    }

    @Nullable
    public final InputStream getAsciiStream(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getAsciiStream(value2);
    }

    @Nullable
    public final InputStream getBinaryStream(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getBinaryStream(value2);
    }

    @Nullable
    public final InputStream getUnicodeStream(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getUnicodeStream(value2);
    }

    @Nullable
    public final Reader getCharacterStream(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getCharacterStream(value2);
    }

    @Nullable
    public final String getNString(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getNString(value2);
    }

    @Nullable
    public final Reader getNCharacterStream(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getNCharacterStream(value2);
    }

    @Nullable
    public final Blob getBlob(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getBlob(value2);
    }

    @Nullable
    public final Clob getClob(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getClob(value2);
    }

    @NotNull
    public final Array getArray(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getArray(value2);
    }

    @NotNull
    public final URL getURL(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getURL(value2);
    }

    @NotNull
    public final RowId getRowId(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getRowId(value2);
    }

    @NotNull
    public final Ref getRef(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getRef(value2);
    }

    @Nullable
    public final NClob getNClob(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getNClob(value2);
    }

    @Nullable
    public final SQLXML getSqlXml(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getSqlXml(value2);
    }

    @Nullable
    public final UUID getUUID(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getUUID(value2);
    }

    @Nullable
    public final Object getObject(@NotNull RdGetValueResponse value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getObject(value2);
    }

    @Nullable
    public final <T> T getObject(@NotNull RdGetValueResponse value2, @NotNull Class<T> type2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(type2, "type");
        GetValueConverter converter = this.getValueConverterProvider.getConverter(value2.getType());
        return converter.getObject(value2, type2);
    }
}

