/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.connections;

import com.jetbrains.jdbc.base.connections.ProtocolNamedSavepoint;
import com.jetbrains.jdbc.base.connections.ProtocolSavepoint;
import com.jetbrains.jdbc.base.connections.ProtocolUnnamedSavepoint;
import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.models.RdConnectionInitialState;
import com.jetbrains.jdbc.base.models.RdDatabaseMetadata;
import com.jetbrains.jdbc.base.models.RdParsedStatement;
import com.jetbrains.jdbc.base.models.RdStatementWithParams;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryBlob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryNClob;
import com.jetbrains.jdbc.base.models.sql.xml.ProtocolXml;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.exceptions.WarningsContainer;
import com.jetbrains.jdbc.base.utils.exceptions.WarningsKt;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.RdConnectionExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.BasicStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.CalledStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ParameterInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.PreparedStatementInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IBasicStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.ICallableStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IPreparedStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IStatementParameterPool;
import com.jetbrains.jdbc.base.utils.protocol.properties.RdSyncProperty;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0016\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020#H\u0016J)\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00192\u0010\u0010,\u001a\f\u0012\u0006\b\u0001\u0012\u00020.\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J5\u00106\u001a\b\u0012\u0004\u0012\u0002H70\u0016\"\u0004\b\u0000\u001072\u0006\u00108\u001a\u0002H72\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u00020#0:H\u0002\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001bH\u0016J \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001bH\u0016J+\u0010C\u001a\u0004\u0018\u00010D2\b\u0010+\u001a\u0004\u0018\u00010\u00192\u0010\u0010E\u001a\f\u0012\u0006\b\u0001\u0012\u00020.\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020\u0017H\u0016J\b\u0010H\u001a\u00020\u0019H\u0016J\b\u0010I\u001a\u00020JH\u0016J\u0014\u0010I\u001a\u0004\u0018\u00010\u00192\b\u0010K\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010L\u001a\u00020\u001bH\u0016J\b\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020\u001bH\u0016J\b\u0010P\u001a\u00020\u0019H\u0016J\b\u0010Q\u001a\u00020\u001bH\u0016J\u0018\u0010R\u001a\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030T0SH\u0016J\n\u0010U\u001a\u0004\u0018\u00010VH\u0016J\b\u0010W\u001a\u00020\u0017H\u0016J\b\u0010X\u001a\u00020\u0017H\u0016J\u0010\u0010Y\u001a\u00020\u00172\u0006\u0010Z\u001a\u00020\u001bH\u0016J\u0010\u0010[\u001a\u00020\u00172\u0006\u0010\\\u001a\u00020\u001bH\u0002J\u0010\u0010]\u001a\u00020\u00172\u0006\u0010^\u001a\u00020\u001bH\u0002J\u0016\u0010_\u001a\u00020\u00172\f\u0010`\u001a\b\u0012\u0002\b\u0003\u0018\u00010TH\u0016J\u0014\u0010a\u001a\u0004\u0018\u00010\u00192\b\u0010b\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010c\u001a\u00020d2\b\u0010b\u001a\u0004\u0018\u00010\u0019H\u0016J\"\u0010c\u001a\u00020d2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001bH\u0016J*\u0010c\u001a\u00020d2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001bH\u0016J\u0012\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u0019H\u0016J)\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0010\u0010g\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0019\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010hJ\u001a\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0006\u0010i\u001a\u00020\u001bH\u0016J\"\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001bH\u0016J*\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001bH\u0016J\u001c\u0010e\u001a\u00020f2\b\u0010b\u001a\u0004\u0018\u00010\u00192\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u0012\u0010l\u001a\u00020#2\b\u0010m\u001a\u0004\u0018\u00010nH\u0016J\b\u0010o\u001a\u00020#H\u0016J\u0010\u0010o\u001a\u00020#2\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010p\u001a\u00020#2\u0006\u0010q\u001a\u00020\u0017H\u0016J\u0012\u0010r\u001a\u00020#2\b\u0010s\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010t\u001a\u00020#2\b\u0010u\u001a\u0004\u0018\u00010JH\u0016J\u0018\u0010t\u001a\u00020#2\u0006\u0010K\u001a\u00020\u00192\u0006\u0010v\u001a\u00020\u0019H\u0016J\u0010\u0010w\u001a\u00020#2\u0006\u0010\\\u001a\u00020\u001bH\u0016J\u001a\u0010x\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010y\u001a\u00020\u001bH\u0016J\u0010\u0010z\u001a\u00020#2\u0006\u0010{\u001a\u00020\u0017H\u0016J\b\u0010|\u001a\u00020nH\u0016J\u0010\u0010|\u001a\u00020n2\u0006\u0010K\u001a\u00020\u0019H\u0016J\u0012\u0010}\u001a\u00020#2\b\u0010~\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u007f\u001a\u00020#2\u0006\u0010^\u001a\u00020\u001bH\u0016J$\u0010\u0080\u0001\u001a\u00020#2\u0019\u0010\u0081\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030T\u0018\u00010SH\u0016J\t\u0010\u0082\u0001\u001a\u00020#H\u0002J'\u0010\u0083\u0001\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u001072\u000e\u0010`\u001a\n\u0012\u0004\u0012\u0002H7\u0018\u00010TH\u0016\u00a2\u0006\u0003\u0010\u0084\u0001R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"Lcom/jetbrains/jdbc/base/connections/ProtocolConnection;", "Ljava/sql/Connection;", "remoteConnection", "Lcom/jetbrains/jdbc/base/models/RdConnection;", "rdConnectionInitialState", "Lcom/jetbrains/jdbc/base/models/RdConnectionInitialState;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "basicStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IBasicStatementPool;", "preparedStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IPreparedStatementPool;", "callableStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ICallableStatementPool;", "statementParameterPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementParameterPool;", "parser", "Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "(Lcom/jetbrains/jdbc/base/models/RdConnection;Lcom/jetbrains/jdbc/base/models/RdConnectionInitialState;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IBasicStatementPool;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IPreparedStatementPool;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ICallableStatementPool;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementParameterPool;Lcom/jetbrains/jdbc/base/statements/IStatementParser;)V", "currentAutoCommitMode", "Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdSyncProperty;", "", "currentCatalog", "", "currentHoldability", "", "currentIsolation", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "savepointId", "warningsContainer", "Lcom/jetbrains/jdbc/base/utils/exceptions/WarningsContainer;", "abort", "", "executor", "Ljava/util/concurrent/Executor;", "clearWarnings", "close", "commit", "createArrayOf", "Ljava/sql/Array;", "typeName", "elements", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/sql/Array;", "createBlob", "Ljava/sql/Blob;", "createClob", "Ljava/sql/Clob;", "createNClob", "Ljava/sql/NClob;", "createProperty", "T", "initialValue", "call", "Lcom/jetbrains/rd/framework/IRdCall;", "(Ljava/lang/Object;Lcom/jetbrains/rd/framework/IRdCall;)Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdSyncProperty;", "createSQLXML", "Ljava/sql/SQLXML;", "createStatement", "Ljava/sql/Statement;", "resultSetType", "resultSetConcurrency", "resultSetHoldability", "createStruct", "Ljava/sql/Struct;", "attributes", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/sql/Struct;", "getAutoCommit", "getCatalog", "getClientInfo", "Ljava/util/Properties;", "name", "getHoldability", "getMetaData", "Ljava/sql/DatabaseMetaData;", "getNetworkTimeout", "getSchema", "getTransactionIsolation", "getTypeMap", "", "Ljava/lang/Class;", "getWarnings", "Ljava/sql/SQLWarning;", "isClosed", "isReadOnly", "isValid", "timeout", "isValidHoldability", "holdability", "isValidIsolationLevel", "level", "isWrapperFor", "iface", "nativeSQL", "sql", "prepareCall", "Ljava/sql/CallableStatement;", "prepareStatement", "Ljava/sql/PreparedStatement;", "columnNames", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "autoGeneratedKeys", "columnIndexes", "", "releaseSavepoint", "savepoint", "Ljava/sql/Savepoint;", "rollback", "setAutoCommit", "autoCommit", "setCatalog", "catalog", "setClientInfo", "properties", "value", "setHoldability", "setNetworkTimeout", "milliseconds", "setReadOnly", "readOnly", "setSavepoint", "setSchema", "schema", "setTransactionIsolation", "setTypeMap", "map", "throwIfClosed", "unwrap", "(Ljava/lang/Class;)Ljava/lang/Object;", "Frontend"})
public class ProtocolConnection
implements Connection {
    @NotNull
    private final RdConnection remoteConnection;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final JdbcFactory jdbcFactory;
    @NotNull
    private final IBasicStatementPool basicStatementPool;
    @NotNull
    private final IPreparedStatementPool preparedStatementPool;
    @NotNull
    private final ICallableStatementPool callableStatementPool;
    @NotNull
    private final IStatementParameterPool statementParameterPool;
    @NotNull
    private final IStatementParser parser;
    @NotNull
    private final Lifetime lifetime;
    private int savepointId;
    @NotNull
    private final WarningsContainer warningsContainer;
    @NotNull
    private final RdSyncProperty<String> currentCatalog;
    @NotNull
    private final RdSyncProperty<Integer> currentHoldability;
    @NotNull
    private final RdSyncProperty<Integer> currentIsolation;
    @NotNull
    private final RdSyncProperty<Boolean> currentAutoCommitMode;

    public ProtocolConnection(@NotNull RdConnection remoteConnection, @NotNull RdConnectionInitialState rdConnectionInitialState, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull JdbcFactory jdbcFactory, @NotNull IBasicStatementPool basicStatementPool2, @NotNull IPreparedStatementPool preparedStatementPool2, @NotNull ICallableStatementPool callableStatementPool2, @NotNull IStatementParameterPool statementParameterPool2, @NotNull IStatementParser parser) {
        Intrinsics.checkNotNullParameter(remoteConnection, "remoteConnection");
        Intrinsics.checkNotNullParameter(rdConnectionInitialState, "rdConnectionInitialState");
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        Intrinsics.checkNotNullParameter(basicStatementPool2, "basicStatementPool");
        Intrinsics.checkNotNullParameter(preparedStatementPool2, "preparedStatementPool");
        Intrinsics.checkNotNullParameter(callableStatementPool2, "callableStatementPool");
        Intrinsics.checkNotNullParameter(statementParameterPool2, "statementParameterPool");
        Intrinsics.checkNotNullParameter(parser, "parser");
        this.remoteConnection = remoteConnection;
        this.lifetimeDefinition = lifetimeDefinition;
        this.jdbcFactory = jdbcFactory;
        this.basicStatementPool = basicStatementPool2;
        this.preparedStatementPool = preparedStatementPool2;
        this.callableStatementPool = callableStatementPool2;
        this.statementParameterPool = statementParameterPool2;
        this.parser = parser;
        this.lifetime = this.lifetimeDefinition.getLifetime();
        this.warningsContainer = new WarningsContainer();
        this.currentCatalog = this.createProperty(rdConnectionInitialState.getCatalog(), this.remoteConnection.getSetCatalog());
        this.currentHoldability = this.createProperty(rdConnectionInitialState.getResultSetHoldability(), this.remoteConnection.getSetResultSetHoldability());
        this.currentIsolation = this.createProperty(rdConnectionInitialState.getIsolationLevel(), this.remoteConnection.getSetIsolationLevel());
        this.currentAutoCommitMode = this.createProperty(rdConnectionInitialState.getAutoCommit(), this.remoteConnection.getSetAutoCommit());
        this.lifetimeDefinition.getLifetime().onTermination(new Function0<Unit>(){

            @Override
            public final void invoke() {
                ProtocolUtilsKt.fireOnScheduler(remoteConnection.getClose(), JdbcModelExtKt.getScheduler(remoteConnection));
            }
        });
    }

    @Override
    @Nullable
    public <T> T unwrap(@Nullable Class<T> iface) {
        T t = null;
        if (iface == null) {
            return t;
        }
        try {
            iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage());
        }
        return t;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        Class<?> clazz = iface;
        return clazz != null ? clazz.isInstance(this) : false;
    }

    @Override
    public void close() {
        LifetimeDefinition.terminate$default(this.lifetimeDefinition, false, 1, null);
    }

    @Override
    @NotNull
    public Statement createStatement() {
        return this.createStatement(1003, 1007, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return this.createStatement(resultSetType, resultSetConcurrency, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.throwIfClosed();
        BasicStatementInitializationData rdStatement = this.basicStatementPool.rent(this.remoteConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.jdbcFactory.createStatement(this, rdStatement, this.lifetimeDefinition.getLifetime());
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql) {
        return this.prepareStatement(sql, 1003, 1007, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql, int resultSetType, int resultSetConcurrency) {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.throwIfClosed();
        if (sql == null) {
            throw ExceptionsKt.invalidSql();
        }
        RdParsedStatement parsedStatement = this.parser.parseSqlWithParams(sql);
        PreparedStatementInitializationData rdPreparedStatement = this.preparedStatementPool.rent(this.remoteConnection, parsedStatement, resultSetType, resultSetConcurrency, resultSetHoldability);
        List<ParameterInitializationData> rdParameters = this.statementParameterPool.rentParameters((RdStatementWithParams)rdPreparedStatement.getModel(), parsedStatement.getParameterPositions().size());
        return this.jdbcFactory.createPreparedStatement(this, rdPreparedStatement, rdParameters, this.lifetimeDefinition.getLifetime());
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql, int autoGeneratedKeys) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql, @Nullable int[] columnIndexes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public PreparedStatement prepareStatement(@Nullable String sql, @Nullable String[] columnNames) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public CallableStatement prepareCall(@Nullable String sql) {
        return this.prepareCall(sql, 1003, 1007, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public CallableStatement prepareCall(@Nullable String sql, int resultSetType, int resultSetConcurrency) {
        this.throwIfClosed();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, ((Number)this.currentHoldability.get()).intValue());
    }

    @Override
    @NotNull
    public CallableStatement prepareCall(@Nullable String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.throwIfClosed();
        if (sql == null) {
            throw ExceptionsKt.invalidSql();
        }
        RdParsedStatement parsedStatement = this.parser.parseSqlWithParams(sql);
        CalledStatementInitializationData rdCallableStatement = this.callableStatementPool.rent(this.remoteConnection, parsedStatement, resultSetType, resultSetConcurrency, resultSetHoldability);
        List<ParameterInitializationData> parameters2 = this.statementParameterPool.rentParameters((RdStatementWithParams)rdCallableStatement.getModel(), parsedStatement.getParameterPositions().size());
        return this.jdbcFactory.createCallableStatement(this, rdCallableStatement, parameters2, this.lifetimeDefinition.getLifetime());
    }

    @Override
    @Nullable
    public String nativeSQL(@Nullable String sql) {
        this.throwIfClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.throwIfClosed();
        if (autoCommit) {
            RdConnectionExtKt.commit(this.remoteConnection, this.lifetime);
        }
        this.currentAutoCommitMode.set(autoCommit);
    }

    @Override
    public boolean getAutoCommit() {
        this.throwIfClosed();
        return this.currentAutoCommitMode.get();
    }

    @Override
    public void commit() {
        this.throwIfClosed();
        if (!this.currentAutoCommitMode.get().booleanValue()) {
            RdConnectionExtKt.commit(this.remoteConnection, this.lifetime);
        }
    }

    @Override
    public void rollback() {
        this.throwIfClosed();
        if (this.currentAutoCommitMode.get().booleanValue()) {
            throw ExceptionsKt.cantRollbackWhenAutoCommit();
        }
        RdConnectionExtKt.rollback(this.remoteConnection, this.lifetime);
    }

    @Override
    public void rollback(@NotNull Savepoint savepoint) {
        Intrinsics.checkNotNullParameter(savepoint, "savepoint");
        this.throwIfClosed();
        if (this.currentAutoCommitMode.get().booleanValue()) {
            throw ExceptionsKt.cantRollbackWhenAutoCommit();
        }
        ProtocolSavepoint protocolSavepoint = (ProtocolSavepoint)savepoint;
        RdConnectionExtKt.rollback(this.remoteConnection, this.lifetime, protocolSavepoint.getSavepointLabel());
    }

    @Override
    public boolean isClosed() {
        return !RLifetimeKt.isAlive(this.lifetime);
    }

    @Override
    @NotNull
    public DatabaseMetaData getMetaData() {
        this.throwIfClosed();
        RdDatabaseMetadata response = InterfacesKt.getValueOrThrow(this.remoteConnection.getMetadata());
        return this.jdbcFactory.createDatabaseMetadata(this, response, this.lifetime);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.throwIfClosed();
    }

    @Override
    public boolean isReadOnly() {
        this.throwIfClosed();
        return false;
    }

    @Override
    public void setCatalog(@Nullable String catalog) {
        this.throwIfClosed();
        if (catalog == null) {
            return;
        }
        this.currentCatalog.set(catalog);
    }

    @Override
    @NotNull
    public String getCatalog() {
        this.throwIfClosed();
        return this.currentCatalog.get();
    }

    @Override
    public void setTransactionIsolation(int level) {
        this.throwIfClosed();
        if (level == 0) {
            return;
        }
        if (!this.isValidIsolationLevel(level)) {
            throw ExceptionsKt.invalidTransactionIsolationLevel(level);
        }
        this.currentIsolation.set(level);
    }

    @Override
    public int getTransactionIsolation() {
        this.throwIfClosed();
        return ((Number)this.currentIsolation.get()).intValue();
    }

    @Override
    @Nullable
    public SQLWarning getWarnings() {
        this.throwIfClosed();
        return this.warningsContainer.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.throwIfClosed();
        this.warningsContainer.clearWarnings();
    }

    @Override
    @NotNull
    public Map<String, Class<?>> getTypeMap() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(@Nullable Map<String, Class<?>> map2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) {
        this.throwIfClosed();
        if (!this.isValidHoldability(holdability)) {
            throw ExceptionsKt.invalidHoldability(holdability);
        }
        this.currentHoldability.set(holdability);
    }

    @Override
    public int getHoldability() {
        this.throwIfClosed();
        return ((Number)this.currentHoldability.get()).intValue();
    }

    @Override
    @NotNull
    public Savepoint setSavepoint() {
        this.throwIfClosed();
        if (this.currentAutoCommitMode.get().booleanValue()) {
            throw ExceptionsKt.cantSetSavepointWhenAutoCommit();
        }
        ++this.savepointId;
        ProtocolUnnamedSavepoint savepoint = new ProtocolUnnamedSavepoint(this.savepointId);
        RdConnectionExtKt.setSavepoint(this.remoteConnection, this.lifetime, savepoint.getSavepointLabel());
        return savepoint;
    }

    @Override
    @NotNull
    public Savepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.throwIfClosed();
        if (this.currentAutoCommitMode.get().booleanValue()) {
            throw ExceptionsKt.cantSetSavepointWhenAutoCommit();
        }
        ProtocolNamedSavepoint savepoint = new ProtocolNamedSavepoint(name);
        RdConnectionExtKt.setSavepoint(this.remoteConnection, this.lifetime, savepoint.getSavepointLabel());
        return savepoint;
    }

    @Override
    public void releaseSavepoint(@Nullable Savepoint savepoint) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public Clob createClob() {
        this.throwIfClosed();
        return new ProtocolInMemoryClob("");
    }

    @Override
    @NotNull
    public Blob createBlob() {
        this.throwIfClosed();
        return new ProtocolInMemoryBlob(new byte[0]);
    }

    @Override
    @NotNull
    public NClob createNClob() {
        this.throwIfClosed();
        return new ProtocolInMemoryNClob("");
    }

    @Override
    @NotNull
    public SQLXML createSQLXML() {
        this.throwIfClosed();
        return new ProtocolXml();
    }

    @Override
    public boolean isValid(int timeout) {
        if (timeout < 0) {
            throw ExceptionsKt.invalidQueryTimeout(timeout);
        }
        if (this.isClosed()) {
            return false;
        }
        return RdConnectionExtKt.checkIfValid(this.remoteConnection, this.lifetime, timeout);
    }

    @Override
    public void setClientInfo(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.throwIfClosed();
        this.warningsContainer.addWarning(WarningsKt.setPropertyIsNoOp());
    }

    @Override
    public void setClientInfo(@Nullable Properties properties2) {
        Enumeration<Object> keys2;
        this.throwIfClosed();
        Properties properties3 = properties2;
        Enumeration<Object> enumeration = keys2 = properties3 != null ? properties3.keys() : null;
        if (keys2 != null) {
            while (keys2.hasMoreElements()) {
                this.warningsContainer.addWarning(WarningsKt.setPropertyIsNoOp());
            }
        }
    }

    @Override
    @Nullable
    public String getClientInfo(@Nullable String name) {
        this.throwIfClosed();
        return null;
    }

    @Override
    @NotNull
    public Properties getClientInfo() {
        this.throwIfClosed();
        return new Properties();
    }

    @Override
    @NotNull
    public Array createArrayOf(@Nullable String typeName, @Nullable Object[] elements) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Nullable
    public Struct createStruct(@Nullable String typeName, @Nullable Object[] attributes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(@Nullable String schema) {
        this.throwIfClosed();
        this.warningsContainer.addWarning(WarningsKt.setSchemaIsNoOp());
    }

    @Override
    @NotNull
    public String getSchema() {
        this.throwIfClosed();
        return RdConnectionExtKt.getSchema(this.remoteConnection, this.lifetime);
    }

    @Override
    public void abort(@Nullable Executor executor2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(@Nullable Executor executor2, int milliseconds) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() {
        throw new SQLFeatureNotSupportedException();
    }

    private final void throwIfClosed() {
        if (this.isClosed()) {
            throw ExceptionsKt.connectionClosed();
        }
    }

    private final <T> RdSyncProperty<T> createProperty(T initialValue, IRdCall<? super T, Unit> call) {
        return new RdSyncProperty<T>(initialValue, this.lifetime, JdbcModelExtKt.getScheduler(this.remoteConnection), call);
    }

    private final boolean isValidIsolationLevel(int level) {
        return level == 1 || level == 2 || level == 4 || level == 8;
    }

    private final boolean isValidHoldability(int holdability) {
        return holdability == 2 || holdability == 1;
    }
}

