/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class NodeIterator
implements Iterator {
    private PsiElement node;

    public NodeIterator(PsiElement contextNode) {
        this.node = this.getFirstNode(contextNode);
        while (!NodeIterator.isXPathNode(this.node)) {
            this.node = this.getNextNode(this.node);
        }
    }

    @Override
    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        PsiElement ret = this.node;
        this.node = this.getNextNode(this.node);
        while (!NodeIterator.isXPathNode(this.node)) {
            this.node = this.getNextNode(this.node);
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract PsiElement getFirstNode(PsiElement var1);

    protected abstract PsiElement getNextNode(PsiElement var1);

    private static boolean isXPathNode(PsiElement node) {
        return true;
    }
}

