/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage;

import com.microsoft.alm.helpers.Environment;
import com.microsoft.alm.helpers.IOHelper;
import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.helpers.SystemHelper;
import com.microsoft.alm.helpers.XmlHelper;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class InsecureFileBackend {
    private static final Logger logger = LoggerFactory.getLogger(InsecureFileBackend.class);
    public static final String PROGRAM_FOLDER_NAME = "VSTeamServicesAuthPlugin";
    private final File backingFile;
    final Map<String, Token> Tokens = new HashMap<String, Token>();
    final Map<String, Credential> Credentials = new HashMap<String, Credential>();
    private static InsecureFileBackend instance;

    public static synchronized InsecureFileBackend getInstance() {
        if (instance == null) {
            instance = new InsecureFileBackend(InsecureFileBackend.getBackingFile());
        }
        return instance;
    }

    InsecureFileBackend(File backingFile) {
        this.backingFile = backingFile;
        this.reload();
    }

    void reload() {
        if (this.backingFile != null && this.backingFile.isFile() && this.backingFile.length() > 0L) {
            FileInputStream fis;
            block5: {
                fis = null;
                try {
                    fis = new FileInputStream(this.backingFile);
                    InsecureFileBackend clone = InsecureFileBackend.fromXml(fis);
                    if (clone == null) break block5;
                    this.Tokens.clear();
                    this.Tokens.putAll(clone.Tokens);
                    this.Credentials.clear();
                    this.Credentials.putAll(clone.Credentials);
                }
                catch (FileNotFoundException e) {
                    try {
                        logger.info("backingFile {} did not exist", (Object)this.backingFile.getAbsolutePath());
                    }
                    catch (Throwable throwable) {
                        IOHelper.closeQuietly(fis);
                        throw throwable;
                    }
                    IOHelper.closeQuietly(fis);
                }
            }
            IOHelper.closeQuietly(fis);
        }
    }

    void save() {
        block6: {
            if (this.backingFile == null) break block6;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.backingFile);
                this.toXml(fos);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new Error("Error during save()", e);
                }
                catch (Throwable throwable) {
                    IOHelper.closeQuietly(fos);
                    throw throwable;
                }
            }
            IOHelper.closeQuietly(fos);
            if (!(this.backingFile.setReadable(false, false) && this.backingFile.setWritable(false, false) && this.backingFile.setExecutable(false, false))) {
                logger.warn("Unable to remove file permissions for everybody: {}", (Object)this.backingFile);
            }
            if (!(this.backingFile.setReadable(true, true) && this.backingFile.setWritable(true, true) && this.backingFile.setExecutable(false, true))) {
                logger.warn("Unable to set file permissions for owner: {}", (Object)this.backingFile);
            }
        }
    }

    static InsecureFileBackend fromXml(InputStream source) {
        try {
            InsecureFileBackend result = new InsecureFileBackend(null);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(source);
            Element insecureStoreElement = document.getDocumentElement();
            NodeList tokensOrCredentialsList = insecureStoreElement.getChildNodes();
            for (int toc = 0; toc < tokensOrCredentialsList.getLength(); ++toc) {
                Node tokensOrCredentials = tokensOrCredentialsList.item(toc);
                if (tokensOrCredentials.getNodeType() != 1) continue;
                if ("Tokens".equals(tokensOrCredentials.getNodeName())) {
                    result.Tokens.clear();
                } else {
                    if (!"Credentials".equals(tokensOrCredentials.getNodeName())) continue;
                    result.Credentials.clear();
                }
                NodeList entryList = tokensOrCredentials.getChildNodes();
                for (int e = 0; e < entryList.getLength(); ++e) {
                    Node entryNode = entryList.item(e);
                    if (entryNode.getNodeType() != 1 || !"entry".equals(entryNode.getNodeName())) continue;
                    if ("Tokens".equals(tokensOrCredentials.getNodeName())) {
                        InsecureFileBackend.loadToken(result, entryNode);
                        continue;
                    }
                    if (!"Credentials".equals(tokensOrCredentials.getNodeName())) continue;
                    InsecureFileBackend.loadCredential(result, entryNode);
                }
            }
            return result;
        }
        catch (Exception e) {
            LoggingHelper.logError(logger, "Warning: unable to deserialize InsecureFileBackend. Is the file corrupted?", e);
            return null;
        }
    }

    private static void loadCredential(InsecureFileBackend result, Node entryNode) {
        String key = null;
        Credential value = null;
        NodeList keyOrValueList = entryNode.getChildNodes();
        for (int kov = 0; kov < keyOrValueList.getLength(); ++kov) {
            Node keyOrValueNode = keyOrValueList.item(kov);
            if (keyOrValueNode.getNodeType() != 1) continue;
            String keyOrValueName = keyOrValueNode.getNodeName();
            if ("key".equals(keyOrValueName)) {
                key = XmlHelper.getText(keyOrValueNode);
                continue;
            }
            if (!"value".equals(keyOrValueName)) continue;
            value = Credential.fromXml(keyOrValueNode);
        }
        result.Credentials.put(key, value);
    }

    private static void loadToken(InsecureFileBackend result, Node entryNode) {
        String key = null;
        Token value = null;
        NodeList keyOrValueList = entryNode.getChildNodes();
        for (int kov = 0; kov < keyOrValueList.getLength(); ++kov) {
            Node keyOrValueNode = keyOrValueList.item(kov);
            if (keyOrValueNode.getNodeType() != 1) continue;
            String keyOrValueName = keyOrValueNode.getNodeName();
            if ("key".equals(keyOrValueName)) {
                key = XmlHelper.getText(keyOrValueNode);
                continue;
            }
            if (!"value".equals(keyOrValueName)) continue;
            value = Token.fromXml(keyOrValueNode);
        }
        result.Tokens.put(key, value);
    }

    void toXml(OutputStream destination) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element insecureStoreNode = document.createElement("insecureStore");
            insecureStoreNode.appendChild(this.createTokensNode(document));
            insecureStoreNode.appendChild(this.createCredentialsNode(document));
            document.appendChild(insecureStoreNode);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(document), new StreamResult(destination));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private Element createTokensNode(Document document) {
        Element tokensNode = document.createElement("Tokens");
        for (Map.Entry<String, Token> entry : this.Tokens.entrySet()) {
            Element entryNode = document.createElement("entry");
            Element keyNode = document.createElement("key");
            Text keyValue = document.createTextNode(entry.getKey());
            keyNode.appendChild(keyValue);
            entryNode.appendChild(keyNode);
            Token value = entry.getValue();
            if (value != null) {
                Element valueNode = value.toXml(document);
                entryNode.appendChild(valueNode);
            }
            tokensNode.appendChild(entryNode);
        }
        return tokensNode;
    }

    private Element createCredentialsNode(Document document) {
        Element credentialsNode = document.createElement("Credentials");
        for (Map.Entry<String, Credential> entry : this.Credentials.entrySet()) {
            Element entryNode = document.createElement("entry");
            Element keyNode = document.createElement("key");
            Text keyValue = document.createTextNode(entry.getKey());
            keyNode.appendChild(keyValue);
            entryNode.appendChild(keyNode);
            Credential value = entry.getValue();
            if (value != null) {
                Element valueNode = value.toXml(document);
                entryNode.appendChild(valueNode);
            }
            credentialsNode.appendChild(entryNode);
        }
        return credentialsNode;
    }

    public synchronized boolean delete(String targetName) {
        if (this.Tokens.containsKey(targetName)) {
            this.Tokens.remove(targetName);
            this.save();
        } else if (this.Credentials.containsKey(targetName)) {
            this.Credentials.remove(targetName);
            this.save();
        }
        return true;
    }

    public synchronized Credential readCredentials(String targetName) {
        return this.Credentials.get(targetName);
    }

    public synchronized Token readToken(String targetName) {
        return this.Tokens.get(targetName);
    }

    public synchronized void writeCredential(String targetName, Credential credentials) {
        this.Credentials.put(targetName, credentials);
        this.save();
    }

    public synchronized void writeToken(String targetName, Token token2) {
        this.Tokens.put(targetName, token2);
        this.save();
    }

    private static File getBackingFile() {
        String programFolderName;
        File parentFolder = InsecureFileBackend.determineParentFolder();
        File programFolder = new File(parentFolder, programFolderName = SystemHelper.isWindows() ? PROGRAM_FOLDER_NAME : ".VSTeamServicesAuthPlugin");
        if (!programFolder.exists()) {
            programFolder.mkdirs();
        }
        File insecureFile = new File(programFolder, "insecureStore.xml");
        return insecureFile;
    }

    private static File determineParentFolder() {
        return InsecureFileBackend.findFirstValidFolder(Environment.SpecialFolder.LocalApplicationData, Environment.SpecialFolder.ApplicationData, Environment.SpecialFolder.UserProfile);
    }

    private static File findFirstValidFolder(Environment.SpecialFolder ... candidates) {
        for (Environment.SpecialFolder candidate : candidates) {
            File result;
            String path = Environment.getFolderPath(candidate);
            if (path == null || !(result = new File(path)).isDirectory()) continue;
            return result;
        }
        String path = System.getenv("HOME");
        File result = new File(path);
        return result;
    }
}

