/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.credentials.providers.vsts;

import com.google.gson.Gson;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.storage.SecretStore;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\f\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/nuget/credentials/providers/vsts/VstsNuGetInsecureTokenPairStore;", "Lcom/microsoft/alm/storage/SecretStore;", "Lcom/microsoft/alm/secret/TokenPair;", "keyPrefix", "", "<init>", "(Ljava/lang/String;)V", "get", "key", "add", "", "secret", "delete", "isSecure", "deserializeTokenPair", "value", "serializeTokenPair", "tokenPair", "Companion", "intellij.rider.nuget.credentials.providers.vsts"})
public final class VstsNuGetInsecureTokenPairStore
implements SecretStore<TokenPair> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String keyPrefix;
    @NotNull
    private static final String serviceNamePrefix = "RiderNuGetCredentialsRepo::VstsNuGetInsecureTokenPairStore::";
    @NotNull
    private static final String KEY_SEPARATOR = "::";
    @NotNull
    private static final Gson gson = new Gson();

    public VstsNuGetInsecureTokenPairStore(@NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        this.keyPrefix = keyPrefix;
    }

    @Override
    @Nullable
    public TokenPair get(@Nullable String key) {
        if (key != null) {
            try {
                TokenPair deserializedTokenPair;
                String serializedTokenPair;
                PasswordSafe store = PasswordSafe.Companion.getInstance();
                Credentials c = store.get(new CredentialAttributes(serviceNamePrefix + this.keyPrefix + KEY_SEPARATOR + key));
                if (c != null && (serializedTokenPair = c.getPasswordAsString()) != null && (deserializedTokenPair = this.deserializeTokenPair(serializedTokenPair)) != null) {
                    return deserializedTokenPair;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean add(@Nullable String key, @Nullable TokenPair secret) {
        if (key != null && secret != null) {
            try {
                PasswordSafe store = PasswordSafe.Companion.getInstance();
                String serializedTokenPair = this.serializeTokenPair(secret);
                store.set(new CredentialAttributes(serviceNamePrefix + this.keyPrefix + KEY_SEPARATOR + key), new Credentials(key, serializedTokenPair));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean delete(@Nullable String key) {
        if (key != null) {
            try {
                PasswordSafe store = PasswordSafe.Companion.getInstance();
                store.set(new CredentialAttributes(serviceNamePrefix + this.keyPrefix + KEY_SEPARATOR + key), null);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    private final TokenPair deserializeTokenPair(String value) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return (TokenPair)gson.fromJson(value, TokenPair.class);
    }

    private final String serializeTokenPair(TokenPair tokenPair) {
        return gson.toJson((Object)tokenPair);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/nuget/credentials/providers/vsts/VstsNuGetInsecureTokenPairStore$Companion;", "", "<init>", "()V", "serviceNamePrefix", "", "KEY_SEPARATOR", "gson", "Lcom/google/gson/Gson;", "createForUri", "Lcom/jetbrains/rider/nuget/credentials/providers/vsts/VstsNuGetInsecureTokenPairStore;", "uri", "Ljava/net/URI;", "intellij.rider.nuget.credentials.providers.vsts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VstsNuGetInsecureTokenPairStore createForUri(@NotNull URI uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new VstsNuGetInsecureTokenPairStore(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

