/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.Parser;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.InternalJewelApi;
import org.jetbrains.jewel.foundation.code.MimeType;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.MarkdownMode;
import org.jetbrains.jewel.markdown.extensions.MarkdownBlockProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownDelimitedInlineProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownProcessorExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownParserFactory;
import org.jetbrains.jewel.markdown.processing.ProcessingUtilKt;
import org.jetbrains.jewel.markdown.scrolling.ScrollingSynchronizer;

@ExperimentalJewelApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002STB+\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u0015\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00030\u00160\u0003H\u0001\u00a2\u0006\u0002\b\u0019J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b#J+\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\u0003H\u0001\u00a2\u0006\u0002\b)J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u001d*\u00020,H\u0002J \u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u001dH\u0002J\f\u00101\u001a\u000202*\u000203H\u0002J\f\u00104\u001a\u000205*\u000206H\u0002J\u000e\u00107\u001a\u0004\u0018\u000108*\u000209H\u0002J\f\u0010:\u001a\u00020;*\u00020<H\u0002J\f\u0010:\u001a\u00020=*\u00020>H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010@*\u00020AH\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010B*\u00020CH\u0002J\u0012\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0003*\u00020FH\u0002J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00032\u0006\u0010H\u001a\u00020,H\u0007J \u0010I\u001a\u00020.*\u00020,2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020.0KH\u0002J \u0010L\u001a\u00020.*\u00020,2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020.0KH\u0002J\u000e\u0010M\u001a\u0004\u0018\u00010N*\u00020OH\u0002J\u0011\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0004H\u0087\u0002J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "", "extensions", "", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownProcessorExtension;", "markdownMode", "Lorg/jetbrains/jewel/markdown/MarkdownMode;", "commonMarkParser", "Lorg/commonmark/parser/Parser;", "<init>", "(Ljava/util/List;Lorg/jetbrains/jewel/markdown/MarkdownMode;Lorg/commonmark/parser/Parser;)V", "getExtensions", "()Ljava/util/List;", "blockExtensions", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownBlockProcessorExtension;", "getBlockExtensions", "delimitedInlineExtensions", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownDelimitedInlineProcessorExtension;", "getDelimitedInlineExtensions", "currentState", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "getCurrentIndexesInTest", "", "Lorg/commonmark/node/SourceSpan;", "kotlin.jvm.PlatformType", "getCurrentIndexesInTest$intellij_platform_jewel_markdown_core", "scrollingSynchronizer", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "processMarkdownDocument", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "rawMarkdown", "", "doProcess", "processWithQuickEdits", "Lorg/commonmark/node/Block;", "processWithQuickEdits$intellij_platform_jewel_markdown_core", "findChangedBlocks", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$FindChangedBlocksResult;", "previousText", "updatedText", "previousBlocks", "findChangedBlocks$intellij_platform_jewel_markdown_core", "parseRawMarkdown", "tryProcessMarkdownBlock", "Lorg/commonmark/node/Node;", "postProcess", "", "block", "mdBlock", "toMarkdownParagraph", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Paragraph;", "Lorg/commonmark/node/Paragraph;", "toMarkdownBlockQuote", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$BlockQuote;", "Lorg/commonmark/node/BlockQuote;", "toMarkdownHeadingOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Heading;", "Lorg/commonmark/node/Heading;", "toMarkdownCodeBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$FencedCodeBlock;", "Lorg/commonmark/node/FencedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$IndentedCodeBlock;", "Lorg/commonmark/node/IndentedCodeBlock;", "toMarkdownListOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$UnorderedList;", "Lorg/commonmark/node/BulletList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$OrderedList;", "Lorg/commonmark/node/OrderedList;", "processListItems", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "Lorg/commonmark/node/ListBlock;", "processChildren", "node", "forEachChild", "action", "Lkotlin/Function1;", "traverseAll", "toMarkdownHtmlBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$HtmlBlock;", "Lorg/commonmark/node/HtmlBlock;", "plus", "extension", "withExtension", "FindChangedBlocksResult", "State", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMarkdownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1611#2,9:330\n1863#2:339\n1864#2:341\n1620#2:342\n1611#2,9:343\n1863#2:352\n1864#2:354\n1620#2:355\n1611#2,9:356\n1863#2:365\n1864#2:367\n1620#2:368\n1557#2:369\n1628#2,3:370\n388#2,7:373\n360#2,7:381\n1557#2:388\n1628#2,3:389\n1557#2:392\n1628#2,3:393\n1#3:340\n1#3:353\n1#3:366\n1#3:380\n*S KotlinDebug\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n*L\n68#1:330,9\n68#1:339\n68#1:341\n68#1:342\n75#1:343,9\n75#1:352\n75#1:354\n75#1:355\n112#1:356,9\n112#1:365\n112#1:367\n112#1:368\n185#1:369\n185#1:370,3\n187#1:373,7\n188#1:381,7\n135#1:388\n135#1:389,3\n152#1:392\n152#1:393,3\n68#1:340\n75#1:353\n112#1:366\n*E\n"})
public final class MarkdownProcessor {
    @NotNull
    private final List<MarkdownProcessorExtension> extensions;
    @NotNull
    private final MarkdownMode markdownMode;
    @NotNull
    private final Parser commonMarkParser;
    @NotNull
    private final List<MarkdownBlockProcessorExtension> blockExtensions;
    @NotNull
    private final List<MarkdownDelimitedInlineProcessorExtension> delimitedInlineExtensions;
    @NotNull
    private State currentState;
    @Nullable
    private final ScrollingSynchronizer scrollingSynchronizer;
    public static final int $stable = 8;

    public MarkdownProcessor(@NotNull List<? extends MarkdownProcessorExtension> extensions, @NotNull MarkdownMode markdownMode, @NotNull Parser commonMarkParser) {
        Object it$iv$iv;
        boolean bl;
        MarkdownProcessorExtension it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)markdownMode, (String)"markdownMode");
        Intrinsics.checkNotNullParameter((Object)commonMarkParser, (String)"commonMarkParser");
        this.extensions = extensions;
        this.markdownMode = markdownMode;
        this.commonMarkParser = commonMarkParser;
        Iterable iterable = this.extensions;
        MarkdownProcessor markdownProcessor = this;
        boolean $i$f$mapNotNull = false;
        void var6_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (MarkdownProcessorExtension)element$iv$iv;
            boolean bl3 = false;
            if (it.getBlockProcessorExtension() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        markdownProcessor.blockExtensions = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.extensions;
        markdownProcessor = this;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (MarkdownProcessorExtension)element$iv$iv;
            boolean bl4 = false;
            if (it.getDelimitedInlineProcessorExtension() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        markdownProcessor.delimitedInlineExtensions = (List)destination$iv$iv;
        this.currentState = new State("", CollectionsKt.emptyList());
        MarkdownMode markdownMode2 = this.markdownMode;
        MarkdownMode.EditorPreview editorPreview = markdownMode2 instanceof MarkdownMode.EditorPreview ? (MarkdownMode.EditorPreview)markdownMode2 : null;
        this.scrollingSynchronizer = editorPreview != null ? editorPreview.getScrollingSynchronizer() : null;
    }

    public /* synthetic */ MarkdownProcessor(List list, MarkdownMode markdownMode, Parser parser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            markdownMode = MarkdownMode.Standalone.INSTANCE;
        }
        if ((n & 4) != 0) {
            parser = MarkdownParserFactory.create$default(MarkdownParserFactory.INSTANCE, markdownMode instanceof MarkdownMode.EditorPreview, list, null, 4, null);
        }
        this(list, markdownMode, parser);
    }

    @NotNull
    public final List<MarkdownProcessorExtension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final List<MarkdownBlockProcessorExtension> getBlockExtensions() {
        return this.blockExtensions;
    }

    @NotNull
    public final List<MarkdownDelimitedInlineProcessorExtension> getDelimitedInlineExtensions() {
        return this.delimitedInlineExtensions;
    }

    @TestOnly
    @NotNull
    public final List<List<SourceSpan>> getCurrentIndexesInTest$intellij_platform_jewel_markdown_core() {
        List list;
        List $this$getCurrentIndexesInTest_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Block block : this.currentState.getBlocks()) {
            this.traverseAll(block, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.getCurrentIndexesInTest$lambda$3$lambda$2($this$getCurrentIndexesInTest_u24lambda_u243, arg_0)));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final List<MarkdownBlock> processMarkdownDocument(@Language(value="Markdown") @NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        if (this.scrollingSynchronizer == null) {
            return this.doProcess(rawMarkdown);
        }
        return (List)this.scrollingSynchronizer.process(() -> MarkdownProcessor.processMarkdownDocument$lambda$4(this, rawMarkdown));
    }

    /*
     * WARNING - void declaration
     */
    private final List<MarkdownBlock> doProcess(String rawMarkdown) {
        void $this$mapNotNullTo$iv$iv;
        List<Block> blocks = this.markdownMode instanceof MarkdownMode.EditorPreview ? this.processWithQuickEdits$intellij_platform_jewel_markdown_core(rawMarkdown) : this.parseRawMarkdown(rawMarkdown);
        Iterable $this$mapNotNull$iv = blocks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MarkdownBlock it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Block child = (Block)element$iv$iv;
            boolean bl2 = false;
            if (this.tryProcessMarkdownBlock(child) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    @NotNull
    public final List<Block> processWithQuickEdits$intellij_platform_jewel_markdown_core(@Language(value="Markdown") @NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        State state = this.currentState;
        String previousText = state.component1();
        List<Block> previousBlocks = state.component2();
        if (Intrinsics.areEqual((Object)previousText, (Object)rawMarkdown)) {
            return previousBlocks;
        }
        if (previousBlocks.isEmpty()) {
            List<Block> newBlocks = this.parseRawMarkdown(rawMarkdown);
            this.currentState = new State(rawMarkdown, newBlocks);
            return newBlocks;
        }
        FindChangedBlocksResult blocksInfo = this.findChangedBlocks$intellij_platform_jewel_markdown_core(previousText, rawMarkdown, previousBlocks);
        int firstBlock = blocksInfo.getFirstBlock();
        int blockAfterLast = blocksInfo.getBlockAfterLast();
        List<Block> updatedBlocks = this.parseRawMarkdown(blocksInfo.getUpdatedText());
        List<SourceSpan> list = previousBlocks.get(firstBlock).getSourceSpans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
        SourceSpan firstBlockOffset = (SourceSpan)CollectionsKt.first(list);
        for (Block block : updatedBlocks) {
            this.traverseAll(block, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processWithQuickEdits$lambda$7(firstBlockOffset, arg_0)));
        }
        int nCharsDelta = rawMarkdown.length() - previousText.length();
        List<Block> suffixBlocks = blockAfterLast == -1 ? CollectionsKt.emptyList() : previousBlocks.subList(blockAfterLast, previousBlocks.size());
        for (Block block : suffixBlocks) {
            this.traverseAll(block, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processWithQuickEdits$lambda$9(blocksInfo, nCharsDelta, arg_0)));
        }
        List newBlocks = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)previousBlocks.subList(0, firstBlock), (Iterable)updatedBlocks), (Iterable)suffixBlocks);
        this.currentState = new State(rawMarkdown, newBlocks);
        return newBlocks;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final FindChangedBlocksResult findChangedBlocks$intellij_platform_jewel_markdown_core(@NotNull String previousText, @NotNull String updatedText, @NotNull List<? extends Block> previousBlocks) {
        int n;
        int firstBlock;
        List previousIndexes;
        int nLinesDelta;
        int nCharsDelta;
        block5: {
            int n2;
            Object $this$indexOfLast$iv;
            int suffixPos;
            block4: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)previousText, (String)"previousText");
                Intrinsics.checkNotNullParameter((Object)updatedText, (String)"updatedText");
                Intrinsics.checkNotNullParameter(previousBlocks, (String)"previousBlocks");
                nCharsDelta = updatedText.length() - previousText.length();
                String commonPrefix = StringsKt.commonPrefixWith$default((CharSequence)previousText, (CharSequence)updatedText, (boolean)false, (int)2, null);
                int prefixPos = commonPrefix.length();
                String commonSuffix = StringsKt.commonSuffixWith$default((CharSequence)StringsKt.removePrefix((String)previousText, (CharSequence)commonPrefix), (CharSequence)StringsKt.removePrefix((String)updatedText, (CharSequence)commonPrefix), (boolean)false, (int)2, null);
                suffixPos = previousText.length() - commonSuffix.length();
                nLinesDelta = SequencesKt.count((Sequence)StringsKt.lineSequence((CharSequence)updatedText.subSequence(prefixPos, updatedText.length() - commonSuffix.length()))) - SequencesKt.count((Sequence)StringsKt.lineSequence((CharSequence)previousText.subSequence(prefixPos, suffixPos)));
                Iterable $this$map$iv = previousBlocks;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void block;
                    Block block2 = (Block)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<SourceSpan> list = block.getSourceSpans();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
                    collection.add(((SourceSpan)CollectionsKt.first(list)).getInputIndex());
                }
                previousIndexes = (List)destination$iv$iv;
                $this$indexOfLast$iv = previousIndexes;
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    int it = ((Number)iterator$iv.previous()).intValue();
                    boolean bl = false;
                    if (!(it < prefixPos)) continue;
                    n2 = iterator$iv.nextIndex();
                    break block4;
                }
                n2 = -1;
            }
            $this$indexOfLast$iv = n2;
            int it = ((Number)$this$indexOfLast$iv).intValue();
            boolean bl = false;
            Object object = it != -1 ? $this$indexOfLast$iv : null;
            firstBlock = object != null ? (Integer)object : 0;
            List $this$indexOfFirst$iv = previousIndexes;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                int it2 = ((Number)item$iv).intValue();
                boolean bl2 = false;
                if (it2 > suffixPos) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int blockAfterLast = n;
        String string = updatedText.substring(((Number)previousIndexes.get(firstBlock)).intValue(), blockAfterLast == -1 ? updatedText.length() : ((Number)previousIndexes.get(blockAfterLast)).intValue() - 1 + nCharsDelta);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String updatedText2 = string;
        return new FindChangedBlocksResult(firstBlock, blockAfterLast, updatedText2, nLinesDelta);
    }

    private final List<Block> parseRawMarkdown(@Language(value="Markdown") String rawMarkdown) {
        List list;
        Node node = this.commonMarkParser.parse(rawMarkdown);
        Document document = node instanceof Document ? (Document)node : null;
        if (document == null) {
            throw new IllegalStateException("This doesn't look like a Markdown document".toString());
        }
        Document document2 = document;
        List $this$parseRawMarkdown_u24lambda_u2415 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(document2, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.parseRawMarkdown$lambda$15$lambda$14($this$parseRawMarkdown_u24lambda_u2415, arg_0)));
        return CollectionsKt.build((List)list);
    }

    private final MarkdownBlock tryProcessMarkdownBlock(Node $this$tryProcessMarkdownBlock) {
        MarkdownBlock markdownBlock;
        Object object = $this$tryProcessMarkdownBlock;
        if (object instanceof Paragraph) {
            markdownBlock = this.toMarkdownParagraph((Paragraph)$this$tryProcessMarkdownBlock);
        } else if (object instanceof Heading) {
            markdownBlock = this.toMarkdownHeadingOrNull((Heading)$this$tryProcessMarkdownBlock);
        } else if (object instanceof BulletList) {
            markdownBlock = this.toMarkdownListOrNull((BulletList)$this$tryProcessMarkdownBlock);
        } else if (object instanceof OrderedList) {
            markdownBlock = this.toMarkdownListOrNull((OrderedList)$this$tryProcessMarkdownBlock);
        } else if (object instanceof BlockQuote) {
            markdownBlock = this.toMarkdownBlockQuote((BlockQuote)$this$tryProcessMarkdownBlock);
        } else if (object instanceof FencedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((FencedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof IndentedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((IndentedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof ThematicBreak) {
            markdownBlock = MarkdownBlock.ThematicBreak.INSTANCE;
        } else if (object instanceof HtmlBlock) {
            markdownBlock = this.toMarkdownHtmlBlockOrNull((HtmlBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof CustomBlock) {
            Object v1;
            block22: {
                Iterable iterable = this.blockExtensions;
                for (Object t : iterable) {
                    MarkdownBlockProcessorExtension it = (MarkdownBlockProcessorExtension)t;
                    boolean bl = false;
                    if (!it.canProcess((CustomBlock)$this$tryProcessMarkdownBlock)) continue;
                    v1 = t;
                    break block22;
                }
                v1 = null;
            }
            MarkdownBlockProcessorExtension markdownBlockProcessorExtension = v1;
            markdownBlock = markdownBlockProcessorExtension != null ? markdownBlockProcessorExtension.processMarkdownBlock((CustomBlock)$this$tryProcessMarkdownBlock, this) : null;
        } else {
            markdownBlock = null;
        }
        Object block = object = markdownBlock;
        boolean bl = false;
        if (this.scrollingSynchronizer != null && $this$tryProcessMarkdownBlock instanceof Block && block != null) {
            this.postProcess(this.scrollingSynchronizer, (Block)$this$tryProcessMarkdownBlock, (MarkdownBlock)block);
        }
        return object;
    }

    private final void postProcess(ScrollingSynchronizer scrollingSynchronizer, Block block, MarkdownBlock mdBlock) {
        List<SourceSpan> list;
        List<SourceSpan> it = list = block.getSourceSpans();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        List<SourceSpan> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return;
        }
        List<SourceSpan> spans = list2;
        scrollingSynchronizer.acceptBlockSpans(mdBlock, new IntRange(((SourceSpan)CollectionsKt.first(spans)).getLineIndex(), ((SourceSpan)CollectionsKt.last(spans)).getLineIndex()));
    }

    private final MarkdownBlock.Paragraph toMarkdownParagraph(Paragraph $this$toMarkdownParagraph) {
        return new MarkdownBlock.Paragraph(ProcessingUtilKt.readInlineMarkdown($this$toMarkdownParagraph, this));
    }

    private final MarkdownBlock.BlockQuote toMarkdownBlockQuote(BlockQuote $this$toMarkdownBlockQuote) {
        return new MarkdownBlock.BlockQuote(this.processChildren($this$toMarkdownBlockQuote));
    }

    private final MarkdownBlock.Heading toMarkdownHeadingOrNull(Heading $this$toMarkdownHeadingOrNull) {
        if ($this$toMarkdownHeadingOrNull.getLevel() < 1 || $this$toMarkdownHeadingOrNull.getLevel() > 6) {
            return null;
        }
        return new MarkdownBlock.Heading(ProcessingUtilKt.readInlineMarkdown($this$toMarkdownHeadingOrNull, this), $this$toMarkdownHeadingOrNull.getLevel());
    }

    private final MarkdownBlock.CodeBlock.FencedCodeBlock toMarkdownCodeBlockOrNull(FencedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
        String string3 = $this$toMarkdownCodeBlockOrNull.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInfo(...)");
        return new MarkdownBlock.CodeBlock.FencedCodeBlock(string2, MimeType.Known.INSTANCE.fromMarkdownLanguageName-YABSuFg(string3), null);
    }

    private final MarkdownBlock.CodeBlock.IndentedCodeBlock toMarkdownCodeBlockOrNull(IndentedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.CodeBlock.IndentedCodeBlock(StringsKt.trimEnd((String)string, (char[])cArray));
    }

    private final MarkdownBlock.ListBlock.UnorderedList toMarkdownListOrNull(BulletList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        String string = $this$toMarkdownListOrNull.getMarker();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarker(...)");
        return new MarkdownBlock.ListBlock.UnorderedList(children, bl, string);
    }

    private final MarkdownBlock.ListBlock.OrderedList toMarkdownListOrNull(OrderedList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        Integer n = $this$toMarkdownListOrNull.getMarkerStartNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMarkerStartNumber(...)");
        int n2 = ((Number)n).intValue();
        String string = $this$toMarkdownListOrNull.getMarkerDelimiter();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarkerDelimiter(...)");
        return new MarkdownBlock.ListBlock.OrderedList(children, bl, n2, string);
    }

    private final List<MarkdownBlock.ListItem> processListItems(ListBlock $this$processListItems) {
        List list;
        List $this$processListItems_u24lambda_u2420 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild($this$processListItems, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processListItems$lambda$20$lambda$19($this$processListItems_u24lambda_u2420, this, arg_0)));
        return CollectionsKt.build((List)list);
    }

    @InternalJewelApi
    @NotNull
    public final List<MarkdownBlock> processChildren(@NotNull Node node) {
        List list;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List $this$processChildren_u24lambda_u2422 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(node, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processChildren$lambda$22$lambda$21(this, $this$processChildren_u24lambda_u2422, arg_0)));
        return CollectionsKt.build((List)list);
    }

    private final void forEachChild(Node $this$forEachChild, Function1<? super Node, Unit> action) {
        for (Node child = $this$forEachChild.getFirstChild(); child != null; child = child.getNext()) {
            action.invoke((Object)child);
        }
    }

    private final void traverseAll(Node $this$traverseAll, Function1<? super Node, Unit> action) {
        action.invoke((Object)$this$traverseAll);
        this.forEachChild($this$traverseAll, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.traverseAll$lambda$23(this, action, arg_0)));
    }

    private final MarkdownBlock.HtmlBlock toMarkdownHtmlBlockOrNull(HtmlBlock $this$toMarkdownHtmlBlockOrNull) {
        String string = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        String string2 = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.HtmlBlock(StringsKt.trimEnd((String)string2, (char[])cArray));
    }

    @ExperimentalJewelApi
    @NotNull
    public final MarkdownProcessor plus(@NotNull MarkdownProcessorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return this.withExtension(extension);
    }

    @NotNull
    public final MarkdownProcessor withExtension(@NotNull MarkdownProcessorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return new MarkdownProcessor(CollectionsKt.plus((Collection)this.extensions, (Object)extension), this.markdownMode, this.commonMarkParser);
    }

    private static final Unit getCurrentIndexesInTest$lambda$3$lambda$2(List $this_buildList, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        $this_buildList.add(node.getSourceSpans());
        return Unit.INSTANCE;
    }

    private static final List processMarkdownDocument$lambda$4(MarkdownProcessor this$0, String $rawMarkdown) {
        return this$0.doProcess($rawMarkdown);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processWithQuickEdits$lambda$7(SourceSpan $firstBlockOffset, Node node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<SourceSpan> list = node.getSourceSpans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
        Iterable iterable = list;
        Node node2 = node;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void span;
            SourceSpan sourceSpan = (SourceSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SourceSpan.of(span.getLineIndex() + $firstBlockOffset.getLineIndex(), span.getColumnIndex(), span.getInputIndex() + $firstBlockOffset.getInputIndex(), span.getLength()));
        }
        node2.setSourceSpans((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processWithQuickEdits$lambda$9(FindChangedBlocksResult $blocksInfo, int $nCharsDelta, Node node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<SourceSpan> list = node.getSourceSpans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
        Iterable iterable = list;
        Node node2 = node;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void span;
            SourceSpan sourceSpan = (SourceSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SourceSpan.of(span.getLineIndex() + $blocksInfo.getNLinesDelta(), span.getColumnIndex(), span.getInputIndex() + $nCharsDelta, span.getLength()));
        }
        node2.setSourceSpans((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final Unit parseRawMarkdown$lambda$15$lambda$14(List $this_buildList, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (child instanceof Block) {
            $this_buildList.add(child);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processListItems$lambda$20$lambda$19(List $this_buildList, MarkdownProcessor this$0, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!(child instanceof ListItem)) {
            return Unit.INSTANCE;
        }
        $this_buildList.add(new MarkdownBlock.ListItem(this$0.processChildren(child)));
        return Unit.INSTANCE;
    }

    private static final Unit processChildren$lambda$22$lambda$21(MarkdownProcessor this$0, List $this_buildList, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        MarkdownBlock parsedBlock = this$0.tryProcessMarkdownBlock(child);
        if (parsedBlock != null) {
            $this_buildList.add(parsedBlock);
        }
        return Unit.INSTANCE;
    }

    private static final Unit traverseAll$lambda$23(MarkdownProcessor this$0, Function1 $action, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this$0.traverseAll(child, (Function1<? super Node, Unit>)$action);
        return Unit.INSTANCE;
    }

    public MarkdownProcessor() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0081\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$FindChangedBlocksResult;", "", "firstBlock", "", "blockAfterLast", "updatedText", "", "nLinesDelta", "<init>", "(IILjava/lang/String;I)V", "getFirstBlock", "()I", "getBlockAfterLast", "getUpdatedText", "()Ljava/lang/String;", "getNLinesDelta", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.jewel.markdown.core"})
    @StabilityInferred(parameters=1)
    public static final class FindChangedBlocksResult {
        private final int firstBlock;
        private final int blockAfterLast;
        @NotNull
        private final String updatedText;
        private final int nLinesDelta;
        public static final int $stable;

        public FindChangedBlocksResult(int firstBlock, int blockAfterLast, @NotNull String updatedText, int nLinesDelta) {
            Intrinsics.checkNotNullParameter((Object)updatedText, (String)"updatedText");
            this.firstBlock = firstBlock;
            this.blockAfterLast = blockAfterLast;
            this.updatedText = updatedText;
            this.nLinesDelta = nLinesDelta;
        }

        public final int getFirstBlock() {
            return this.firstBlock;
        }

        public final int getBlockAfterLast() {
            return this.blockAfterLast;
        }

        @NotNull
        public final String getUpdatedText() {
            return this.updatedText;
        }

        public final int getNLinesDelta() {
            return this.nLinesDelta;
        }

        public final int component1() {
            return this.firstBlock;
        }

        public final int component2() {
            return this.blockAfterLast;
        }

        @NotNull
        public final String component3() {
            return this.updatedText;
        }

        public final int component4() {
            return this.nLinesDelta;
        }

        @NotNull
        public final FindChangedBlocksResult copy(int firstBlock, int blockAfterLast, @NotNull String updatedText, int nLinesDelta) {
            Intrinsics.checkNotNullParameter((Object)updatedText, (String)"updatedText");
            return new FindChangedBlocksResult(firstBlock, blockAfterLast, updatedText, nLinesDelta);
        }

        public static /* synthetic */ FindChangedBlocksResult copy$default(FindChangedBlocksResult findChangedBlocksResult, int n, int n2, String string, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = findChangedBlocksResult.firstBlock;
            }
            if ((n4 & 2) != 0) {
                n2 = findChangedBlocksResult.blockAfterLast;
            }
            if ((n4 & 4) != 0) {
                string = findChangedBlocksResult.updatedText;
            }
            if ((n4 & 8) != 0) {
                n3 = findChangedBlocksResult.nLinesDelta;
            }
            return findChangedBlocksResult.copy(n, n2, string, n3);
        }

        @NotNull
        public String toString() {
            return "FindChangedBlocksResult(firstBlock=" + this.firstBlock + ", blockAfterLast=" + this.blockAfterLast + ", updatedText=" + this.updatedText + ", nLinesDelta=" + this.nLinesDelta + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.firstBlock);
            result = result * 31 + Integer.hashCode(this.blockAfterLast);
            result = result * 31 + this.updatedText.hashCode();
            result = result * 31 + Integer.hashCode(this.nLinesDelta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FindChangedBlocksResult)) {
                return false;
            }
            FindChangedBlocksResult findChangedBlocksResult = (FindChangedBlocksResult)other;
            if (this.firstBlock != findChangedBlocksResult.firstBlock) {
                return false;
            }
            if (this.blockAfterLast != findChangedBlocksResult.blockAfterLast) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.updatedText, (Object)findChangedBlocksResult.updatedText)) {
                return false;
            }
            return this.nLinesDelta == findChangedBlocksResult.nLinesDelta;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "", "text", "", "blocks", "", "Lorg/commonmark/node/Block;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getBlocks", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.jewel.markdown.core"})
    private static final class State {
        @NotNull
        private final String text;
        @NotNull
        private final List<Block> blocks;

        public State(@NotNull String text, @NotNull List<? extends Block> blocks) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            this.text = text;
            this.blocks = blocks;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<Block> getBlocks() {
            return this.blocks;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<Block> component2() {
            return this.blocks;
        }

        @NotNull
        public final State copy(@NotNull String text, @NotNull List<? extends Block> blocks) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            return new State(text, blocks);
        }

        public static /* synthetic */ State copy$default(State state, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = state.text;
            }
            if ((n & 2) != 0) {
                list = state.blocks;
            }
            return state.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "State(text=" + this.text + ", blocks=" + this.blocks + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + ((Object)this.blocks).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)state.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.blocks, state.blocks);
        }
    }
}

