/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.util;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"YEAR", "", "MONTH", "DAY", "HOUR", "MINUTES", "SECONDS", "PARTIAL_SECONDS", "TIME_ZONE", "PATTERN", "regex", "Lkotlin/text/Regex;", "parseLogEntry", "Lkotlin/Pair;", "logEntry", "aspire-plugin"})
public final class LogEntryParserUtilsKt {
    @NotNull
    private static final String YEAR = "(\\d{4})";
    @NotNull
    private static final String MONTH = "(0[1-9]|1[0-2])";
    @NotNull
    private static final String DAY = "(0[1-9]|[12][0-9]|3[01])";
    @NotNull
    private static final String HOUR = "([01][0-9]|2[0-3])";
    @NotNull
    private static final String MINUTES = "([0-5][0-9])";
    @NotNull
    private static final String SECONDS = "([0-5][0-9])";
    @NotNull
    private static final String PARTIAL_SECONDS = "(\\.\\d{1,9})?";
    @NotNull
    private static final String TIME_ZONE = "(Z|([Z+-]([01][0-9]|2[0-3]):([0-5][0-9])))?";
    @NotNull
    private static final String PATTERN = "^(\\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(\\.\\d{1,9})?(Z|([Z+-]([01][0-9]|2[0-3]):([0-5][0-9])))?";
    @NotNull
    private static final Regex regex = new Regex("^(\\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(\\.\\d{1,9})?(Z|([Z+-]([01][0-9]|2[0-3]):([0-5][0-9])))?");

    @Nullable
    public static final Pair<String, String> parseLogEntry(@NotNull String logEntry) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)logEntry, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        String timestamp = match.getValue();
        if (logEntry.length() > match.getRange().getLast() + 2 && logEntry.charAt(match.getRange().getLast() + 1) == ' ') {
            String string2 = logEntry.substring(match.getRange().getLast() + 2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (logEntry.length() > match.getRange().getLast() + 1) {
            String string3 = logEntry.substring(match.getRange().getLast() + 1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = "";
        }
        String logContent = string;
        return TuplesKt.to((Object)timestamp, (Object)logContent);
    }
}

