/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.util;

import com.intellij.docker.DockerIcons;
import com.intellij.icons.AllIcons;
import com.intellij.ui.BadgeIconSupplier;
import com.jetbrains.rider.aspire.generated.ResourceHealthStatus;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.services.AspireResource;
import icons.RiderIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"getIcon", "Ljavax/swing/Icon;", "aspireResource", "Lcom/jetbrains/rider/aspire/services/AspireResource;", "aspire-plugin"})
public final class AspireResourceUtilsKt {
    @NotNull
    public static final Icon getIcon(@NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        ResourceType type = aspireResource.getType();
        ResourceState state = aspireResource.getState();
        ResourceHealthStatus healthStatus = aspireResource.getHealthStatus();
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> RiderIcons.RunConfigurations.DotNetProject;
            case 2 -> {
                String v1 = aspireResource.getContainerImage();
                boolean v2 = v1 != null ? StringsKt.contains$default((CharSequence)v1, (CharSequence)"postgres", (boolean)false, (int)2, null) : false;
                if (v2) {
                    yield AllIcons.Providers.Postgresql;
                }
                String v3 = aspireResource.getContainerImage();
                boolean v4 = v3 != null ? StringsKt.contains$default((CharSequence)v3, (CharSequence)"mssql", (boolean)false, (int)2, null) : false;
                if (v4) {
                    yield AllIcons.Providers.SqlServer;
                }
                String v5 = aspireResource.getContainerImage();
                boolean v6 = v5 != null ? StringsKt.contains$default((CharSequence)v5, (CharSequence)"mysql", (boolean)false, (int)2, null) : false;
                if (v6) {
                    yield AllIcons.Providers.Mysql;
                }
                String v7 = aspireResource.getContainerImage();
                boolean v8 = v7 != null ? StringsKt.contains$default((CharSequence)v7, (CharSequence)"mongo", (boolean)false, (int)2, null) : false;
                if (v8) {
                    yield AllIcons.Providers.MongoDB;
                }
                String v9 = aspireResource.getContainerImage();
                boolean v10 = v9 != null ? StringsKt.contains$default((CharSequence)v9, (CharSequence)"elasticsearch", (boolean)false, (int)2, null) : false;
                if (v10) {
                    yield AllIcons.Providers.Elasticsearch;
                }
                String v11 = aspireResource.getContainerImage();
                boolean v12 = v11 != null ? StringsKt.contains$default((CharSequence)v11, (CharSequence)"redis", (boolean)false, (int)2, null) : false;
                if (v12) {
                    yield AllIcons.Providers.Redis;
                }
                String v13 = aspireResource.getContainerImage();
                boolean v14 = v13 != null ? StringsKt.contains$default((CharSequence)v13, (CharSequence)"rabbitmq", (boolean)false, (int)2, null) : false;
                if (v14) {
                    yield AllIcons.Providers.RabbitMQ;
                }
                String v15 = aspireResource.getContainerImage();
                boolean v16 = v15 != null ? StringsKt.contains$default((CharSequence)v15, (CharSequence)"confluent", (boolean)false, (int)2, null) : false;
                if (v16) {
                    yield AllIcons.Providers.Kafka;
                }
                yield DockerIcons.Docker;
            }
            case 3 -> AllIcons.Nodes.Console;
            case 4 -> AllIcons.RunConfigurations.TestUnknown;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        ResourceState resourceState = state;
        icon2 = switch (resourceState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[resourceState.ordinal()]) {
            case 1 -> icon2;
            case 2 -> icon2;
            case 3 -> new BadgeIconSupplier(icon2).getErrorIcon();
            case 4 -> {
                if (healthStatus == ResourceHealthStatus.Healthy || healthStatus == null) {
                    yield new BadgeIconSupplier(icon2).getLiveIndicatorIcon();
                }
                yield new BadgeIconSupplier(icon2).getWarningIcon();
            }
            default -> icon2;
        };
        return icon2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.Project.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Container.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Executable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResourceState.values().length];
            try {
                nArray[ResourceState.Exited.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.Finished.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.FailedToStart.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceState.Running.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

