/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.sessionHost.projectLaunchers;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationType;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.RuntimeDetectionResult;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getAspireHostRunConfiguration", "Lcom/jetbrains/rider/aspire/run/AspireHostConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "getDotNetRuntime", "Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;", "executable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectSessionProcessLauncherUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSessionProcessLauncherUtils.kt\ncom/jetbrains/rider/aspire/sessionHost/projectLaunchers/ProjectSessionProcessLauncherUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n669#2,11:46\n*S KotlinDebug\n*F\n+ 1 ProjectSessionProcessLauncherUtils.kt\ncom/jetbrains/rider/aspire/sessionHost/projectLaunchers/ProjectSessionProcessLauncherUtilsKt\n*L\n23#1:46,11\n*E\n"})
public final class ProjectSessionProcessLauncherUtilsKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AspireHostConfiguration getAspireHostRunConfiguration(@Nullable String name, @NotNull Project project) {
        Object v0;
        block4: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (name == null) {
                return null;
            }
            AspireHostConfigurationType configurationType = (AspireHostConfigurationType)ConfigurationTypeUtil.findConfigurationType(AspireHostConfigurationType.class);
            Iterable iterable = RunManager.Companion.getInstance(project).getConfigurationsList((ConfigurationType)configurationType);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                RunConfiguration it = (RunConfiguration)element$iv;
                boolean bl = false;
                if (!(it instanceof AspireHostConfiguration && Intrinsics.areEqual((Object)((AspireHostConfiguration)it).getName(), (Object)name))) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        RunConfiguration runConfiguration = v0;
        if (runConfiguration == null) {
            LOG.warn("Unable to find Aspire run configuration type: " + name);
        }
        return runConfiguration instanceof AspireHostConfiguration ? (AspireHostConfiguration)runConfiguration : null;
    }

    @Nullable
    public static final DotNetCoreRuntime getDotNetRuntime(@NotNull DotNetExecutable executable, @NotNull Project project) {
        DotNetCoreRuntime runtime;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RuntimeDetectionResult runtimeDetectionResult = DotNetRuntime.Companion.detectRuntimeForProject(project, RunnableProjectKinds.INSTANCE.getDotNetCore(), RiderDotNetActiveRuntimeHost.Companion.getInstance(project), executable.getRuntimeType(), executable.getExePath(), executable.getProjectTfm());
        DotNetRuntime dotNetRuntime = runtimeDetectionResult != null ? runtimeDetectionResult.getRuntime() : null;
        DotNetCoreRuntime dotNetCoreRuntime = runtime = dotNetRuntime instanceof DotNetCoreRuntime ? (DotNetCoreRuntime)dotNetRuntime : null;
        if (runtime == null) {
            LOG.warn("Unable to detect runtime for executable: " + executable.getExePath());
        }
        return runtime;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.rider.aspire.sessionHost.projectLaunchers.ProjectSessionProcessLauncherUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

