/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.sessionHost;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationParameters;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationType;
import com.jetbrains.rider.aspire.services.AspireMainServiceViewContributor;
import com.jetbrains.rider.aspire.services.SessionHost;
import com.jetbrains.rider.aspire.sessionHost.SessionHostManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u000e\u0010\u000e\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/aspire/sessionHost/SessionHostManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessionHost", "Lcom/jetbrains/rider/aspire/services/SessionHost;", "getSessionHost", "()Lcom/jetbrains/rider/aspire/services/SessionHost;", "getSessionHosts", "", "getOrStartSessionHost", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopSessionHost", "", "addAspireHost", "projectFilePath", "", "removeAspireHost", "sendServiceResetEvent", "Companion", "RunListener", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostManager.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n15#3:101\n*S KotlinDebug\n*F\n+ 1 SessionHostManager.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostManager\n*L\n66#1:98\n66#1:99,2\n29#1:101\n*E\n"})
public final class SessionHostManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SessionHost sessionHost;
    @NotNull
    private static final Logger LOG;

    public SessionHostManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.sessionHost = new SessionHost(this.getServiceLifetime(), CoroutineScopeKt.childScope$default((CoroutineScope)scope, (String)"Aspire Session Host", null, (boolean)false, (int)6, null), this.project);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.sessionHost);
    }

    @NotNull
    public final SessionHost getSessionHost() {
        return this.sessionHost;
    }

    @NotNull
    public final List<SessionHost> getSessionHosts() {
        if (!this.sessionHost.getHasAspireHosts()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)this.sessionHost);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getOrStartSessionHost(@NotNull Continuation<? super SessionHost> $completion) {
        if (!($completion instanceof getOrStartSessionHost.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SessionHostManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrStartSessionHost((Continuation<? super SessionHost>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SessionHostManager.LOG.trace("Starting session host");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.sessionHost.start((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (SessionHostManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return this.sessionHost;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object stopSessionHost(@NotNull Continuation<? super Unit> $completion) {
        LOG.trace("Stopping session host");
        Object object = this.sessionHost.stop($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void addAspireHost(@NotNull String projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        boolean hasAspireHosts = this.sessionHost.getHasAspireHosts();
        Path path = Paths.get(projectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.sessionHost.addAspireHostProject(path);
        if (!hasAspireHosts) {
            this.sendServiceResetEvent();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAspireHost(@NotNull String projectFilePath) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        AspireHostConfigurationType configurationType = (AspireHostConfigurationType)ConfigurationTypeUtil.findConfigurationType(AspireHostConfigurationType.class);
        Iterable iterable = RunManager.Companion.getInstance(this.project).getConfigurationsList((ConfigurationType)configurationType);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunConfiguration it = (RunConfiguration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof AspireHostConfiguration && Intrinsics.areEqual((Object)((AspireHostConfiguration)it).getParameters().getProjectFilePath(), (Object)projectFilePath))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configurations = (List)destination$iv$iv;
        if (!((Collection)configurations).isEmpty()) {
            return;
        }
        Path path = Paths.get(projectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.sessionHost.removeAspireHostProject(path);
        if (!this.sessionHost.getHasAspireHosts()) {
            this.sendServiceResetEvent();
        }
    }

    private final void sendServiceResetEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createResetEvent(AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionHostManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/sessionHost/SessionHostManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/sessionHost/SessionHostManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostManager.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n*S KotlinDebug\n*F\n+ 1 SessionHostManager.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostManager$Companion\n*L\n27#1:98,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionHostManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionHostManager> serviceClass$iv = SessionHostManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionHostManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/aspire/sessionHost/SessionHostManager$RunListener;", "Lcom/intellij/execution/RunManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationRemoved", "aspire-plugin"})
    public static final class RunListener
    implements RunManagerListener {
        @NotNull
        private final Project project;

        public RunListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Companion.getInstance(this.project).addAspireHost(params.getProjectFilePath());
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Companion.getInstance(this.project).removeAspireHost(params.getProjectFilePath());
        }
    }
}

