/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.sessionHost;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.NetCoreRuntime;
import com.jetbrains.rider.aspire.sessionHost.SessionHostConfig;
import com.jetbrains.rider.aspire.sessionHost.SessionHostLauncher;
import com.jetbrains.rider.aspire.util.AnsiEscapeDecoderUtilsKt;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher;", "", "<init>", "()V", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "Lorg/jetbrains/annotations/NotNull;", "hostAssemblyPath", "Ljava/nio/file/Path;", "launchSessionHost", "", "config", "Lcom/jetbrains/rider/aspire/sessionHost/SessionHostConfig;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dotnetCliPath", "", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionHostLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostLauncher.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n69#2,4:96\n15#2:100\n*S KotlinDebug\n*F\n+ 1 SessionHostLauncher.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher\n*L\n49#1:96,4\n29#1:100\n*E\n"})
public final class SessionHostLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginId pluginId;
    @NotNull
    private final Path hostAssemblyPath;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RIDER_PARENT_PROCESS_ID = "RIDER_PARENT_PROCESS_ID";
    @NotNull
    private static final String RIDER_RD_PORT = "Rider_Connection__RdPort";

    /*
     * WARNING - void declaration
     */
    public SessionHostLauncher() {
        void $this$hostAssemblyPath_u24lambda_u240;
        PluginId pluginId = PluginId.getId((String)"me.rafaelldi.aspire");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        this.pluginId = pluginId;
        SessionHostLauncher sessionHostLauncher = this;
        SessionHostLauncher sessionHostLauncher2 = this;
        boolean bl = false;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)$this$hostAssemblyPath_u24lambda_u240.pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException(("Plugin " + $this$hostAssemblyPath_u24lambda_u240.pluginId + " could not be found.").toString());
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        Path path = plugin.getPluginPath();
        if (path == null) {
            throw new IllegalStateException(("Could not detect path of plugin " + plugin + " on disk.").toString());
        }
        Path basePath = path;
        Path path2 = basePath.resolve("aspire-session-host");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("aspire-session-host.dll");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        sessionHostLauncher2.hostAssemblyPath = path3;
    }

    public final void launchSessionHost(@NotNull SessionHostConfig config, @NotNull LifetimeDefinition lifetime) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        LOG.info("Starting Aspire session host");
        String dotnetCliPath = (String)NetCoreRuntime.INSTANCE.getCliPath().getValue();
        GeneralCommandLine commandLine = this.getCommandLine(dotnetCliPath, config);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Host command line: " + commandLine.getCommandLineString());
        }
        KillableColoredProcessHandler.Silent processHandler2 = new KillableColoredProcessHandler.Silent(commandLine);
        lifetime.onTermination(() -> SessionHostLauncher.launchSessionHost$lambda$2(processHandler2));
        processHandler2.addProcessListener(new ProcessListener(lifetime){
            final /* synthetic */ LifetimeDefinition $lifetime;
            {
                this.$lifetime = $lifetime;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType2) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType2, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = AnsiEscapeDecoderUtilsKt.decodeAnsiCommandsToString(string, outputType2);
                if (Intrinsics.areEqual(outputType2, (Object)ProcessOutputType.STDERR)) {
                    SessionHostLauncher.access$getLOG$cp().error(text);
                } else {
                    SessionHostLauncher.access$getLOG$cp().debug(text);
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$lifetime.executeIfAlive(() -> launchSessionHost.3.processTerminated$lambda$0(this.$lifetime));
            }

            private static final boolean processTerminated$lambda$0(LifetimeDefinition $lifetime) {
                SessionHostLauncher.access$getLOG$cp().info("Aspire session host process was terminated; terminating the lifetime");
                return $lifetime.terminate(true);
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)lifetime), null, (int)1, null));
        processHandler2.startNotify();
        LOG.trace("Aspire session host started");
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine getCommandLine(String dotnetCliPath, SessionHostConfig config) {
        void $this$getCommandLine_u24lambda_u243;
        Object object = new String[]{((Object)this.hostAssemblyPath).toString()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(dotnetCliPath).withCharset(StandardCharsets.UTF_8).withParameters(object).withWorkDirectory(this.hostAssemblyPath.getParent().toFile());
        Object object2 = object = MapsKt.createMapBuilder();
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        boolean bl = false;
        $this$getCommandLine_u24lambda_u243.put("Kestrel__Endpoints__Http__Url", "http://localhost:" + config.getDebugSessionPort() + "/");
        $this$getCommandLine_u24lambda_u243.put(RIDER_RD_PORT, String.valueOf(config.getRdPort()));
        $this$getCommandLine_u24lambda_u243.put(RIDER_PARENT_PROCESS_ID, String.valueOf(ProcessHandle.current().pid()));
        GeneralCommandLine generalCommandLine3 = generalCommandLine2.withEnvironment(MapsKt.build((Map)object));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withEnvironment(...)");
        GeneralCommandLine commandLine = generalCommandLine3;
        return commandLine;
    }

    private static final Unit launchSessionHost$lambda$2(KillableColoredProcessHandler.Silent $processHandler) {
        if (!$processHandler.isProcessTerminating() && !$processHandler.isProcessTerminated()) {
            LOG.info("Aspire session host lifetime was terminated; killing the process");
            $processHandler.killProcess();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionHostLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RIDER_PARENT_PROCESS_ID", "", "RIDER_RD_PORT", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionHostLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostLauncher.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,95:1\n31#2,2:96\n*S KotlinDebug\n*F\n+ 1 SessionHostLauncher.kt\ncom/jetbrains/rider/aspire/sessionHost/SessionHostLauncher$Companion\n*L\n27#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionHostLauncher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionHostLauncher> serviceClass$iv = SessionHostLauncher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionHostLauncher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

