/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.services.components;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.generated.ResourceCommand;
import com.jetbrains.rider.aspire.generated.ResourceEnvironmentVariable;
import com.jetbrains.rider.aspire.generated.ResourceHealthStatus;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceUrl;
import com.jetbrains.rider.aspire.generated.ResourceVolume;
import com.jetbrains.rider.aspire.services.AspireResource;
import com.jetbrains.rider.aspire.services.components.RowExtensionsKt;
import com.jetbrains.rider.aspire.util.AspireResourceUtilsKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/services/components/ResourceDashboardPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "aspireResource", "Lcom/jetbrains/rider/aspire/services/AspireResource;", "<init>", "(Lcom/jetbrains/rider/aspire/services/AspireResource;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "setUpPanel", "resourceData", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDashboardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDashboardPanel.kt\ncom/jetbrains/rider/aspire/services/components/ResourceDashboardPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n12567#2,2:222\n6479#2:225\n6479#2:228\n13402#2,2:231\n1#3:224\n1863#4,2:226\n1863#4,2:229\n*S KotlinDebug\n*F\n+ 1 ResourceDashboardPanel.kt\ncom/jetbrains/rider/aspire/services/components/ResourceDashboardPanel\n*L\n104#1:222,2\n120#1:225\n193#1:228\n214#1:231,2\n121#1:226,2\n194#1:229,2\n*E\n"})
public final class ResourceDashboardPanel
extends BorderLayoutPanel {
    @NotNull
    private DialogPanel panel;

    public ResourceDashboardPanel(@NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        this.panel = this.setUpPanel(aspireResource);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.panel), (int)0));
    }

    private final DialogPanel setUpPanel(AspireResource resourceData) {
        return BuilderKt.panel(arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52(resourceData, arg_0));
    }

    private static final Unit setUpPanel$lambda$52$lambda$5(AspireResource $resourceData, Row $this$row) {
        boolean bl;
        block12: {
            AnAction attachAction;
            ResourceState state;
            Object it;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Icon resourceIcon = AspireResourceUtilsKt.getIcon($resourceData);
            $this$row.icon(resourceIcon).gap(RightGap.SMALL);
            RowExtensionsKt.copyableLabel$default($this$row, $resourceData.getDisplayName(), null, null, 6, null).bold().gap(RightGap.SMALL);
            if ($resourceData.getType() == ResourceType.Project) {
                Path path = $resourceData.getProjectPath();
                if (path != null) {
                    it = path;
                    boolean bl2 = false;
                    RowExtensionsKt.copyableLabel$default($this$row, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
                }
            }
            if ($resourceData.getType() == ResourceType.Container) {
                String string = $resourceData.getContainerImage();
                if (string != null) {
                    it = string;
                    boolean bl3 = false;
                    RowExtensionsKt.copyableLabel$default($this$row, (String)it, null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
                }
            }
            if ($resourceData.getType() == ResourceType.Executable) {
                Path path = $resourceData.getExecutablePath();
                if (path != null) {
                    it = path;
                    boolean bl4 = false;
                    RowExtensionsKt.copyableLabel$default($this$row, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
                }
            }
            if ((state = $resourceData.getState()) != null) {
                Cell bl4;
                RowExtensionsKt.separator($this$row).gap(RightGap.SMALL);
                ResourceHealthStatus healthStatus = $resourceData.getHealthStatus();
                boolean hasHealthStatus = state == ResourceState.Running && healthStatus != null;
                Cell $this$setUpPanel_u24lambda_u2452_u24lambda_u245_u24lambda_u243 = bl4 = RowExtensionsKt.copyableLabel$default($this$row, state.name(), null, UIUtil.FontColor.BRIGHTER, 2, null);
                boolean bl5 = false;
                Cell cell = hasHealthStatus ? $this$setUpPanel_u24lambda_u2452_u24lambda_u245_u24lambda_u243.gap(RightGap.SMALL) : $this$setUpPanel_u24lambda_u2452_u24lambda_u245_u24lambda_u243.gap(RightGap.COLUMNS);
                if (hasHealthStatus) {
                    RowExtensionsKt.copyableLabel$default($this$row, "(" + healthStatus.name() + ")", null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.COLUMNS);
                }
            }
            AnAction startAction = ActionManager.getInstance().getAction("Aspire.Resource.Start");
            Intrinsics.checkNotNull((Object)startAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)startAction, null, (int)2, null);
            AnAction restartAction = ActionManager.getInstance().getAction("Aspire.Resource.Restart");
            Intrinsics.checkNotNull((Object)restartAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)restartAction, null, (int)2, null);
            AnAction stopAction = ActionManager.getInstance().getAction("Aspire.Resource.Stop");
            Intrinsics.checkNotNull((Object)stopAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)stopAction, null, (int)2, null);
            if ($resourceData.getType() == ResourceType.Project && $resourceData.getState() == ResourceState.Running && $resourceData.getPid() != null && Intrinsics.areEqual((Object)$resourceData.isUnderDebugger(), (Object)false)) {
                attachAction = ActionManager.getInstance().getAction("Aspire.Resource.Attach");
                Intrinsics.checkNotNull((Object)attachAction);
                ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)attachAction, null, (int)2, null);
            }
            if ($resourceData.getType() == ResourceType.Project && $resourceData.getState() == ResourceState.Running && Intrinsics.areEqual((Object)$resourceData.isUnderDebugger(), (Object)true)) {
                attachAction = ActionManager.getInstance().getAction("Aspire.Resource.NavigateToDebugTab");
                Intrinsics.checkNotNull((Object)attachAction);
                ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)attachAction, null, (int)2, null);
            }
            ResourceCommand[] $this$any$iv = $resourceData.getCommands();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ResourceCommand element$iv;
                ResourceCommand it2 = element$iv = $this$any$iv[i];
                boolean bl6 = false;
                if (!(!StringsKt.equals((String)it2.getName(), (String)"resource-start", (boolean)true) && !StringsKt.equals((String)it2.getName(), (String)"resource-stop", (boolean)true) && !StringsKt.equals((String)it2.getName(), (String)"resource-restart", (boolean)true))) continue;
                bl = true;
                break block12;
            }
            bl = false;
        }
        if (bl) {
            AnAction executeCommandAction = ActionManager.getInstance().getAction("Aspire.Resource.Execute.Command");
            Intrinsics.checkNotNull((Object)executeCommandAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)executeCommandAction, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$6(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.endpoints", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$10$lambda$9$lambda$8(ResourceUrl $url, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)$url.getFullUrl());
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$10$lambda$9(ResourceUrl $url, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link($url.getFullUrl(), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$10$lambda$9$lambda$8($url, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$11(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.properties", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$13$lambda$12(ResourceState $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.name(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$15$lambda$14(ResourceHealthStatus $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.name(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$17$lambda$16(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$19$lambda$18(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$21$lambda$20(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$23$lambda$22(int $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, String.valueOf($it), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$25$lambda$24(int $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, String.valueOf($it), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$27$lambda$26(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$29$lambda$28(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$31$lambda$30(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$33$lambda$32(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$35$lambda$34(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$37$lambda$36(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$39$lambda$38(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$41$lambda$40(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$43$lambda$42(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$44(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.volumes", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$48$lambda$47(ResourceVolume $volume, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $volume.getSource() + " : " + $volume.getTarget(), null, null, 6, null).gap(RightGap.SMALL);
        Cell $this$setUpPanel_u24lambda_u2452_u24lambda_u2448_u24lambda_u2447_u24lambda_u2446 = cell = RowExtensionsKt.copyableLabel$default($this$row, $volume.getMountType(), null, UIUtil.FontColor.BRIGHTER, 2, null);
        boolean bl = false;
        if ($volume.isReadOnly()) {
            $this$setUpPanel_u24lambda_u2452_u24lambda_u2448_u24lambda_u2447_u24lambda_u2446.gap(RightGap.SMALL);
        }
        if ($volume.isReadOnly()) {
            RowExtensionsKt.copyableLabel$default($this$row, "(" + AspireBundle.message("service.tab.dashboard.volumes.readonly", new Object[0]) + ")", null, null, 6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$49(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.environment", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52$lambda$51$lambda$50(ResourceEnvironmentVariable $variable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = $variable.getKey();
        String string2 = $variable.getValue();
        if (string2 == null) {
            string2 = "-";
        }
        RowExtensionsKt.copyableLabel$default($this$row, string + " = " + string2, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$52(AspireResource $resourceData, Panel $this$panel) {
        Enum it;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        boolean $i$f$sortedBy;
        Object[] $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$5($resourceData, arg_0), (int)1, null);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        if (!($resourceData.getUrls().length == 0)) {
            Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$52$lambda$6, (int)1, null).bottomGap(BottomGap.SMALL);
            $this$sortedBy$iv = $resourceData.getUrls();
            $i$f$sortedBy = false;
            $this$forEach$iv = (ResourceEnvironmentVariable[])ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceUrl it = (ResourceUrl)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ResourceUrl)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ResourceUrl url = (ResourceUrl)element$iv;
                boolean bl = false;
                if (url.isInternal()) continue;
                $this$panel.row(url.getName(), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$10$lambda$9(url, arg_0));
            }
            Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        }
        Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$52$lambda$11, (int)1, null).bottomGap(BottomGap.SMALL);
        ResourceState resourceState = $resourceData.getState();
        if (resourceState != null) {
            it = resourceState;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.state", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$13$lambda$12((ResourceState)it, arg_0));
        }
        ResourceHealthStatus resourceHealthStatus = $resourceData.getHealthStatus();
        if (resourceHealthStatus != null) {
            it = resourceHealthStatus;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.health.status", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$15$lambda$14((ResourceHealthStatus)it, arg_0));
        }
        LocalDateTime localDateTime = $resourceData.getCreatedAt();
        if (localDateTime != null) {
            it = localDateTime;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.creation.time", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$17$lambda$16((LocalDateTime)it, arg_0));
        }
        LocalDateTime localDateTime2 = $resourceData.getStartedAt();
        if (localDateTime2 != null) {
            it = localDateTime2;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.start.time", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$19$lambda$18((LocalDateTime)it, arg_0));
        }
        LocalDateTime localDateTime3 = $resourceData.getStoppedAt();
        if (localDateTime3 != null) {
            it = localDateTime3;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.stop.time", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$21$lambda$20((LocalDateTime)it, arg_0));
        }
        Integer n = $resourceData.getPid();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.pid", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$23$lambda$22(it2, arg_0));
        }
        Integer n2 = $resourceData.getExitCode();
        if (n2 != null) {
            int it3 = ((Number)n2).intValue();
            boolean bl = false;
            if (it3 != -1) {
                $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.exit.code", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$25$lambda$24(it3, arg_0));
            }
        }
        Path path = $resourceData.getProjectPath();
        if (path != null) {
            Path it4 = path;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.project", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$27$lambda$26(it4, arg_0));
        }
        Path path2 = $resourceData.getExecutablePath();
        if (path2 != null) {
            Path it5 = path2;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.executable", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$29$lambda$28(it5, arg_0));
        }
        Path path3 = $resourceData.getExecutableWorkDir();
        if (path3 != null) {
            Path it6 = path3;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.working.dir", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$31$lambda$30(it6, arg_0));
        }
        String string = $resourceData.getArgs();
        if (string != null) {
            String it7 = string;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.args", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$33$lambda$32(it7, arg_0));
        }
        String string2 = $resourceData.getContainerImage();
        if (string2 != null) {
            String it8 = string2;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.image", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$35$lambda$34(it8, arg_0));
        }
        String string3 = $resourceData.getContainerId();
        if (string3 != null) {
            String it9 = string3;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.id", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$37$lambda$36(it9, arg_0));
        }
        String string4 = $resourceData.getContainerPorts();
        if (string4 != null) {
            String it10 = string4;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.ports", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$39$lambda$38(it10, arg_0));
        }
        String string5 = $resourceData.getContainerCommand();
        if (string5 != null) {
            String it11 = string5;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.command", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$41$lambda$40(it11, arg_0));
        }
        String string6 = $resourceData.getContainerArgs();
        if (string6 != null) {
            String it12 = string6;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.args", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$43$lambda$42(it12, arg_0));
        }
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        if (!($resourceData.getVolumes().length == 0)) {
            Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$52$lambda$44, (int)1, null).bottomGap(BottomGap.SMALL);
            $this$sortedBy$iv = $resourceData.getVolumes();
            $i$f$sortedBy = false;
            $this$forEach$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceVolume it = (ResourceVolume)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getSource());
                    it = (ResourceVolume)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSource())));
                }
            });
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ResourceVolume volume = (ResourceVolume)element$iv;
                boolean bl = false;
                Panel.row$default((Panel)$this$panel, null, arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$48$lambda$47(volume, arg_0), (int)1, null);
            }
            Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        }
        if (!($resourceData.getEnvironment().length == 0)) {
            Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$52$lambda$49, (int)1, null).bottomGap(BottomGap.SMALL);
            $this$forEach$iv = $resourceData.getEnvironment();
            $i$f$forEach = false;
            int n3 = ((ResourceEnvironmentVariable[])$this$forEach$iv).length;
            for (int i = 0; i < n3; ++i) {
                Object element$iv;
                Object variable = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Panel.row$default((Panel)$this$panel, null, arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$52$lambda$51$lambda$50((ResourceEnvironmentVariable)variable, arg_0), (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }
}

