/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.services;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.framework.util.IRdEndpointCoroutineUtilKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.aspire.generated.AspireHostModel;
import com.jetbrains.rider.aspire.generated.AspireHostModelConfig;
import com.jetbrains.rider.aspire.generated.CreateSessionRequest;
import com.jetbrains.rider.aspire.generated.CreateSessionResponse;
import com.jetbrains.rider.aspire.generated.DeleteSessionRequest;
import com.jetbrains.rider.aspire.generated.DeleteSessionResponse;
import com.jetbrains.rider.aspire.generated.LogReceived;
import com.jetbrains.rider.aspire.generated.ProcessStarted;
import com.jetbrains.rider.aspire.generated.ProcessTerminated;
import com.jetbrains.rider.aspire.generated.ResourceState;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceWrapper;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.services.AspireHost;
import com.jetbrains.rider.aspire.services.AspireHostServiceViewDescriptor;
import com.jetbrains.rider.aspire.services.AspireMainServiceViewContributor;
import com.jetbrains.rider.aspire.services.AspireProjectResourceProfileData;
import com.jetbrains.rider.aspire.services.AspireResource;
import com.jetbrains.rider.aspire.services.AspireResourceServiceViewDescriptor;
import com.jetbrains.rider.aspire.sessionHost.SessionEvent;
import com.jetbrains.rider.aspire.sessionHost.SessionLogReceived;
import com.jetbrains.rider.aspire.sessionHost.SessionManager;
import com.jetbrains.rider.aspire.sessionHost.SessionStarted;
import com.jetbrains.rider.aspire.sessionHost.SessionTerminated;
import com.jetbrains.rider.aspire.sessionHost.projectLaunchers.ProjectSessionProfile;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ]2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0003:\u0001]B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010(\u001a\u00020\u0000H\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u0002H\u0016J\u0010\u0010/\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020\u0005J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J4\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u0010@J\u0016\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0082@\u00a2\u0006\u0002\u0010EJ\u0018\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020=2\u0006\u00103\u001a\u000204H\u0002J \u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u000206H\u0002J\u0010\u0010M\u001a\u0002022\u0006\u0010N\u001a\u00020?H\u0002J\u0010\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u000202H\u0002J\u0010\u0010S\u001a\u0002022\u0006\u0010T\u001a\u00020\u0002H\u0002J\u0010\u0010S\u001a\u0002022\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u0002022\u0006\u0010U\u001a\u00020VH\u0002J\b\u0010X\u001a\u000202H\u0002J\b\u0010Y\u001a\u000202H\u0002J\b\u0010Z\u001a\u000202H\u0002J\b\u0010[\u001a\u000202H\u0002J\b\u0010\\\u001a\u000202H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\"\u001a\u0004\u0018\u00010\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\"\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u001c\u001a\u0004\u0018\u00010$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006^"}, d2={"Lcom/jetbrains/rider/aspire/services/AspireHost;", "Lcom/intellij/execution/services/ServiceViewProvidingContributor;", "Lcom/jetbrains/rider/aspire/services/AspireResource;", "Lcom/intellij/openapi/Disposable;", "hostProjectPath", "Ljava/nio/file/Path;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "getHostProjectPath", "()Ljava/nio/file/Path;", "descriptor", "Lcom/jetbrains/rider/aspire/services/AspireHostServiceViewDescriptor;", "getDescriptor", "()Lcom/jetbrains/rider/aspire/services/AspireHostServiceViewDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "resources", "Ljava/util/concurrent/ConcurrentHashMap;", "", "resourceProfileData", "Lcom/jetbrains/rider/aspire/services/AspireProjectResourceProfileData;", "hostProjectPathString", "getHostProjectPathString", "()Ljava/lang/String;", "value", "displayName", "getDisplayName", "", "isActive", "()Z", "dashboardUrl", "getDashboardUrl", "Lcom/intellij/execution/ui/ConsoleView;", "consoleView", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "asService", "getViewDescriptor", "getServices", "", "getServiceDescriptor", "Lcom/jetbrains/rider/aspire/services/AspireResourceServiceViewDescriptor;", "aspireResource", "getProjectResource", "projectPath", "setAspireHostModel", "", "model", "Lcom/jetbrains/rider/aspire/generated/AspireHostModel;", "aspireHostLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createSession", "Lcom/jetbrains/rider/aspire/generated/CreateSessionResponse;", "createSessionRequest", "Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;", "sessionEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/jetbrains/rider/aspire/sessionHost/SessionEvent;", "aspireHostConfig", "Lcom/jetbrains/rider/aspire/generated/AspireHostModelConfig;", "(Lcom/jetbrains/rider/aspire/generated/CreateSessionRequest;Lkotlinx/coroutines/flow/MutableSharedFlow;Lcom/jetbrains/rider/aspire/generated/AspireHostModelConfig;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSession", "Lcom/jetbrains/rider/aspire/generated/DeleteSessionResponse;", "deleteSessionRequest", "Lcom/jetbrains/rider/aspire/generated/DeleteSessionRequest;", "(Lcom/jetbrains/rider/aspire/generated/DeleteSessionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleSessionEvent", "sessionEvent", "viewResource", "resourceId", "resourceModel", "Lcom/jetbrains/rider/aspire/generated/ResourceWrapper;", "resourceLifetime", "setAspireHostUrl", "config", "hostStarted", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "hostStopped", "setProfileDataForResource", "resource", "profile", "Lcom/jetbrains/rider/aspire/sessionHost/projectLaunchers/ProjectSessionProfile;", "removeProfileData", "selectHost", "expand", "sendServiceChangedEvent", "sendServiceChildrenChangedEvent", "dispose", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireHost.kt\ncom/jetbrains/rider/aspire/services/AspireHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n69#2,4:346\n69#2,4:350\n69#2,4:354\n69#2,4:358\n69#2,4:362\n69#2,4:366\n69#2,4:370\n69#2,4:374\n15#2:385\n295#3,2:378\n774#3:380\n865#3,2:381\n1863#3,2:383\n*S KotlinDebug\n*F\n+ 1 AspireHost.kt\ncom/jetbrains/rider/aspire/services/AspireHost\n*L\n179#1:346,4\n196#1:350,4\n208#1:354,4\n213#1:358,4\n218#1:362,4\n229#1:366,4\n257#1:370,4\n278#1:374,4\n49#1:385\n291#1:378,2\n301#1:380\n301#1:381,2\n302#1:383,2\n*E\n"})
public final class AspireHost
implements ServiceViewProvidingContributor<AspireResource, AspireHost>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path hostProjectPath;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy descriptor$delegate;
    @NotNull
    private final ConcurrentHashMap<String, AspireResource> resources;
    @NotNull
    private final ConcurrentHashMap<String, AspireProjectResourceProfileData> resourceProfileData;
    @NotNull
    private final String hostProjectPathString;
    @NotNull
    private String displayName;
    private boolean isActive;
    @Nullable
    private String dashboardUrl;
    @Nullable
    private ConsoleView consoleView;
    @NotNull
    private static final Logger LOG;

    public AspireHost(@NotNull Path hostProjectPath, @NotNull CoroutineScope scope, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)hostProjectPath, (String)"hostProjectPath");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.hostProjectPath = hostProjectPath;
        this.scope = scope;
        this.project = project;
        this.descriptor$delegate = LazyKt.lazy(() -> AspireHost.descriptor_delegate$lambda$0(this));
        this.resources = new ConcurrentHashMap();
        this.resourceProfileData = new ConcurrentHashMap();
        this.hostProjectPathString = ((Object)this.hostProjectPath.toAbsolutePath()).toString();
        this.displayName = PathsKt.getNameWithoutExtension((Path)this.hostProjectPath);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(String executorId, ExecutionEnvironment env, ProcessHandler handler) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                RunProfile runProfile = env.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                RunProfile profile = runProfile;
                if (profile instanceof AspireHostConfiguration) {
                    Path path = Paths.get(((AspireHostConfiguration)profile).getParameters().getProjectFilePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path projectFilePath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)projectFilePath)) {
                        return;
                    }
                    this.hostStarted(handler);
                } else if (profile instanceof ProjectSessionProfile) {
                    Path path = ((ProjectSessionProfile)profile).getAspireHostProjectPath();
                    if (path == null) {
                        return;
                    }
                    Path aspireHostProjectPath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)aspireHostProjectPath)) {
                        return;
                    }
                    this.setProfileDataForResource((ProjectSessionProfile)profile);
                }
            }

            public void processTerminated(String executorId, ExecutionEnvironment env, ProcessHandler handler, int exitCode) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                RunProfile runProfile = env.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                RunProfile profile = runProfile;
                if (profile instanceof AspireHostConfiguration) {
                    Path path = Paths.get(((AspireHostConfiguration)profile).getParameters().getProjectFilePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path projectFilePath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)projectFilePath)) {
                        return;
                    }
                    this.hostStopped();
                } else if (profile instanceof ProjectSessionProfile) {
                    Path path = ((ProjectSessionProfile)profile).getAspireHostProjectPath();
                    if (path == null) {
                        return;
                    }
                    Path aspireHostProjectPath = path;
                    if (!Intrinsics.areEqual((Object)this.getHostProjectPath(), (Object)aspireHostProjectPath)) {
                        return;
                    }
                    this.removeProfileData((ProjectSessionProfile)profile);
                }
            }
        });
    }

    @NotNull
    public final Path getHostProjectPath() {
        return this.hostProjectPath;
    }

    private final AspireHostServiceViewDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (AspireHostServiceViewDescriptor)lazy.getValue();
    }

    @NotNull
    public final String getHostProjectPathString() {
        return this.hostProjectPathString;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @Nullable
    public final String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    public final ConsoleView getConsoleView() {
        return this.consoleView;
    }

    @NotNull
    public AspireHost asService() {
        return this;
    }

    @NotNull
    public AspireHostServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getDescriptor();
    }

    @NotNull
    public List<AspireResource> getServices(@NotNull Project project) {
        Function1[] function1Array;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Function1[] $this$getServices_u24lambda_u241 = function1Array = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Map.Entry resource : ((Map)this.resources).entrySet()) {
            if (((AspireResource)resource.getValue()).getType() == ResourceType.Unknown || ((AspireResource)resource.getValue()).getState() == ResourceState.Hidden) continue;
            $this$getServices_u24lambda_u241.add(resource.getValue());
        }
        Iterable iterable = CollectionsKt.build((List)function1Array);
        function1Array = new Function1[]{AspireHost::getServices$lambda$2, AspireHost::getServices$lambda$3};
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    @NotNull
    public AspireResourceServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull AspireResource aspireResource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)aspireResource, (String)"aspireResource");
        return aspireResource.getViewDescriptor();
    }

    @Nullable
    public final AspireResource getProjectResource(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        for (Map.Entry resource : ((Map)this.resources).entrySet()) {
            if (((AspireResource)resource.getValue()).getType() != ResourceType.Project || ((AspireResource)resource.getValue()).getState() == ResourceState.Hidden || !Intrinsics.areEqual((Object)((AspireResource)resource.getValue()).getProjectPath(), (Object)projectPath)) continue;
            return (AspireResource)resource.getValue();
        }
        return null;
    }

    public final void setAspireHostModel(@NotNull AspireHostModel model, @NotNull Lifetime aspireHostLifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
        LOG.trace(" Subscribing to Aspire host model");
        this.setAspireHostUrl(model.getConfig());
        BufferOverflow bufferOverflow = BufferOverflow.DROP_OLDEST;
        MutableSharedFlow sessionEvents = SharedFlowKt.MutableSharedFlow((int)20, (int)100, (BufferOverflow)bufferOverflow);
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(model, aspireHostLifetime, this, (MutableSharedFlow<SessionEvent>)sessionEvents, null){
            int label;
            final /* synthetic */ AspireHostModel $model;
            final /* synthetic */ Lifetime $aspireHostLifetime;
            final /* synthetic */ AspireHost this$0;
            final /* synthetic */ MutableSharedFlow<SessionEvent> $sessionEvents;
            {
                this.$model = $model;
                this.$aspireHostLifetime = $aspireHostLifetime;
                this.this$0 = $receiver;
                this.$sessionEvents = $sessionEvents;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        IRdEndpointCoroutineUtilKt.setSuspend$default(this.$model.getCreateSession(), null, null, (Function3)((Function3)new Function3<Lifetime, CreateSessionRequest, Continuation<? super CreateSessionResponse>, Object>(this.this$0, this.$sessionEvents, this.$model, this.$aspireHostLifetime, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AspireHost this$0;
                            final /* synthetic */ MutableSharedFlow<SessionEvent> $sessionEvents;
                            final /* synthetic */ AspireHostModel $model;
                            final /* synthetic */ Lifetime $aspireHostLifetime;
                            {
                                this.this$0 = $receiver;
                                this.$sessionEvents = $sessionEvents;
                                this.$model = $model;
                                this.$aspireHostLifetime = $aspireHostLifetime;
                                super(3, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CreateSessionRequest request = (CreateSessionRequest)this.L$0;
                                        this.label = 1;
                                        Object object3 = AspireHost.access$createSession(this.this$0, request, this.$sessionEvents, this.$model.getConfig(), this.$aspireHostLifetime, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(Lifetime p1, CreateSessionRequest p2, Continuation<? super CreateSessionResponse> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        IRdEndpointCoroutineUtilKt.setSuspend$default(this.$model.getDeleteSession(), null, null, (Function3)((Function3)new Function3<Lifetime, DeleteSessionRequest, Continuation<? super DeleteSessionResponse>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AspireHost this$0;
                            {
                                this.this$0 = $receiver;
                                super(3, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeleteSessionRequest request = (DeleteSessionRequest)this.L$0;
                                        this.label = 1;
                                        Object object3 = AspireHost.access$deleteSession(this.this$0, request, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(Lifetime p1, DeleteSessionRequest p2, Continuation<? super DeleteSessionResponse> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.label = 1;
                        Object object3 = LifetimeCoroutineUtilKt.lifetimedCoroutineScope((Lifetime)this.$aspireHostLifetime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$sessionEvents, this.this$0, this.$model, null){
                            int label;
                            final /* synthetic */ MutableSharedFlow<SessionEvent> $sessionEvents;
                            final /* synthetic */ AspireHost this$0;
                            final /* synthetic */ AspireHostModel $model;
                            {
                                this.$sessionEvents = $sessionEvents;
                                this.this$0 = $receiver;
                                this.$model = $model;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$sessionEvents.collect(new FlowCollector(this.this$0, this.$model){
                                            final /* synthetic */ AspireHost this$0;
                                            final /* synthetic */ AspireHostModel $model;
                                            {
                                                this.this$0 = $receiver;
                                                this.$model = $model;
                                            }

                                            public final Object emit(SessionEvent it, Continuation<? super Unit> $completion) {
                                                AspireHost.access$handleSessionEvent(this.this$0, it, this.$model);
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) throw new KotlinNothingValueException();
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        model.getResources().view(aspireHostLifetime, (arg_0, arg_1, arg_2) -> AspireHost.setAspireHostModel$lambda$4(this, arg_0, arg_1, arg_2));
    }

    /*
     * Unable to fully structure code
     */
    private final Object createSession(CreateSessionRequest var1_1, MutableSharedFlow<SessionEvent> var2_2, AspireHostModelConfig var3_3, Lifetime var4_4, Continuation<? super CreateSessionResponse> $completion) {
        if (!($completion instanceof createSession.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AspireHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AspireHost.access$createSession(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toString(...)");
                sessionId = v0;
                $this$trace$iv = AspireHost.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var10_12 = $this$trace$iv;
                    $i$a$-trace-AspireHost$createSession$2 = false;
                    var10_12.trace("Creating session with id: " + sessionId);
                }
                command = new SessionManager.CreateSessionCommand(sessionId, var1_1, var2_2, aspireHostConfig.isDebuggingMode(), aspireHostConfig.getRunConfigName(), (Lifetime)aspireHostLifetime);
                $continuation.L$0 = sessionId;
                $continuation.label = 1;
                v1 = SessionManager.Companion.getInstance(this.project).submitCommand(command, (Continuation<? super Unit>)$continuation);
                if (v1 == var13_8) {
                    return var13_8;
                }
                ** GOTO lbl33
            }
            case 1: {
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                return new CreateSessionResponse(sessionId, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object deleteSession(DeleteSessionRequest var1_1, Continuation<? super DeleteSessionResponse> $completion) {
        if (!($completion instanceof deleteSession.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AspireHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AspireHost.access$deleteSession(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = AspireHost.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var6_8 = $this$trace$iv;
                    $i$a$-trace-AspireHost$deleteSession$2 = false;
                    var6_8.trace("Deleting session with id: " + deleteSessionRequest.getSessionId());
                }
                command = new SessionManager.DeleteSessionCommand(deleteSessionRequest.getSessionId());
                $continuation.L$0 = deleteSessionRequest;
                $continuation.label = 1;
                v0 = SessionManager.Companion.getInstance(this.project).submitCommand(command, (Continuation<? super Unit>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                deleteSessionRequest = (DeleteSessionRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                return new DeleteSessionResponse(deleteSessionRequest.getSessionId(), null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleSessionEvent(SessionEvent sessionEvent, AspireHostModel model) {
        SessionEvent sessionEvent2 = sessionEvent;
        if (sessionEvent2 instanceof SessionStarted) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session started (" + ((SessionStarted)sessionEvent).getId() + ", " + ((SessionStarted)sessionEvent).getPid() + ")");
            }
            model.getProcessStarted().fire((Object)new ProcessStarted(((SessionStarted)sessionEvent).getId(), ((SessionStarted)sessionEvent).getPid()));
        } else if (sessionEvent2 instanceof SessionTerminated) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session terminated (" + ((SessionTerminated)sessionEvent).getId() + ", " + ((SessionTerminated)sessionEvent).getExitCode() + ")");
            }
            model.getProcessTerminated().fire((Object)new ProcessTerminated(((SessionTerminated)sessionEvent).getId(), ((SessionTerminated)sessionEvent).getExitCode()));
        } else if (sessionEvent2 instanceof SessionLogReceived) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Aspire session log received (" + ((SessionLogReceived)sessionEvent).getId() + ", " + ((SessionLogReceived)sessionEvent).isStdErr() + ", " + ((SessionLogReceived)sessionEvent).getMessage() + ")");
            }
            model.getLogReceived().fire((Object)new LogReceived(((SessionLogReceived)sessionEvent).getId(), ((SessionLogReceived)sessionEvent).isStdErr(), ((SessionLogReceived)sessionEvent).getMessage()));
        }
    }

    private final void viewResource(String resourceId, ResourceWrapper resourceModel, Lifetime resourceLifetime) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Adding a new resource with id " + resourceId + " to the host " + this.hostProjectPathString);
        }
        AspireResource resource = new AspireResource(resourceModel, this, resourceLifetime, this.project);
        Disposer.register((Disposable)this, (Disposable)resource);
        CollectionExKt.addUnique((Map)this.resources, (Lifetime)resourceLifetime, (Object)resourceId, (Object)resource);
        if (resource.getState() != ResourceState.Hidden) {
            resourceLifetime.bracketIfAlive(() -> AspireHost.viewResource$lambda$11(this), () -> AspireHost.viewResource$lambda$12(this));
        }
        resourceModel.isInitialized().set((Object)true);
        this.expand();
        this.setProfileDataForResource(resource);
    }

    private final void setAspireHostUrl(AspireHostModelConfig config) {
        this.dashboardUrl = config.getAspireHostProjectUrl();
        this.sendServiceChangedEvent();
    }

    private final void hostStarted(ProcessHandler processHandler2) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Aspire Host " + this.hostProjectPathString + " was started");
        }
        this.isActive = true;
        ProcessHandler handler = processHandler2 instanceof DebuggerWorkerProcessHandler ? ((DebuggerWorkerProcessHandler)processHandler2).getDebuggerWorkerRealHandler() : processHandler2;
        ConsoleView console = DotNetProcessRunProfileStateKt.createConsole$default((ConsoleKind)ConsoleKind.Normal, (ProcessHandler)handler, (Project)this.project, null, (int)8, null);
        Disposer.register((Disposable)this, (Disposable)((Disposable)console));
        this.consoleView = console;
        this.selectHost();
        this.sendServiceChangedEvent();
    }

    private final void hostStopped() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Aspire Host " + this.hostProjectPathString + " was stopped");
        }
        this.isActive = false;
        this.dashboardUrl = null;
        this.resources.clear();
        this.resourceProfileData.clear();
        this.sendServiceChangedEvent();
    }

    private final void setProfileDataForResource(AspireResource resource) {
        Object v2;
        block3: {
            Path path = resource.getProjectPath();
            if (path == null) {
                return;
            }
            Path projectPath = path;
            Collection<AspireProjectResourceProfileData> collection = this.resourceProfileData.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AspireProjectResourceProfileData it = (AspireProjectResourceProfileData)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProjectPath(), (Object)projectPath)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        AspireProjectResourceProfileData aspireProjectResourceProfileData = v2;
        if (aspireProjectResourceProfileData == null) {
            return;
        }
        AspireProjectResourceProfileData profileData = aspireProjectResourceProfileData;
        resource.setProfileData(profileData);
    }

    /*
     * WARNING - void declaration
     */
    private final void setProfileDataForResource(ProjectSessionProfile profile) {
        void $this$filterTo$iv$iv;
        AspireProjectResourceProfileData profileData = new AspireProjectResourceProfileData(profile.getProjectPath(), profile.isDebugMode());
        this.resourceProfileData.put(profile.getSessionId(), profileData);
        Collection<AspireResource> collection = this.resources.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AspireResource it = (AspireResource)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getProjectPath(), (Object)profileData.getProjectPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AspireResource it = (AspireResource)element$iv;
            boolean bl = false;
            it.setProfileData(profileData);
        }
    }

    private final void removeProfileData(ProjectSessionProfile profile) {
        this.resourceProfileData.remove(profile.getSessionId());
    }

    private final void selectHost() {
        ApplicationKt.getApplication().invokeLater(() -> AspireHost.selectHost$lambda$18(this));
    }

    private final void expand() {
        ApplicationKt.getApplication().invokeLater(() -> AspireHost.expand$lambda$19(this));
    }

    private final void sendServiceChangedEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)this, AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    private final void sendServiceChildrenChangedEvent() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHILDREN_CHANGED, (Object)this, AspireMainServiceViewContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }

    public void dispose() {
    }

    private static final AspireHostServiceViewDescriptor descriptor_delegate$lambda$0(AspireHost this$0) {
        return new AspireHostServiceViewDescriptor(this$0);
    }

    private static final Comparable getServices$lambda$2(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getType());
    }

    private static final Comparable getServices$lambda$3(AspireResource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final Unit setAspireHostModel$lambda$4(AspireHost this$0, Lifetime resourceLifetime, String resourceId, ResourceWrapper resourceModel) {
        Intrinsics.checkNotNullParameter((Object)resourceLifetime, (String)"resourceLifetime");
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        Intrinsics.checkNotNullParameter((Object)((Object)resourceModel), (String)"resourceModel");
        this$0.viewResource(resourceId, resourceModel, resourceLifetime);
        return Unit.INSTANCE;
    }

    private static final Unit viewResource$lambda$11(AspireHost this$0) {
        this$0.sendServiceChildrenChangedEvent();
        return Unit.INSTANCE;
    }

    private static final Unit viewResource$lambda$12(AspireHost this$0) {
        this$0.sendServiceChildrenChangedEvent();
        return Unit.INSTANCE;
    }

    private static final void selectHost$lambda$18(AspireHost this$0) {
        ServiceViewManager.getInstance((Project)this$0.project).select((Object)this$0, AspireMainServiceViewContributor.class, true, true);
    }

    private static final void expand$lambda$19(AspireHost this$0) {
        ServiceViewManager.getInstance((Project)this$0.project).expand((Object)this$0, AspireMainServiceViewContributor.class);
    }

    public static final /* synthetic */ Object access$createSession(AspireHost $this, CreateSessionRequest createSessionRequest, MutableSharedFlow sessionEvents, AspireHostModelConfig aspireHostConfig, Lifetime aspireHostLifetime, Continuation $completion) {
        return $this.createSession(createSessionRequest, (MutableSharedFlow<SessionEvent>)sessionEvents, aspireHostConfig, aspireHostLifetime, (Continuation<? super CreateSessionResponse>)$completion);
    }

    public static final /* synthetic */ Object access$deleteSession(AspireHost $this, DeleteSessionRequest deleteSessionRequest, Continuation $completion) {
        return $this.deleteSession(deleteSessionRequest, (Continuation<? super DeleteSessionResponse>)$completion);
    }

    public static final /* synthetic */ void access$handleSessionEvent(AspireHost $this, SessionEvent sessionEvent, AspireHostModel model) {
        $this.handleSessionEvent(sessionEvent, model);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/aspire/services/AspireHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

