/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.run;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.aspire.run.AspireHostConfiguration;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationParameters;
import com.jetbrains.rider.aspire.run.AspireHostConfigurationType;
import com.jetbrains.rider.aspire.services.AspireHost;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/aspire/run/AspireHostRunManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configurationNames", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "", "configurationLifetimes", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "saveRunConfiguration", "", "aspireHostProjectPath", "aspireHostLifetime", "configurationName", "executeConfigurationForHost", "host", "Lcom/jetbrains/rider/aspire/services/AspireHost;", "underDebug", "", "stopConfigurationForHost", "(Lcom/jetbrains/rider/aspire/services/AspireHost;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireHostRunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireHostRunManager.kt\ncom/jetbrains/rider/aspire/run/AspireHostRunManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n774#2:93\n865#2,2:94\n295#2,2:96\n15#3:98\n*S KotlinDebug\n*F\n+ 1 AspireHostRunManager.kt\ncom/jetbrains/rider/aspire/run/AspireHostRunManager\n*L\n57#1:93\n57#1:94,2\n70#1:96,2\n26#1:98\n*E\n"})
public final class AspireHostRunManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Path, String> configurationNames;
    @NotNull
    private final ConcurrentHashMap<Path, LifetimeDefinition> configurationLifetimes;
    @NotNull
    private static final Logger LOG;

    public AspireHostRunManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.configurationNames = new ConcurrentHashMap();
        this.configurationLifetimes = new ConcurrentHashMap();
    }

    public final void saveRunConfiguration(@NotNull Path aspireHostProjectPath, @NotNull LifetimeDefinition aspireHostLifetime, @NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)aspireHostProjectPath, (String)"aspireHostProjectPath");
        Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        ((Map)this.configurationNames).put(aspireHostProjectPath, configurationName);
        ((Map)this.configurationLifetimes).put(aspireHostProjectPath, aspireHostLifetime);
    }

    /*
     * WARNING - void declaration
     */
    public final void executeConfigurationForHost(@NotNull AspireHost host, boolean underDebug) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        RunConfiguration selectedConfiguration;
        RunnerAndConfigurationSettings selected;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Executor executor = underDebug ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = selected = runManager.getSelectedConfiguration();
        Object object = selectedConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        if (selectedConfiguration != null && selectedConfiguration instanceof AspireHostConfiguration) {
            Path path = host.getHostProjectPath();
            Path path2 = Paths.get(((AspireHostConfiguration)selectedConfiguration).getParameters().getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            if (Intrinsics.areEqual((Object)path, (Object)path2)) {
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)selected, (Executor)executor);
                return;
            }
        }
        Iterable iterable = runManager.getConfigurationSettingsList(AspireHostConfigurationType.class);
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl2 = false;
            RunConfiguration runConfiguration = it.getConfiguration();
            Object object2 = runConfiguration instanceof AspireHostConfiguration ? (AspireHostConfiguration)runConfiguration : null;
            if (object2 == null || (object2 = object2.getParameters()) == null || (object2 = ((AspireHostConfigurationParameters)object2).getProjectFilePath()) == null) {
                bl = false;
            } else {
                AspireHostConfiguration path = object2;
                Path path3 = Paths.get((String)((Object)path), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                bl = Intrinsics.areEqual((Object)path3, (Object)host.getHostProjectPath());
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configurations = (List)destination$iv$iv;
        if (configurations.isEmpty()) {
            LOG.warn("Unable to find Aspire host run configurations");
            return;
        }
        String configurationName = this.configurationNames.get(host.getHostProjectPath());
        if (configurationName != null) {
            Object v7;
            block9: {
                Iterable $this$firstOrNull$iv = configurations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)configurationName)) continue;
                    v7 = element$iv;
                    break block9;
                }
                v7 = null;
            }
            RunnerAndConfigurationSettings configurationWithName = v7;
            if (configurationWithName != null) {
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configurationWithName, (Executor)executor);
                return;
            }
        }
        RunnerAndConfigurationSettings firstConfiguration = (RunnerAndConfigurationSettings)CollectionsKt.first((List)configurations);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)firstConfiguration, (Executor)executor);
    }

    @Nullable
    public final Object stopConfigurationForHost(@NotNull AspireHost host, @NotNull Continuation<? super Unit> $completion) {
        LifetimeDefinition lifetime = this.configurationLifetimes.get(host.getHostProjectPath());
        if (lifetime == null || RLifetimeKt.isNotAlive((Lifetime)lifetime.getLifetime())) {
            LOG.warn("Unable to stop configuration for Aspire host " + host.getHostProjectPathString());
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(lifetime, null){
            int label;
            final /* synthetic */ LifetimeDefinition $lifetime;
            {
                this.$lifetime = $lifetime;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxBoolean((boolean)LifetimeDefinition.terminate$default((LifetimeDefinition)this.$lifetime, (boolean)false, (int)1, null));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireHostRunManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/run/AspireHostRunManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/run/AspireHostRunManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nAspireHostRunManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireHostRunManager.kt\ncom/jetbrains/rider/aspire/run/AspireHostRunManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n31#2,2:93\n*S KotlinDebug\n*F\n+ 1 AspireHostRunManager.kt\ncom/jetbrains/rider/aspire/run/AspireHostRunManager$Companion\n*L\n24#1:93,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AspireHostRunManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AspireHostRunManager> serviceClass$iv = AspireHostRunManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AspireHostRunManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

