/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.database;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.aspire.database.DatabaseResource;
import com.jetbrains.rider.aspire.database.DatabaseResourceUrl;
import com.jetbrains.rider.aspire.database.ResourceDatabaseConnectionService;
import com.jetbrains.rider.aspire.database.ResourceDatabaseService;
import com.jetbrains.rider.aspire.database.SessionConnectionString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eJ\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/aspire/database/ResourceDatabaseService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "connectionStrings", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Lcom/jetbrains/rider/aspire/database/SessionConnectionString;", "databaseResources", "Lcom/jetbrains/rider/aspire/database/DatabaseResource;", "connectionStringToProcess", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "databaseResourceToProcess", "put", "", "connectionString", "resource", "process", "(Lcom/jetbrains/rider/aspire/database/SessionConnectionString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "databaseResource", "(Lcom/jetbrains/rider/aspire/database/DatabaseResource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDatabaseService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n69#2,4:116\n69#2,4:120\n15#2:128\n1863#3,2:124\n1863#3,2:126\n*S KotlinDebug\n*F\n+ 1 ResourceDatabaseService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseService\n*L\n55#1:116,4\n72#1:120,4\n28#1:128\n93#1:124,2\n109#1:126,2\n*E\n"})
public final class ResourceDatabaseService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Pair<String, String>, SessionConnectionString> connectionStrings;
    @NotNull
    private final ConcurrentHashMap<String, DatabaseResource> databaseResources;
    @NotNull
    private final MutableSharedFlow<SessionConnectionString> connectionStringToProcess;
    @NotNull
    private final MutableSharedFlow<DatabaseResource> databaseResourceToProcess;
    @NotNull
    private static final Logger LOG;

    public ResourceDatabaseService(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.connectionStrings = new ConcurrentHashMap();
        this.databaseResources = new ConcurrentHashMap();
        BufferOverflow bufferOverflow = BufferOverflow.DROP_OLDEST;
        this.connectionStringToProcess = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, (BufferOverflow)bufferOverflow, (int)1, null);
        bufferOverflow = BufferOverflow.DROP_OLDEST;
        this.databaseResourceToProcess = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, (BufferOverflow)bufferOverflow, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ResourceDatabaseService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.connectionStringToProcess.collect(new FlowCollector(){

                            public final Object emit(SessionConnectionString it, Continuation<? super Unit> $completion) {
                                Object object = this$0.process(it, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ResourceDatabaseService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.databaseResourceToProcess.collect(new FlowCollector(){

                            public final Object emit(DatabaseResource it, Continuation<? super Unit> $completion) {
                                Object object = this$0.process(it, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void put(@NotNull SessionConnectionString connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        if (RLifetimeKt.isNotAlive((Lifetime)connectionString.getSessionLifetime())) {
            return;
        }
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Adding connection string " + connectionString);
        }
        Pair key = TuplesKt.to((Object)connectionString.getSessionId(), (Object)connectionString.getConnectionName());
        SessionConnectionString previousValue = this.connectionStrings.putIfAbsent((Pair<String, String>)key, connectionString);
        if (previousValue == null) {
            connectionString.getSessionLifetime().onTerminationIfAlive(() -> ResourceDatabaseService.put$lambda$1(this, key));
            this.connectionStringToProcess.tryEmit((Object)connectionString);
        }
    }

    public final void put(@NotNull DatabaseResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (RLifetimeKt.isNotAlive((Lifetime)resource.getResourceLifetime())) {
            return;
        }
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Adding database resource " + resource);
        }
        ((Map)this.databaseResources).put(resource.getContainerId(), resource);
        resource.getResourceLifetime().onTerminationIfAlive(() -> ResourceDatabaseService.put$lambda$3(this, resource));
        this.databaseResourceToProcess.tryEmit((Object)resource);
    }

    /*
     * Unable to fully structure code
     */
    private final Object process(SessionConnectionString var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof process.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ResourceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ResourceDatabaseService.access$process(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                databases = new ArrayList<E>();
                var4_7 = this.databaseResources.values().iterator();
                block4: while (var4_7.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)var4_7.next(), (String)"next(...)");
                    for (DatabaseResourceUrl url : databaseResource.getUrls()) {
                        if (!StringsKt.contains$default((CharSequence)connectionString.getConnectionString(), (CharSequence)String.valueOf(url.getUri().getPort()), (boolean)false, (int)2, null)) continue;
                        databases.add(databaseResource);
                        continue block4;
                    }
                }
                service = ResourceDatabaseConnectionService.Companion.getInstance(this.project);
                $this$forEach$iv = databases;
                $i$f$forEach = false;
                var7_11 = $this$forEach$iv.iterator();
lbl26:
                // 3 sources

                while (var7_11.hasNext()) {
                    element$iv = var7_11.next();
                    it = (DatabaseResource)element$iv;
                    $i$a$-forEach-ResourceDatabaseService$process$2 = false;
                    $continuation.L$0 = connectionString;
                    $continuation.L$1 = service;
                    $continuation.L$2 = var7_11;
                    $continuation.label = 1;
                    v0 = service.processConnection(connectionString, it, (Continuation<? super Unit>)$continuation);
                    if (v0 != var13_5) continue;
                    return var13_5;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-ResourceDatabaseService$process$2 = false;
                var7_11 = (Iterator<T>)$continuation.L$2;
                service = (ResourceDatabaseConnectionService)$continuation.L$1;
                connectionString = (SessionConnectionString)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl26
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object process(DatabaseResource var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof process.3)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ResourceDatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ResourceDatabaseService.access$process(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                connections = new ArrayList<E>();
                var4_7 = this.connectionStrings.values().iterator();
                block4: while (var4_7.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue((Object)var4_7.next(), (String)"next(...)");
                    for (DatabaseResourceUrl url : databaseResource.getUrls()) {
                        if (!StringsKt.contains$default((CharSequence)connectionString.getConnectionString(), (CharSequence)String.valueOf(url.getUri().getPort()), (boolean)false, (int)2, null)) continue;
                        connections.add(connectionString);
                        continue block4;
                    }
                }
                service = ResourceDatabaseConnectionService.Companion.getInstance(this.project);
                $this$forEach$iv = connections;
                $i$f$forEach = false;
                var7_11 = $this$forEach$iv.iterator();
lbl26:
                // 3 sources

                while (var7_11.hasNext()) {
                    element$iv = var7_11.next();
                    it = (SessionConnectionString)element$iv;
                    $i$a$-forEach-ResourceDatabaseService$process$4 = false;
                    $continuation.L$0 = databaseResource;
                    $continuation.L$1 = service;
                    $continuation.L$2 = var7_11;
                    $continuation.label = 1;
                    v0 = service.processConnection(it, databaseResource, (Continuation<? super Unit>)$continuation);
                    if (v0 != var13_5) continue;
                    return var13_5;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-ResourceDatabaseService$process$4 = false;
                var7_11 = (Iterator<T>)$continuation.L$2;
                service = (ResourceDatabaseConnectionService)$continuation.L$1;
                databaseResource = (DatabaseResource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl26
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit put$lambda$1(ResourceDatabaseService this$0, Pair $key) {
        this$0.connectionStrings.remove($key);
        return Unit.INSTANCE;
    }

    private static final Unit put$lambda$3(ResourceDatabaseService this$0, DatabaseResource $resource) {
        this$0.databaseResources.remove($resource.getContainerId());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ResourceDatabaseService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/database/ResourceDatabaseService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/database/ResourceDatabaseService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nResourceDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDatabaseService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n31#2,2:116\n*S KotlinDebug\n*F\n+ 1 ResourceDatabaseService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseService$Companion\n*L\n26#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceDatabaseService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ResourceDatabaseService> serviceClass$iv = ResourceDatabaseService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceDatabaseService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

