/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.database;

import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.aspire.AspireBundle;
import com.jetbrains.rider.aspire.database.DatabaseResource;
import com.jetbrains.rider.aspire.database.DatabaseResourceUrl;
import com.jetbrains.rider.aspire.database.DatabaseType;
import com.jetbrains.rider.aspire.database.DummyMongoDataProvider;
import com.jetbrains.rider.aspire.database.DummyRedisDataProvider;
import com.jetbrains.rider.aspire.database.ResourceDatabaseConnectionService;
import com.jetbrains.rider.aspire.database.SessionConnectionString;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.ConnectionManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.connection.TestConnectionExecutionResult;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.converters.ConnectionStringToJdbcUrlConverter;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.MySqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.NpgsqlDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.OracleClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.SqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.factories.ConnectionStringsFactory;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.ConnectionString;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J0\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0016\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010-J\u0012\u00100\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "rawConnectionStringTypes", "", "Lcom/jetbrains/rider/aspire/database/DatabaseType;", "connectionStrings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "urlToConnectionStrings", "connectionManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/connection/ConnectionManager;", "connectionToProcess", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlin/Pair;", "Lcom/jetbrains/rider/aspire/database/SessionConnectionString;", "Lcom/jetbrains/rider/aspire/database/DatabaseResource;", "createdDataSources", "Lcom/intellij/database/dataSource/LocalDataSource;", "processConnection", "connectionString", "databaseResource", "(Lcom/jetbrains/rider/aspire/database/SessionConnectionString;Lcom/jetbrains/rider/aspire/database/DatabaseResource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "createDataSource", "modifiedConnectionString", "(Lcom/jetbrains/rider/aspire/database/DatabaseResource;Ljava/lang/String;Lcom/jetbrains/rider/aspire/database/SessionConnectionString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "modifyConnectionString", "getDataProvider", "Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;", "type", "getConnectionUrl", "dataProvider", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "(Ljava/lang/String;Lcom/jetbrains/rider/aspire/database/DatabaseResource;Lcom/jetbrains/rider/plugins/appender/database/jdbcToConnectionString/dataProviders/DotnetDataProvider;Lcom/intellij/database/dataSource/DatabaseDriver;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertRedisConnectionString", "connectToDataSource", "dataSource", "(Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForConnection", "", "removeConnectionStringByUrl", "url", "Companion", "DataSourceListener", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDatabaseConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDatabaseConnectionService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n69#2,4:298\n69#2,4:302\n69#2,4:306\n69#2,4:313\n69#2,4:317\n62#2,5:323\n69#2,4:329\n15#2:333\n1755#3,3:310\n1863#3:322\n1864#3:328\n1#4:321\n*S KotlinDebug\n*F\n+ 1 ResourceDatabaseConnectionService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService\n*L\n92#1:298,4\n95#1:302,4\n103#1:306,4\n134#1:313,4\n137#1:317,4\n275#1:323,5\n150#1:329,4\n51#1:333\n133#1:310,3\n267#1:322\n267#1:328\n*E\n"})
public final class ResourceDatabaseConnectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<DatabaseType> rawConnectionStringTypes;
    @NotNull
    private final ConcurrentHashMap<String, Unit> connectionStrings;
    @NotNull
    private final ConcurrentHashMap<String, String> urlToConnectionStrings;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final MutableSharedFlow<Pair<SessionConnectionString, DatabaseResource>> connectionToProcess;
    @NotNull
    private final MutableSharedFlow<LocalDataSource> createdDataSources;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REDIS_CONNECTION_STRING_PATTERN = "(?<host>\\w*):(?<port>\\d*)(,user=(?<user>\\w*))?(,password=(?<password>\\w*))?";
    @NotNull
    private static final Regex REDIS_REGEX;

    public ResourceDatabaseConnectionService(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        BufferOverflow bufferOverflow = new BufferOverflow[]{DatabaseType.MSSQL, DatabaseType.MONGO};
        this.rawConnectionStringTypes = CollectionsKt.listOf((Object[])bufferOverflow);
        this.connectionStrings = new ConcurrentHashMap();
        this.urlToConnectionStrings = new ConcurrentHashMap();
        this.connectionManager = new ConnectionManager(this.project);
        bufferOverflow = BufferOverflow.SUSPEND;
        this.connectionToProcess = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, (BufferOverflow)bufferOverflow, (int)1, null);
        bufferOverflow = BufferOverflow.SUSPEND;
        this.createdDataSources = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, (BufferOverflow)bufferOverflow, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ResourceDatabaseConnectionService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.connectionToProcess.collect(new FlowCollector(){

                            public final Object emit(Pair<SessionConnectionString, DatabaseResource> it, Continuation<? super Unit> $completion) {
                                Object object = this$0.process((SessionConnectionString)it.getFirst(), (DatabaseResource)it.getSecond(), (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ResourceDatabaseConnectionService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.createdDataSources.collect(new FlowCollector(){

                            public final Object emit(LocalDataSource it, Continuation<? super Unit> $completion) {
                                Object object = this$0.connectToDataSource(it, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object processConnection(@NotNull SessionConnectionString connectionString, @NotNull DatabaseResource databaseResource, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.connectionToProcess.emit((Object)TuplesKt.to((Object)connectionString, (Object)databaseResource), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object process(SessionConnectionString var1_1, DatabaseResource var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof process.1)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ResourceDatabaseConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ResourceDatabaseConnectionService.access$process(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (RLifetimeKt.isNotAlive((Lifetime)databaseResource.getResourceLifetime())) {
                    return Unit.INSTANCE;
                }
                v0 = this.modifyConnectionString((SessionConnectionString)connectionString, (DatabaseResource)databaseResource);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                modifiedConnectionString = v0;
                $this$trace$iv = ResourceDatabaseConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var10_12 = $this$trace$iv;
                    $i$a$-trace-ResourceDatabaseConnectionService$process$2 = false;
                    var10_12.trace("Processing connection string " + (SessionConnectionString)connectionString + " for " + (DatabaseResource)databaseResource);
                }
                if (this.connectionStrings.putIfAbsent(modifiedConnectionString, Unit.INSTANCE) != null) {
                    $this$trace$iv = ResourceDatabaseConnectionService.LOG;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var10_12 = $this$trace$iv;
                        $i$a$-trace-ResourceDatabaseConnectionService$process$3 = false;
                        var10_12.trace("Connection string " + modifiedConnectionString + " is already in use");
                    }
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = modifiedConnectionString;
                $continuation.label = 1;
                v1 = this.createDataSource((DatabaseResource)databaseResource, modifiedConnectionString, (SessionConnectionString)connectionString, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var13_6) goto lbl42
lbl41:
                // 1 sources

                return var13_6;
lbl42:
                // 1 sources

                ** GOTO lbl66
            }
            case 1: {
                modifiedConnectionString = (String)$continuation.L$1;
                this = (ResourceDatabaseConnectionService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (CancellationException ce) {
                    this.connectionStrings.remove(modifiedConnectionString);
                    $this$trace$iv = ResourceDatabaseConnectionService.LOG;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var10_12 = $this$trace$iv;
                        $i$a$-trace-ResourceDatabaseConnectionService$process$4 = false;
                        var10_12.trace("Connecting with " + modifiedConnectionString + " was cancelled");
                    }
                    throw ce;
                }
                catch (Exception e) {
                    ResourceDatabaseConnectionService.LOG.warn("Unable to connect to database " + modifiedConnectionString, (Throwable)e);
                    this.connectionStrings.remove(modifiedConnectionString);
                }
lbl66:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object createDataSource(DatabaseResource var1_1, String var2_2, SessionConnectionString var3_3, Continuation<? super Unit> $completion) {
        if (!($completion instanceof createDataSource.1)) ** GOTO lbl-1000
        var18_5 = $completion;
        if ((var18_5.label & -2147483648) != 0) {
            var18_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ ResourceDatabaseConnectionService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ResourceDatabaseConnectionService.access$createDataSource(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dataProvider = this.getDataProvider(databaseResource.getType());
                driver = DbImplUtil.guessDatabaseDriver((Dbms)((Dbms)CollectionsKt.first((Iterable)dataProvider.getDbms())));
                if (driver == null) {
                    ResourceDatabaseConnectionService.LOG.info("Unable to guess database driver");
                    this.connectionStrings.remove(modifiedConnectionString);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = databaseResource;
                $continuation.L$2 = modifiedConnectionString;
                $continuation.L$3 = connectionString;
                $continuation.L$4 = driver;
                $continuation.label = 1;
                v0 = this.getConnectionUrl(modifiedConnectionString, databaseResource, dataProvider, driver, (Continuation<? super String>)$continuation);
                if (v0 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl37
            }
            case 1: {
                driver = (DatabaseDriver)$continuation.L$4;
                connectionString = (SessionConnectionString)$continuation.L$3;
                modifiedConnectionString = (String)$continuation.L$2;
                databaseResource = (DatabaseResource)$continuation.L$1;
                this = (ResourceDatabaseConnectionService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                if ((url = (String)v0) == null) {
                    ResourceDatabaseConnectionService.LOG.info("Unable to convert " + modifiedConnectionString + " to url");
                    this.connectionStrings.remove(modifiedConnectionString);
                    return Unit.INSTANCE;
                }
                ((Map)this.urlToConnectionStrings).put(url, modifiedConnectionString);
                v1 = LocalDataSourceManager.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                dataSourceManager = v1;
                v2 = dataSourceManager.getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDataSources(...)");
                $this$any$iv = v2;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl54
                v3 = false;
                ** GOTO lbl61
lbl54:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (LocalDataSource)element$iv;
                    $i$a$-any-ResourceDatabaseConnectionService$createDataSource$createdDataSource$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    v3 = true;
                    ** GOTO lbl61
                }
                v3 = false;
lbl61:
                // 3 sources

                if (!v3) ** GOTO lbl71
                $this$trace$iv = ResourceDatabaseConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var16_23 = $this$trace$iv;
                    $i$a$-trace-ResourceDatabaseConnectionService$createDataSource$createdDataSource$2 = false;
                    var16_23.trace("Data source with " + url + " is already in use");
                }
                v4 = null;
                ** GOTO lbl105
lbl71:
                // 1 sources

                $this$trace$iv = ResourceDatabaseConnectionService.LOG;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var16_23 = $this$trace$iv;
                    $i$a$-trace-ResourceDatabaseConnectionService$createDataSource$createdDataSource$3 = false;
                    var16_23.trace("Creating a new data source with " + url);
                }
                $this$createDataSource_u24lambda_u246 = $i$a$-trace-ResourceDatabaseConnectionService$createDataSource$createdDataSource$3 = LocalDataSource.fromDriver((DatabaseDriver)driver, (String)url, (boolean)true);
                $i$a$-apply-ResourceDatabaseConnectionService$createDataSource$createdDataSource$dataSource$1 = false;
                $this$createDataSource_u24lambda_u246.setName(connectionString.getConnectionName());
                $this$createDataSource_u24lambda_u246.setAutoSynchronize(true);
                v5 = $i$a$-trace-ResourceDatabaseConnectionService$createDataSource$createdDataSource$3;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"apply(...)");
                dataSource = v5;
                $continuation.L$0 = this;
                $continuation.L$1 = databaseResource;
                $continuation.L$2 = url;
                $continuation.L$3 = dataSourceManager;
                $continuation.L$4 = dataSource;
                $continuation.label = 2;
                v6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dataSourceManager, dataSource, null){
                    int label;
                    final /* synthetic */ LocalDataSourceManager $dataSourceManager;
                    final /* synthetic */ LocalDataSource $dataSource;
                    {
                        this.$dataSourceManager = $dataSourceManager;
                        this.$dataSource = $dataSource;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$dataSourceManager.addDataSource(this.$dataSource);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl104
            }
            case 2: {
                dataSource = (LocalDataSource)$continuation.L$4;
                dataSourceManager = (LocalDataSourceManager)$continuation.L$3;
                url = (String)$continuation.L$2;
                databaseResource = (DatabaseResource)$continuation.L$1;
                this = (ResourceDatabaseConnectionService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl104:
                // 2 sources

                v4 = createdDataSource = dataSource;
lbl105:
                // 2 sources

                if (!databaseResource.isPersistent() && createdDataSource != null) {
                    databaseResource.getResourceLifetime().onTerminationIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createDataSource$lambda$9(java.lang.String com.intellij.database.dataSource.LocalDataSourceManager com.intellij.database.dataSource.LocalDataSource ), ()Lkotlin/Unit;)((String)url, (LocalDataSourceManager)dataSourceManager, (LocalDataSource)createdDataSource));
                }
                v7 = createdDataSource;
                if (v7 != null) {
                    it = v7;
                    $i$a$-let-ResourceDatabaseConnectionService$createDataSource$3 = false;
                    Boxing.boxBoolean((boolean)this.createdDataSources.tryEmit((Object)it));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String modifyConnectionString(SessionConnectionString connectionString, DatabaseResource databaseResource) {
        Object v1;
        DatabaseResourceUrl targetUrl;
        block6: {
            Object object;
            Object object22;
            block5: {
                Iterable iterable = databaseResource.getUrls();
                for (Object object22 : iterable) {
                    DatabaseResourceUrl it = (DatabaseResourceUrl)object22;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)connectionString.getConnectionString(), (CharSequence)String.valueOf(it.getUri().getPort()), (boolean)false, (int)2, null)) continue;
                    object = object22;
                    break block5;
                }
                object = null;
            }
            targetUrl = (DatabaseResourceUrl)object;
            if (targetUrl == null) {
                LOG.warn("Unable to find target url for " + connectionString.getConnectionString());
                return null;
            }
            if (targetUrl.isInternal()) {
                return connectionString.getConnectionString();
            }
            Iterable iterable = databaseResource.getUrls();
            object22 = iterable.iterator();
            while (object22.hasNext()) {
                Object e = object22.next();
                DatabaseResourceUrl it = (DatabaseResourceUrl)e;
                boolean bl = false;
                if (!(it.isInternal() && StringsKt.startsWith$default((String)it.getName(), (String)targetUrl.getName(), (boolean)false, (int)2, null))) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        DatabaseResourceUrl targetInternalUrl = v1;
        if (targetInternalUrl == null) {
            LOG.warn("Unable to find target internal url for " + connectionString.getConnectionString());
            return connectionString.getConnectionString();
        }
        return StringsKt.replace$default((String)connectionString.getConnectionString(), (String)String.valueOf(targetUrl.getUri().getPort()), (String)String.valueOf(targetInternalUrl.getUri().getPort()), (boolean)false, (int)4, null);
    }

    private final DotnetDataProvider getDataProvider(DatabaseType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> (DotnetDataProvider)NpgsqlDataProvider.Companion.getInstance(this.project);
            case 2 -> (DotnetDataProvider)MySqlClientDataProvider.Companion.getInstance(this.project);
            case 3 -> (DotnetDataProvider)SqlClientDataProvider.Companion.getInstance(this.project);
            case 4 -> (DotnetDataProvider)OracleClientDataProvider.Companion.getInstance(this.project);
            case 5 -> DummyMongoDataProvider.Companion.getInstance(this.project);
            case 6 -> DummyRedisDataProvider.Companion.getInstance(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Object getConnectionUrl(String var1_1, DatabaseResource var2_2, DotnetDataProvider var3_3, DatabaseDriver var4_4, Continuation<? super String> $completion) {
        block11: {
            if (!($completion instanceof getConnectionUrl.1)) ** GOTO lbl-1000
            var11_6 = $completion;
            if ((var11_6.label & -2147483648) != 0) {
                var11_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ ResourceDatabaseConnectionService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ResourceDatabaseConnectionService.access$getConnectionUrl(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (databaseResource.getType() != DatabaseType.REDIS) ** GOTO lbl15
                    v0 = this.convertRedisConnectionString(connectionString);
                    break block11;
lbl15:
                    // 1 sources

                    if (!this.rawConnectionStringTypes.contains((Object)databaseResource.getType())) ** GOTO lbl18
                    v0 = connectionString;
                    break block11;
lbl18:
                    // 1 sources

                    factory = ConnectionStringsFactory.Companion.get((DotnetDataProvider)dataProvider, this.project);
                    if (factory == null) {
                        ResourceDatabaseConnectionService.LOG.warn("Unable to find connection string factory");
                        return null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = connectionString;
                    $continuation.L$2 = driver;
                    $continuation.label = 1;
                    v1 = factory.create-0E7RQCE(connectionString, (DotnetDataProvider)dataProvider, (Continuation)$continuation);
                    if (v1 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl36
                }
                case 1: {
                    driver = (DatabaseDriver)$continuation.L$2;
                    connectionString = (String)$continuation.L$1;
                    this = (ResourceDatabaseConnectionService)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = ((Result)$result).unbox-impl();
lbl36:
                    // 2 sources

                    if ((parsedConnectionString = (ConnectionString)(Result.isFailure-impl((Object)(var8_10 = v1)) != false ? null : var8_10)) == null) {
                        ResourceDatabaseConnectionService.LOG.warn("Unable to parse connection string " + connectionString);
                        return null;
                    }
                    var8_10 = ConnectionStringToJdbcUrlConverter.Companion.convert(parsedConnectionString, driver, this.project);
                    if (var8_10 == null) break;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v2 = var8_10.build-IoAF18A((Continuation)$continuation);
                    if (v2 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl52
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = ((Result)$result).unbox-impl();
lbl52:
                    // 2 sources

                    v0 = (String)(Result.isFailure-impl((Object)(var9_12 = v2)) != false ? null : var9_12);
                    break block11;
                }
            }
            v0 = null;
        }
        return v0;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String convertRedisConnectionString(String connectionString) {
        StringBuilder sb;
        block4: {
            String it;
            MatchResult matchResult = REDIS_REGEX.matchEntire((CharSequence)connectionString);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"host");
            String host = matchGroup != null ? matchGroup.getValue() : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"port");
            String port = matchGroup2 != null ? matchGroup2.getValue() : null;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"user");
            String user = matchGroup3 != null ? matchGroup3.getValue() : null;
            MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"password");
            String password = matchGroup4 != null ? matchGroup4.getValue() : null;
            sb = new StringBuilder("jdbc:redis://");
            String string = user;
            if (string != null) {
                it = string;
                boolean bl = false;
                sb.append(it).append(":");
            }
            String string2 = password;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                sb.append(it).append("@");
            }
            String string3 = host;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                sb.append(it);
            }
            String string4 = port;
            if (string4 == null) break block4;
            it = string4;
            boolean bl = false;
            sb.append(":").append(it);
        }
        return sb.toString();
    }

    private final Object connectToDataSource(LocalDataSource dataSource, Continuation<? super Unit> $completion) {
        Object object = TasksKt.withBackgroundProgress((Project)this.project, (String)AspireBundle.message("progress.connecting.to.database", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dataSource, null){
            int label;
            final /* synthetic */ ResourceDatabaseConnectionService this$0;
            final /* synthetic */ LocalDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ResourceDatabaseConnectionService.access$waitForConnection(this.this$0, this.$dataSource, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!(isConnectionSuccessful = ((Boolean)v0).booleanValue())) {
                            ResourceDatabaseConnectionService.access$getLOG$cp().warn("Unable to connect to database");
                            return Unit.INSTANCE;
                        }
                        v1 = LoaderContext.selectGeneralTask((Project)ResourceDatabaseConnectionService.access$getProject$p(this.this$0), (LocalDataSource)this.$dataSource);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"selectGeneralTask(...)");
                        this.label = 2;
                        v2 = DataSourceUtilKt.performAutoIntrospection((LoaderContext)v1, (boolean)true, (Continuation)((Continuation)this));
                        ** if (v2 != var4_2) goto lbl24
lbl23:
                        // 1 sources

                        return var4_2;
lbl24:
                        // 1 sources

                        ** GOTO lbl36
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                        }
                        catch (CancellationException ce) {
                            ResourceDatabaseConnectionService.access$getLOG$cp().trace("Introspection is canceled");
                            throw ce;
                        }
                        catch (Exception e) {
                            ResourceDatabaseConnectionService.access$getLOG$cp().warn("Unable to perform auto introspection", (Throwable)e);
                        }
lbl36:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForConnection(LocalDataSource var1_1, Continuation<? super Boolean> $completion) {
        block12: {
            if (!($completion instanceof waitForConnection.1)) ** GOTO lbl-1000
            var16_3 = $completion;
            if ((var16_3.label & -2147483648) != 0) {
                var16_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ ResourceDatabaseConnectionService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ResourceDatabaseConnectionService.access$waitForConnection(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    credentials = DatabaseCredentialsUi.newUIInstance();
                    $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)5);
                    $i$f$forEach = false;
                    var6_9 = $this$forEach$iv.iterator();
lbl16:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        var7_10 = ((IntIterator)var6_9).nextInt();
                        $i$a$-forEach-ResourceDatabaseConnectionService$waitForConnection$2 = false;
                        v0 = (DatabaseConnectionConfig)dataSource;
                        Intrinsics.checkNotNull((Object)credentials);
                        $continuation.L$0 = this;
                        $continuation.L$1 = dataSource;
                        $continuation.L$2 = credentials;
                        $continuation.L$3 = var6_9;
                        $continuation.label = 1;
                        v1 = this.connectionManager.testConnection(v0, credentials, (Continuation)$continuation);
                        if (v1 == var17_5) {
                            return var17_5;
                        }
                        ** GOTO lbl40
                    }
                    break block12;
                }
                case 1: {
                    $i$f$forEach = false;
                    $i$a$-forEach-ResourceDatabaseConnectionService$waitForConnection$2 = false;
                    var6_9 = (Iterator<T>)$continuation.L$3;
                    credentials = (DatabaseCredentials)$continuation.L$2;
                    dataSource = (LocalDataSource)$continuation.L$1;
                    this = (ResourceDatabaseConnectionService)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl40:
                    // 2 sources

                    if (Intrinsics.areEqual((Object)(connectionResult = (TestConnectionExecutionResult)v1), (Object)TestConnectionExecutionResult.Cancelled.INSTANCE)) {
                        ResourceDatabaseConnectionService.LOG.debug("Connection cancelled");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    if (!(connectionResult instanceof TestConnectionExecutionResult.Failure)) break;
                    $this$debug_u24default$iv = ResourceDatabaseConnectionService.LOG;
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        var13_16 = $this$debug_u24default$iv;
                        $i$a$-debug$default-ResourceDatabaseConnectionService$waitForConnection$2$1 = false;
                        var13_16.debug("Unable to connect to database, " + ((TestConnectionExecutionResult.Failure)connectionResult).getResult().getSummary(), e$iv);
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = dataSource;
                    $continuation.L$2 = credentials;
                    $continuation.L$3 = var6_9;
                    $continuation.label = 2;
                    v2 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)$continuation);
                    if (v2 != var17_5) ** GOTO lbl16
                    return var17_5;
                }
                case 2: {
                    $i$f$forEach = false;
                    $i$a$-forEach-ResourceDatabaseConnectionService$waitForConnection$2 = false;
                    var6_9 = (Iterator)$continuation.L$3;
                    credentials = (DatabaseCredentials)$continuation.L$2;
                    dataSource = (LocalDataSource)$continuation.L$1;
                    this = (ResourceDatabaseConnectionService)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl16
                }
            }
            if (connectionResult instanceof TestConnectionExecutionResult.Success) {
                return Boxing.boxBoolean((boolean)true);
            }
            throw new NoWhenBranchMatchedException();
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void removeConnectionStringByUrl(String url) {
        if (url == null) {
            return;
        }
        String string = this.urlToConnectionStrings.remove(url);
        if (string == null) {
            return;
        }
        String connectionString = string;
        this.connectionStrings.remove(connectionString);
    }

    private static final void createDataSource$lambda$9$lambda$8(LocalDataSourceManager $dataSourceManager, LocalDataSource $createdDataSource) {
        $dataSourceManager.removeDataSource($createdDataSource);
    }

    private static final Unit createDataSource$lambda$9(String $url, LocalDataSourceManager $dataSourceManager, LocalDataSource $createdDataSource) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Removing data source " + $url);
        }
        ApplicationKt.getApplication().invokeLater(() -> ResourceDatabaseConnectionService.createDataSource$lambda$9$lambda$8($dataSourceManager, $createdDataSource));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$createDataSource(ResourceDatabaseConnectionService $this, DatabaseResource databaseResource, String modifiedConnectionString, SessionConnectionString connectionString, Continuation $completion) {
        return $this.createDataSource(databaseResource, modifiedConnectionString, connectionString, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getConnectionUrl(ResourceDatabaseConnectionService $this, String connectionString, DatabaseResource databaseResource, DotnetDataProvider dataProvider, DatabaseDriver driver, Continuation $completion) {
        return $this.getConnectionUrl(connectionString, databaseResource, dataProvider, driver, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$waitForConnection(ResourceDatabaseConnectionService $this, LocalDataSource dataSource, Continuation $completion) {
        return $this.waitForConnection(dataSource, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Project access$getProject$p(ResourceDatabaseConnectionService $this) {
        return $this.project;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ResourceDatabaseConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        REDIS_REGEX = new Regex(REDIS_CONNECTION_STRING_PATTERN);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REDIS_CONNECTION_STRING_PATTERN", "", "REDIS_REGEX", "Lkotlin/text/Regex;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nResourceDatabaseConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDatabaseConnectionService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,297:1\n31#2,2:298\n*S KotlinDebug\n*F\n+ 1 ResourceDatabaseConnectionService.kt\ncom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService$Companion\n*L\n49#1:298,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceDatabaseConnectionService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ResourceDatabaseConnectionService> serviceClass$iv = ResourceDatabaseConnectionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ResourceDatabaseConnectionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/aspire/database/ResourceDatabaseConnectionService$DataSourceListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "aspire-plugin"})
    public static final class DataSourceListener
    implements DataSourceStorage.Listener {
        @NotNull
        private final Project project;

        public DataSourceListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Companion.getInstance(this.project).removeConnectionStringByUrl(dataSource.getUrl());
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.POSTGRES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MSSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.ORACLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MONGO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.REDIS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

