/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.database;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.database.DatabaseResource;
import com.jetbrains.rider.aspire.database.DatabaseResourceUrl;
import com.jetbrains.rider.aspire.database.DatabaseType;
import com.jetbrains.rider.aspire.database.ResourceDatabaseService;
import com.jetbrains.rider.aspire.generated.ResourceType;
import com.jetbrains.rider.aspire.generated.ResourceUrl;
import com.jetbrains.rider.aspire.services.AspireResource;
import com.jetbrains.rider.aspire.services.ResourceListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/aspire/database/DatabaseResourceListener;", "Lcom/jetbrains/rider/aspire/services/ResourceListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resourceCreated", "", "resource", "Lcom/jetbrains/rider/aspire/services/AspireResource;", "resourceUpdated", "applyChanges", "getType", "Lcom/jetbrains/rider/aspire/database/DatabaseType;", "image", "", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseResourceListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseResourceListener.kt\ncom/jetbrains/rider/aspire/database/DatabaseResourceListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n11476#2,9:62\n13402#2:71\n13403#2:74\n11485#2:75\n1#3:72\n1#3:73\n*S KotlinDebug\n*F\n+ 1 DatabaseResourceListener.kt\ncom/jetbrains/rider/aspire/database/DatabaseResourceListener\n*L\n32#1:62,9\n32#1:71\n32#1:74\n32#1:75\n32#1:73\n*E\n"})
public final class DatabaseResourceListener
implements ResourceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String POSTGRES = "postgres";
    @NotNull
    private static final String MYSQL = "mysql";
    @NotNull
    private static final String MSSQL = "mssql";
    @NotNull
    private static final String ORACLE = "oracle";
    @NotNull
    private static final String MONGO = "mongo";
    @NotNull
    private static final String REDIS = "redis";

    public DatabaseResourceListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void resourceCreated(@NotNull AspireResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    @Override
    public void resourceUpdated(@NotNull AspireResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyChanges(AspireResource resource) {
        if (resource.getType() == ResourceType.Container) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            String string = resource.getContainerId();
            if (string == null) {
                return;
            }
            String containerId = string;
            DatabaseType databaseType = this.getType(resource.getContainerImage());
            if (databaseType == null) {
                return;
            }
            DatabaseType resourceType = databaseType;
            ResourceUrl[] resourceUrlArray = resource.getUrls();
            boolean $i$f$mapNotNull = false;
            void var7_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                DatabaseResourceUrl databaseResourceUrl;
                Object $this$applyChanges_u24lambda_u242_u24lambda_u240;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void url = element$iv$iv;
                boolean bl2 = false;
                Object object = this;
                try {
                    $this$applyChanges_u24lambda_u242_u24lambda_u240 = object;
                    boolean bl3 = false;
                    $this$applyChanges_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)new URI(url.getFullUrl()));
                }
                catch (Throwable bl3) {
                    $this$applyChanges_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                object = $this$applyChanges_u24lambda_u242_u24lambda_u240;
                URI uRI = (URI)(Result.isFailure-impl((Object)object) ? null : object);
                if (uRI != null) {
                    URI it = uRI;
                    boolean bl4 = false;
                    databaseResourceUrl = new DatabaseResourceUrl(url.getName(), it, url.isInternal());
                } else {
                    databaseResourceUrl = null;
                }
                if (databaseResourceUrl == null) continue;
                DatabaseResourceUrl it$iv$iv = databaseResourceUrl;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List urls = (List)destination$iv$iv;
            if (urls.isEmpty()) {
                return;
            }
            boolean isPersistent = StringsKt.equals((String)resource.getContainerLifetime(), (String)"persistent", (boolean)true);
            DatabaseResource databaseResource = new DatabaseResource(resource.getName(), containerId, resourceType, urls, isPersistent, resource.getLifetime());
            ResourceDatabaseService.Companion.getInstance(this.project).put(databaseResource);
        }
    }

    private final DatabaseType getType(String image) {
        if (image == null) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)POSTGRES, (boolean)false, (int)2, null)) {
            return DatabaseType.POSTGRES;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MYSQL, (boolean)false, (int)2, null)) {
            return DatabaseType.MYSQL;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MSSQL, (boolean)false, (int)2, null)) {
            return DatabaseType.MSSQL;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)ORACLE, (boolean)false, (int)2, null)) {
            return DatabaseType.ORACLE;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MONGO, (boolean)false, (int)2, null)) {
            return DatabaseType.MONGO;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)REDIS, (boolean)false, (int)2, null)) {
            return DatabaseType.REDIS;
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/aspire/database/DatabaseResourceListener$Companion;", "", "<init>", "()V", "POSTGRES", "", "MYSQL", "MSSQL", "ORACLE", "MONGO", "REDIS", "aspire-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

