/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.aspire.actions.dashboard.host;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.aspire.services.AspireHost;
import com.jetbrains.rider.aspire.services.SessionHost;
import com.jetbrains.rider.aspire.sessionHost.SessionHostManager;
import com.jetbrains.rider.aspire.util.DataKeysKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH$J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/aspire/actions/dashboard/host/AspireHostBaseAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAction", "hostService", "Lcom/jetbrains/rider/aspire/services/AspireHost;", "project", "Lcom/intellij/openapi/project/Project;", "update", "getAspireHost", "hostPath", "Ljava/nio/file/Path;", "updateAction", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "aspire-plugin"})
public abstract class AspireHostBaseAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = (AspireHost)event.getData(DataKeysKt.getASPIRE_HOST());
        if (object == null || (object = ((AspireHost)object).getHostProjectPath()) == null) {
            return;
        }
        Object hostPath = object;
        AspireHost aspireHost = this.getAspireHost((Path)hostPath, project2);
        if (aspireHost == null) {
            return;
        }
        AspireHost aspireHost2 = aspireHost;
        this.performAction(aspireHost2, project2);
    }

    protected abstract void performAction(@NotNull AspireHost var1, @NotNull Project var2);

    public void update(@NotNull AnActionEvent event) {
        Path hostPath;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        AspireHost aspireHost = (AspireHost)event.getData(DataKeysKt.getASPIRE_HOST());
        Path path = hostPath = aspireHost != null ? aspireHost.getHostProjectPath() : null;
        if (project == null || hostPath == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        AspireHost aspireHost2 = this.getAspireHost(hostPath, project);
        if (aspireHost2 == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.updateAction(event, aspireHost2);
    }

    private final AspireHost getAspireHost(Path hostPath, Project project) {
        SessionHost sessionHost = SessionHostManager.Companion.getInstance(project).getSessionHost();
        return sessionHost.getAspireHost(hostPath);
    }

    protected abstract void updateAction(@NotNull AnActionEvent var1, @NotNull AspireHost var2);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

