/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import com.jetbrains.rider.ui.RiderIdeUICustomizationBundle;
import java.util.Arrays;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ui/RiderIdeUICustomization;", "Lcom/intellij/ui/IdeUICustomization;", "RiderIdeUICustomization", "()V", "getProjectViewTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "getSelectAutopopupByCharsText", "getActionText", "actionId", "getActionDescription", "projectMessagePointer", "Ljava/util/function/Supplier;", "key", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "projectMessage", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getUiThemeEditorSchemeId", "themeId", "editorSchemeId", "intellij.rider.shared.settings"})
public final class RiderIdeUICustomization
extends IdeUICustomization {
    @NotNull
    public String getProjectViewTitle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.SolutionViewPaneBase.view.name.explorer", new Object[0]);
    }

    @NotNull
    public String getSelectAutopopupByCharsText() {
        return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.checkbox.autopopup.by.chars.text", new Object[0]);
    }

    @Nullable
    public String getActionText(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return switch (actionId) {
            case "Debugger.FreezeActiveThreadAction" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Debugger.FreezeActiveThreadAction.text", new Object[0]);
            case "Debugger.FreezeInactiveThreadsAction" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Debugger.FreezeInactiveThreadsAction.text", new Object[0]);
            case "Debugger.FreezeInactiveThreadsAmongSelected" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Debugger.FreezeInactiveThreadsAmongSelected.text", new Object[0]);
            case "Debugger.ThawActiveThreadAction" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Debugger.ThawActiveThreadAction.text", new Object[0]);
            case "Debugger.ThawAllThreadsAction" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Debugger.ThawAllThreadsAction.text", new Object[0]);
            case "MergeAllWindowsAction" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.MergeAllWindowsAction.text", new Object[0]);
            case "NextProjectWindow" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.NextProjectWindow.text", new Object[0]);
            case "OpenProjectWindows" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.group.OpenProjectWindows.text", new Object[0]);
            case "Performance.DumpThreads" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.Performance.DumpThreads.text", new Object[0]);
            case "PreviousProjectWindow" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.PreviousProjectWindow.text", new Object[0]);
            case "ToolsMenu" -> RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.group.ToolsMenu.text", new Object[0]);
            default -> super.getActionText(actionId);
        };
    }

    @Nullable
    public String getActionDescription(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String string = actionId;
        return Intrinsics.areEqual((Object)string, (Object)"NextProjectWindow") ? RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.NextProjectWindow.description", new Object[0]) : (Intrinsics.areEqual((Object)string, (Object)"PreviousProjectWindow") ? RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.action.PreviousProjectWindow.description", new Object[0]) : super.getActionText(actionId));
    }

    @NotNull
    public Supplier<String> projectMessagePointer(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.project.text")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.project.text", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.project.description")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.project.description", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.other.projects.text")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.other.projects.text", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.other.projects.description")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.other.projects.description", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.all.projects.text")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.all.projects.text", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"action.close.all.projects.description")) {
            return RiderIdeUICustomizationBundle.Companion.messagePointer("RiderIdeUICustomization.action.close.all.solutions", new Object[0]);
        }
        Supplier supplier = super.projectMessagePointer(key, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"projectMessagePointer(...)");
        return supplier;
    }

    @NotNull
    public String projectMessage(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (Intrinsics.areEqual((Object)key, (Object)"message.build.project")) {
            return RiderIdeUICustomizationBundle.Companion.message("message.build.solution", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"tab.title.project")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.tab.titile.project", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"select.in.item.project.view")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.SolutionViewPaneBase.view.name.explorer", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"scope.name.non.project.files")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.scope.name.non.solution.files", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"project.load.progress")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.progress.text.loading.solution", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"project.unsaved")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.unsaved.solution", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"progress.title.project.loading.name")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.loading.solution", Arrays.copyOf(params, params.length));
        }
        if (Intrinsics.areEqual((Object)key, (Object)"checkbox.include.non.project.items")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.checkbox.include.non.solution.items", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"checkbox.include.non.project.files")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.checkbox.include.non.solution.files", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"checkbox.include.non.project.symbols")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.checkbox.include.non.solution.symbols", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"popup.title.recent.projects")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.popup.title.recent.projects", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"title.new.project")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.title.new.project", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"title.open.project")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.title.open.project", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"prompt.open.project.in.new.frame")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.prompt.open.project.in.new.frame", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"prompt.open.project.with.name.in.new.frame")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.prompt.open.project.with.name.in.new.frame", Arrays.copyOf(params, params.length));
        }
        if (Intrinsics.areEqual((Object)key, (Object)"project.widget.open.projects")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.project.widget.open.projects", new Object[0]);
        }
        if (Intrinsics.areEqual((Object)key, (Object)"project.widget.recent.projects")) {
            return RiderIdeUICustomizationBundle.Companion.message("RiderIdeUICustomization.project.widget.recent.projects", new Object[0]);
        }
        String string = super.projectMessage(key, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
        return string;
    }

    @Nullable
    public String getUiThemeEditorSchemeId(@NotNull String themeId, @Nullable String editorSchemeId) {
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        return switch (themeId) {
            case "ExperimentalDark" -> "Rider Dark";
            case "ExperimentalLight" -> "Rider Light";
            case "ExperimentalLightWithLightHeader" -> "Rider Light";
            default -> super.getUiThemeEditorSchemeId(themeId, editorSchemeId);
        };
    }
}

