/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.debugger.wasm;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.jetbrains.rider.shared.debugger.wasm.ProcessHandlerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"withOutputMonitoring", "TProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "shortName", "", "(Lcom/intellij/execution/process/OSProcessHandler;Ljava/lang/String;)Lcom/intellij/execution/process/OSProcessHandler;", "intellij.rider.shared"})
public final class ProcessHandlerExtensionsKt {
    @NotNull
    public static final <TProcessHandler extends OSProcessHandler> TProcessHandler withOutputMonitoring(@NotNull TProcessHandler $this$withOutputMonitoring, @NotNull String shortName) {
        Intrinsics.checkNotNullParameter($this$withOutputMonitoring, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Logger logger = Logger.getInstance((String)"ProcessHandlerMonitoring");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        String string = shortName + " (" + ((BaseOSProcessHandler)$this$withOutputMonitoring).getProcess().pid() + ")";
        AnsiEscapeDecoder ansiEscapeDecoder = new AnsiEscapeDecoder();
        ((ProcessHandler)$this$withOutputMonitoring).addProcessListener((ProcessListener)new ProcessAdapter(ansiEscapeDecoder, logger2, string){
            final /* synthetic */ AnsiEscapeDecoder $escapeDecodes;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $processLabel;
            {
                this.$escapeDecodes = $escapeDecodes;
                this.$logger = $logger;
                this.$processLabel = $processLabel;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.$escapeDecodes.escapeText(((Object)StringsKt.trim((CharSequence)string)).toString(), outputType, (arg_0, arg_1) -> withOutputMonitoring.1.G(outputType, this.$logger, this.$processLabel, arg_0, arg_1));
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$logger.debug(this.$processLabel + " - GOING TO BE TERMINATED: destroy - " + willBeDestroyed + "\nhandler - " + event.getProcessHandler() + "\nexitCode - " + event.getExitCode());
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$logger.debug(this.$processLabel + " - TERMINATED: handler - " + event.getProcessHandler() + "\nexitCode - " + event.getExitCode());
            }

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$logger.info(this.$processLabel + " - started");
            }

            public void processNotStarted() {
                this.$logger.info("$" + this.$processLabel + " - NOT STARTED");
            }

            private static final void G(Key key, Logger logger, String string, String string2, Key key2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)key2, (String)"type");
                Key key3 = key;
                if (Intrinsics.areEqual((Object)key3, (Object)ProcessOutputTypes.STDOUT)) {
                    logger.info(string + " - stdout: " + string2);
                } else if (Intrinsics.areEqual((Object)key3, (Object)ProcessOutputTypes.SYSTEM)) {
                    logger.info(string + " - system: " + string2);
                } else if (Intrinsics.areEqual((Object)key3, (Object)ProcessOutputTypes.STDERR)) {
                    logger.warn(string + " - stderr: " + string2);
                } else {
                    logger.info(string + " - unknown: " + string2);
                }
            }
        });
        return $this$withOutputMonitoring;
    }
}

