/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session;

import com.jetbrains.rider.languages.fileTypes.csharp.indenter.IndentingRule;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TreeWalker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010!\u001a\u00020\u001e2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000bJ\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/kotoparser/session/ActiveIndentRule;", "", "rule", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;", "startLineNumber", "", "relativeIndent", "id", "", "nodeId", "enterNode", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;", "ActiveIndentRule", "(Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;JJIILcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;)V", "getRule", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;", "getStartLineNumber", "()J", "getRelativeIndent", "getId", "()I", "getNodeId", "getEnterNode", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;", "endNode", "getEndNode", "getEndLine", "text", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TextContent;", "isCollapsesWith", "", "currentNode", "currentNodeStartLine", "endsAt", "node", "toString", "", "intellij.rider.languages"})
public final class ActiveIndentRule {
    @NotNull
    private final IndentingRule rule;
    private final long startLineNumber;
    private final long relativeIndent;
    private final int id;
    private final int nodeId;
    @NotNull
    private final TreeWalker<?> enterNode;
    @Nullable
    private final TreeWalker<?> endNode;

    public ActiveIndentRule(@NotNull IndentingRule rule, long startLineNumber, long relativeIndent, int id, int nodeId, @NotNull TreeWalker<?> enterNode) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter(enterNode, (String)"enterNode");
        this.rule = rule;
        this.startLineNumber = startLineNumber;
        this.relativeIndent = relativeIndent;
        this.id = id;
        this.nodeId = nodeId;
        this.enterNode = enterNode;
        this.endNode = (TreeWalker)this.rule.getEndLocator().invoke(this.enterNode);
    }

    @NotNull
    public final IndentingRule getRule() {
        return this.rule;
    }

    public final long getStartLineNumber() {
        return this.startLineNumber;
    }

    public final long getRelativeIndent() {
        return this.relativeIndent;
    }

    public final int getId() {
        return this.id;
    }

    public final int getNodeId() {
        return this.nodeId;
    }

    @NotNull
    public final TreeWalker<?> getEnterNode() {
        return this.enterNode;
    }

    @Nullable
    public final TreeWalker<?> getEndNode() {
        return this.endNode;
    }

    public final long getEndLine(@NotNull TextContent text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.G(this, text);
    }

    private final long G(ActiveIndentRule activeIndentRule, TextContent textContent) {
        if (activeIndentRule.endNode == null) {
            return textContent.linesCount() - 1L;
        }
        return textContent.lineNumber(activeIndentRule.endNode.getEndOffset());
    }

    public final boolean isCollapsesWith(@NotNull TreeWalker<?> currentNode, long currentNodeStartLine, @NotNull IndentingRule rule, @NotNull TextContent text) {
        Intrinsics.checkNotNullParameter(currentNode, (String)"currentNode");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ActiveIndentRule activeIndentRule = new ActiveIndentRule(rule, currentNodeStartLine, 0L, 0, 0, currentNode);
        return this.isCollapsesWith(activeIndentRule, text);
    }

    public final boolean isCollapsesWith(@NotNull ActiveIndentRule rule, @NotNull TextContent text) {
        long l;
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.startLineNumber != rule.startLineNumber) {
            return false;
        }
        if (this.rule.getIndentType() != rule.rule.getIndentType()) {
            return false;
        }
        long l2 = this.G(this, text);
        return l2 == (l = this.G(rule, text));
    }

    public final boolean endsAt(@NotNull TreeWalker<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return Intrinsics.areEqual(this.endNode, node);
    }

    @NotNull
    public String toString() {
        TreeWalker<?> treeWalker = this.endNode;
        return "'" + this.rule.getName() + "':" + this.startLineNumber + " " + this.rule.getIndentType() + " [" + this.enterNode.getType() + ".." + (treeWalker != null ? treeWalker.getType() : null) + "]";
    }
}

