/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/TypingAssistUtils;", "", "TypingAssistUtils", "()V", "isCaretOnIndenting", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "selection", "Lcom/intellij/openapi/util/TextRange;", "getTextBeforeCaret", "", "isBlockOfCodeSelected", "intellij.rider.languages"})
public final class TypingAssistUtils {
    @NotNull
    public static final TypingAssistUtils INSTANCE = new TypingAssistUtils();

    private TypingAssistUtils() {
    }

    @JvmStatic
    public static final boolean isCaretOnIndenting(@NotNull Editor editor, @NotNull TextRange selection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        String string = TypingAssistUtils.getTextBeforeCaret(editor, selection);
        return StringsKt.isBlank((CharSequence)string);
    }

    @JvmStatic
    @NotNull
    public static final String getTextBeforeCaret(@NotNull Editor editor, @NotNull TextRange selection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        TextRange textRange = selection;
        int n = textRange.getStartOffset();
        int n2 = textRange.getEndOffset();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(n);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        LogicalPosition logicalPosition3 = editor.offsetToLogicalPosition(n2);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition4 = logicalPosition3;
        if (logicalPosition2.line != logicalPosition4.line) {
            return ".";
        }
        if (!textRange.isEmpty()) {
            n = n2;
        }
        int n3 = document2.getLineStartOffset(logicalPosition2.line);
        String string = document2.getText(new TextRange(n3, n));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @JvmStatic
    public static final boolean isBlockOfCodeSelected(@NotNull Editor editor, @NotNull TextRange selection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.isEmpty()) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int n = selection.getStartOffset();
        int n2 = selection.getEndOffset();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(n);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        LogicalPosition logicalPosition3 = editor.offsetToLogicalPosition(n2);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition4 = logicalPosition3;
        if (logicalPosition2.line != logicalPosition4.line) {
            return true;
        }
        String string = document2.getText(selection);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        if (StringsKt.isBlank((CharSequence)string2)) {
            return false;
        }
        int n3 = document2.getLineStartOffset(logicalPosition2.line);
        String string3 = document2.getText(new TextRange(n3, n));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String string4 = string3;
        int n4 = document2.getLineEndOffset(logicalPosition2.line);
        String string5 = document2.getText(new TextRange(n2, n4));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        String string6 = string5;
        return StringsKt.isBlank((CharSequence)string4) && StringsKt.isBlank((CharSequence)string6);
    }
}

