/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProvider;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.UtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.RiderTextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.CsTreeUtilsKt;
import com.jetbrains.rider.rdclient.languages.RiderBreakingWorkflowChangeInterceptor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpTypedHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "CSharpTypedHandlerDelegate", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.rider.languages"})
public final class CSharpTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        boolean bl2 = bl = Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)CSharpLanguage.INSTANCE)) && !Intrinsics.areEqual((Object)file.getViewProvider().getBaseLanguage(), (Object)((Object)CSharpLanguage.INSTANCE));
        if (bl) {
            return TypedHandlerDelegate.Result.STOP;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (c == ';' && UtilsKt.isCSharpFile(file) && !editor.isViewer() && document2.isWritable()) {
            String string = " \t";
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            int n = CharArrayUtil.shiftForward((CharSequence)document2.getCharsSequence(), (int)caretModel2.getCurrentCaret().getOffset(), (String)string);
            if (n < document2.getTextLength() && document2.getCharsSequence().charAt(n) != '\n') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            long l = document2.getLineNumber(caretModel2.getCurrentCaret().getOffset());
            RiderTextContent riderTextContent = new RiderTextContent(document2);
            int n2 = (int)riderTextContent.lineStartOffset(l);
            CharSequence charSequence = CsTreeUtilsKt.indentOfLine(TextContent.line$default(riderTextContent, l, false, 2, null));
            document2.replaceString(n2, n2 + charSequence.length(), (CharSequence)"");
            String string2 = new CSharpLineIndentProvider().getLineIndent(project, editor, CSharpLanguage.INSTANCE, caretModel2.getCurrentCaret().getOffset());
            if (string2 == null) {
                document2.insertString(n2, charSequence);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            RiderBreakingWorkflowChangeInterceptor.Companion.guardChange(editor, (Function0<Unit>)((Function0)() -> CSharpTypedHandlerDelegate.G(document2, n2, string2)));
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static final Unit G(Document document, int n, String string) {
        document.insertString(n, (CharSequence)string);
        return Unit.INSTANCE;
    }
}

