/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpBraceMatcher;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpQuoteHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/JavaLikeQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/QuoteHandler;", "CSharpQuoteHandler", "()V", "BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET", "Lcom/intellij/psi/tree/ParentAwareTokenSet;", "myAppropriateElementTypeForLiteral", "Lorg/jetbrains/annotations/NotNull;", "isOpeningQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isClosingQuote", "getConcatenatableStringTokenTypes", "Lcom/intellij/psi/tree/TokenSet;", "getStringConcatenationOperatorRepresentation", "", "getStringTokenTypes", "isAppropriateElementTypeForLiteral", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "needParenthesesAroundConcatenation", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rider.languages"})
public final class CSharpQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler,
QuoteHandler {
    @NotNull
    private final ParentAwareTokenSet BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET;
    @NotNull
    private final ParentAwareTokenSet myAppropriateElementTypeForLiteral;

    public CSharpQuoteHandler() {
        super(CSharpQuoteHandlerKt.access$getLiteralTokenSet$p());
        ParentAwareTokenSet[] parentAwareTokenSetArray = new ParentAwareTokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{CSharpTokenType.NEW_LINE, TokenType.WHITE_SPACE};
        parentAwareTokenSetArray[0] = ParentAwareTokenSet.create((IElementType[])iElementTypeArray);
        parentAwareTokenSetArray[1] = CSharpBraceMatcher.Companion.getBASIC_CSHARP_COMMENT_BIT_SET();
        ParentAwareTokenSet parentAwareTokenSet = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)parentAwareTokenSet, (String)"orSet(...)");
        this.BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET = parentAwareTokenSet;
        parentAwareTokenSetArray = new ParentAwareTokenSet[3];
        parentAwareTokenSetArray[0] = this.BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET;
        parentAwareTokenSetArray[1] = ParentAwareTokenSet.create((TokenSet)CSharpQuoteHandlerKt.getBASIC_TEXT_LITERALS());
        iElementTypeArray = new IElementType[]{CSharpTokenType.SEMICOLON, CSharpTokenType.COMMA, CSharpTokenType.RPARENTH, CSharpTokenType.RBRACKET, CSharpTokenType.RBRACE};
        parentAwareTokenSetArray[2] = ParentAwareTokenSet.create((IElementType[])iElementTypeArray);
        ParentAwareTokenSet parentAwareTokenSet2 = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)parentAwareTokenSet2, (String)"orSet(...)");
        this.myAppropriateElementTypeForLiteral = parentAwareTokenSet2;
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return false;
        }
        boolean bl = this.myLiteralTokenSet.contains(iterator2.getTokenType());
        if (bl && !iterator2.atEnd()) {
            iterator2.retreat();
            if (!iterator2.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType())) {
                bl = false;
            }
            iterator2.advance();
        }
        return bl;
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return false;
        }
        if (iterator2.getTokenType() == CSharpTokenType.MULTI_LINE_RAW_STRING_LITERAL) {
            int n = iterator2.getStart();
            int n2 = iterator2.getEnd();
            return n2 - n >= 5 && offset >= n2 - 3;
        }
        boolean bl = super.isClosingQuote(iterator2, offset);
        if (bl && !iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType())) {
                bl = false;
            }
            iterator2.retreat();
        }
        return bl;
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet;
        if (CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            tokenSet = CSharpQuoteHandlerKt.access$getMyConcatenableStrings$p();
        } else {
            TokenSet tokenSet2 = TokenSet.EMPTY;
            tokenSet = tokenSet2;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"EMPTY");
        }
        return tokenSet;
    }

    @NotNull
    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    @NotNull
    public TokenSet getStringTokenTypes() {
        TokenSet tokenSet;
        if (CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            TokenSet tokenSet2 = this.myLiteralTokenSet;
            tokenSet = tokenSet2;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"myLiteralTokenSet");
        } else {
            TokenSet tokenSet3 = TokenSet.EMPTY;
            tokenSet = tokenSet3;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"EMPTY");
        }
        return tokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return CSharpLineIndentProviderKt.isPatchEngineEnabled() ? this.myAppropriateElementTypeForLiteral.contains(tokenType) : false;
    }

    public boolean needParenthesesAroundConcatenation(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }
}

