/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.UtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContentLine;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.IndentingUtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.PsiTreeWalker;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.RiderTextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.CsIndentingNaiveRulesSetKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.RiderIndentingEditorSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J*\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "Lcom/intellij/psi/codeStyle/joinLines/JoinedLinesSpacingCalculator;", "CSharpLineIndentProvider", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "getJoinedLinesSpacing", "intellij.rider.languages"})
public final class CSharpLineIndentProvider
implements LineIndentProvider,
JoinedLinesSpacingCalculator {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project2 = editor.getProject();
        Intrinsics.checkNotNull((Object)project2);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        psiDocumentManager.commitDocument(editor.getDocument());
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor.getDocument());
        if (psiFile == null || !UtilsKt.isCSharpFile(psiFile)) {
            return null;
        }
        PsiTreeWalker psiTreeWalker = new PsiTreeWalker((PsiElement)psiFile);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        RiderTextContent riderTextContent = new RiderTextContent(document);
        RiderIndentingEditorSettings riderIndentingEditorSettings = RiderIndentingEditorSettings.Companion.getUserDefinedSettings(psiFile, psiFile.getLanguage());
        long l = riderTextContent.lineNumber(offset);
        TextContentLine textContentLine = TextContent.line$default(riderTextContent, l, false, 2, null);
        Object object2 = this;
        try {
            object = object2;
            bl = false;
            object = Result.constructor-impl(IndentingUtilsKt.calculateCsIndent(CsIndentingNaiveRulesSetKt.getCsIndentingNaiveRulesSet(), psiTreeWalker, riderTextContent, textContentLine.getStartOffset(), textContentLine.getEndOffset(), RiderIndentingEditorSettings.Companion.toSettings(riderIndentingEditorSettings), new VerboseIndentingLogger(), false));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            object = throwable;
            bl = false;
            CSharpLineIndentProviderKt.access$getLogger$p().warn("Couldn't calculate C# line indent. The following error occurred: " + ((Throwable)object).getMessage());
            return null;
        }
        List list2 = (List)object2;
        if (list2.size() != 1) {
            CSharpLineIndentProviderKt.access$getLogger$p().error("There supposed to be one calculated indent for a line on offset='" + offset + "', but was " + list2.size() + " indents.");
            return null;
        }
        return (String)list2.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuitableFor(@Nullable Language language) {
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) return false;
        Language language2 = language;
        if (language2 == null) return false;
        boolean bl = language2.isKindOf((Language)CSharpLanguage.INSTANCE);
        if (!bl) return false;
        return true;
    }

    public int getJoinedLinesSpacing(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int n = editor.getDocument().getTextLength();
        if (!(0 <= offset ? offset < n : false)) {
            return 0;
        }
        char c = editor.getDocument().getCharsSequence().charAt(offset);
        int n2 = offset - 2;
        boolean bl = 0 <= n2 ? n2 < n : false;
        if (bl && editor.getDocument().getCharsSequence().charAt(offset - 2) == '\"') {
            return 0;
        }
        return c != ' ' && c != '\t' && c != '\n' ? 1 : 0;
    }
}

