/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpEnterInStringLiteralHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpQuoteHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import com.jetbrains.rider.rdclient.languages.assists.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014JL\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpEnterInStringLiteralHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterInStringLiteralHandler;", "CSharpEnterInStringLiteralHandler", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvanceRef", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isInsideLiteral", "", "quoteHandler", "Lcom/intellij/codeInsight/editorActions/JavaLikeQuoteHandler;", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "splitString", "psiAtOffset", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "caretOffset", "intellij.rider.languages"})
public final class CSharpEnterInStringLiteralHandler
extends EnterInStringLiteralHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled() || !(file.getLanguage() instanceof CSharpLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer n = (Integer)caretOffsetRef.get();
        JavaLikeQuoteHandler javaLikeQuoteHandler = this.getJavaLikeQuoteHandler(editor, (PsiElement)file);
        Intrinsics.checkNotNull((Object)n);
        if (!this.isInStringLiteral(editor, javaLikeQuoteHandler, n)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        boolean bl2 = bl = !Intrinsics.areEqual((Object)editor.getUserData(UtilsKt.getEXECUTE_ON_FRONTEND()), (Object)true);
        if (bl) {
            return EnterHandlerDelegate.Result.Stop;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement psiElement = file.findElementAt(n.intValue());
        if (psiElement != null && psiElement.getTextOffset() < n) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if (CSharpTokenType.VERBATIM_STRINGS.contains(PsiUtilCore.getElementType((PsiElement)psiElement))) {
                document2.insertString(n.intValue(), (CharSequence)"\n");
                editor.getCaretModel().getCurrentCaret().moveToOffset(editor.getCaretModel().getCurrentCaret().getOffset() + 1);
                return EnterHandlerDelegate.Result.Stop;
            }
            if (javaLikeQuoteHandler != null && CSharpEnterInStringLiteralHandlerKt.access$getMyInterpolatedConcatenableStrings$p().contains(PsiUtilCore.getElementType((PsiElement)psiElement))) {
                return this.splitString(file, caretOffsetRef, caretAdvanceRef, psiElement, document2, n, javaLikeQuoteHandler);
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean isInsideLiteral(@NotNull JavaLikeQuoteHandler quoteHandler, @NotNull HighlighterIterator iterator2) {
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        IElementType iElementType = iterator2.getTokenType();
        return CSharpQuoteHandlerKt.getBASIC_TEXT_LITERALS().contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)CSharpTokenType.INTERPOLATION_LBRACE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)CSharpTokenType.INTERPOLATION_RBRACE));
    }

    @NotNull
    protected EnterHandlerDelegate.Result splitString(@NotNull PsiFile file, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull PsiElement psiAtOffset, @NotNull Document document, int caretOffset, @NotNull JavaLikeQuoteHandler quoteHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)psiAtOffset, (String)"psiAtOffset");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        ASTNode aSTNode = psiAtOffset.getNode();
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        TextRange textRange = aSTNode.getTextRange();
        char c = aSTNode.getText().charAt(0);
        StringLiteralLexer stringLiteralLexer = new StringLiteralLexer(c, aSTNode.getElementType());
        stringLiteralLexer.start(charSequence, textRange.getStartOffset(), textRange.getEndOffset());
        int n = EnterInStringLiteralHandler.skipStringLiteralEscapes((int)caretOffset, (StringLiteralLexer)stringLiteralLexer);
        n = EnterInStringLiteralHandler.wrapWithParensIfNeeded((PsiElement)psiAtOffset, (Document)document, (int)n, (JavaLikeQuoteHandler)quoteHandler);
        String string2 = "\" +";
        document.insertString(n, (CharSequence)(string2 + " $\""));
        n += string2.length() + 1;
        int n2 = 2;
        if (CodeStyle.getLanguageSettings((PsiFile)file).BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
            --n;
            n2 = 3;
        }
        caretOffsetRef.set((Object)n);
        caretAdvanceRef.set((Object)n2);
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }
}

