/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpBraceMatcherKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.CSharpElementType;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpBraceMatcher;", "Lcom/intellij/lang/PairedBraceMatcher;", "CSharpBraceMatcher", "()V", "pairs", "", "Lcom/intellij/lang/BracePair;", "[Lcom/intellij/lang/BracePair;", "getPairs", "()[Lcom/intellij/lang/BracePair;", "isPairedBracesAllowedBeforeType", "", "lbraceType", "Lcom/intellij/psi/tree/IElementType;", "contextType", "getCodeConstructStart", "", "file", "Lcom/intellij/psi/PsiFile;", "openingBraceOffset", "Companion", "intellij.rider.languages"})
public final class CSharpBraceMatcher
implements PairedBraceMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BracePair[] pairs;
    @NotNull
    private static final TokenSet BASIC_CSHARP_PLAIN_COMMENT_BIT_SET;
    @NotNull
    private static final ParentAwareTokenSet BASIC_CSHARP_COMMENT_BIT_SET;
    @NotNull
    private static final ParentAwareTokenSet BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET;
    @NotNull
    private static final ParentAwareTokenSet BASIC_CSHARP_STATEMENT_BIT_SET;
    @NotNull
    private static final TokenSet BASIC_CLASS_KEYWORD_BIT_SET;

    public CSharpBraceMatcher() {
        BracePair[] bracePairArray = new BracePair[]{new BracePair((IElementType)CSharpTokenType.LPARENTH, (IElementType)CSharpTokenType.RPARENTH, false), new BracePair((IElementType)CSharpTokenType.LBRACE, (IElementType)CSharpTokenType.RBRACE, true), new BracePair((IElementType)CSharpTokenType.LBRACKET, (IElementType)CSharpTokenType.RBRACKET, false), new BracePair((IElementType)CSharpTokenType.INTERPOLATION_LBRACE, (IElementType)CSharpTokenType.INTERPOLATION_RBRACE, true), new BracePair((IElementType)CSharpTokenType.LT, (IElementType)CSharpTokenType.GT, false)};
        this.pairs = bracePairArray;
    }

    @NotNull
    public BracePair[] getPairs() {
        return CSharpLineIndentProviderKt.isPatchEngineEnabled() ? this.pairs : new BracePair[]{};
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        Intrinsics.checkNotNullParameter((Object)lbraceType, (String)"lbraceType");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return false;
        }
        if (contextType instanceof CSharpElementType) {
            return CSharpBraceMatcher.Companion.G(contextType);
        }
        return true;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = file.findElementAt(openingBraceOffset);
        if (psiElement == null || psiElement instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement psiElement2 = psiElement.getParent();
        if (psiElement2 == null) {
            return openingBraceOffset;
        }
        ASTNode aSTNode = psiElement2.getNode();
        if (CSharpBraceMatcherKt.is(aSTNode, (IElementType)CSharpElementTypes.INSTANCE.getDUMMY_BLOCK())) {
            if (CSharpBraceMatcherKt.is(aSTNode = aSTNode.getTreeParent(), (IElementType)CSharpElementTypes.INSTANCE.getMETHOD_DECLARATION()) || CSharpBraceMatcherKt.is(aSTNode, (IElementType)CSharpElementTypes.INSTANCE.getCTOR_DECLARATION())) {
                TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange((PsiElement)aSTNode.getPsi());
                if (textRange == null) {
                    return aSTNode.getTextRange().getStartOffset();
                }
                return textRange.getStartOffset();
            }
            if (CSharpBraceMatcherKt.is(aSTNode, BASIC_CSHARP_STATEMENT_BIT_SET)) {
                return aSTNode.getTextRange().getStartOffset();
            }
        } else if (CSharpBraceMatcherKt.is(aSTNode, BASIC_CLASS_KEYWORD_BIT_SET)) {
            TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange((PsiElement)psiElement2);
            if (textRange == null) {
                return aSTNode.getTextRange().getStartOffset();
            }
            return textRange.getStartOffset();
        }
        return openingBraceOffset;
    }

    static {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        BASIC_CSHARP_PLAIN_COMMENT_BIT_SET = tokenSet;
        ParentAwareTokenSet[] parentAwareTokenSetArray = new ParentAwareTokenSet[]{ParentAwareTokenSet.create((TokenSet)BASIC_CSHARP_PLAIN_COMMENT_BIT_SET)};
        ParentAwareTokenSet parentAwareTokenSet = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)parentAwareTokenSet, (String)"orSet(...)");
        BASIC_CSHARP_COMMENT_BIT_SET = parentAwareTokenSet;
        parentAwareTokenSetArray = new ParentAwareTokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE};
        parentAwareTokenSetArray[0] = ParentAwareTokenSet.create((IElementType[])iElementTypeArray);
        parentAwareTokenSetArray[1] = BASIC_CSHARP_COMMENT_BIT_SET;
        ParentAwareTokenSet parentAwareTokenSet2 = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)parentAwareTokenSet2, (String)"orSet(...)");
        BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET = parentAwareTokenSet2;
        parentAwareTokenSetArray = new IElementType[]{CSharpElementTypes.INSTANCE.getLINE_STATEMENT(), CSharpElementTypes.INSTANCE.getACCESSOR_STATEMENT(), CSharpElementTypes.INSTANCE.getVAR_DECLARATION_STATEMENT()};
        ParentAwareTokenSet parentAwareTokenSet3 = ParentAwareTokenSet.create((IElementType[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)parentAwareTokenSet3, (String)"create(...)");
        BASIC_CSHARP_STATEMENT_BIT_SET = parentAwareTokenSet3;
        parentAwareTokenSetArray = new IElementType[]{CSharpTokenType.CLASS_KEYWORD, CSharpTokenType.INTERFACE_KEYWORD, CSharpTokenType.ENUM_KEYWORD, CSharpTokenType.RECORD_KEYWORD};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])parentAwareTokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        BASIC_CLASS_KEYWORD_BIT_SET = tokenSet2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpBraceMatcher$Companion;", "", "CSharpBraceMatcher$Companion", "()V", "BASIC_CSHARP_PLAIN_COMMENT_BIT_SET", "Lcom/intellij/psi/tree/TokenSet;", "BASIC_CSHARP_COMMENT_BIT_SET", "Lcom/intellij/psi/tree/ParentAwareTokenSet;", "getBASIC_CSHARP_COMMENT_BIT_SET", "()Lcom/intellij/psi/tree/ParentAwareTokenSet;", "BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET", "BASIC_CSHARP_STATEMENT_BIT_SET", "getBASIC_CSHARP_STATEMENT_BIT_SET", "BASIC_CLASS_KEYWORD_BIT_SET", "getBASIC_CLASS_KEYWORD_BIT_SET", "()Lcom/intellij/psi/tree/TokenSet;", "G", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "intellij.rider.languages"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParentAwareTokenSet getBASIC_CSHARP_COMMENT_BIT_SET() {
            return BASIC_CSHARP_COMMENT_BIT_SET;
        }

        @NotNull
        public final ParentAwareTokenSet getBASIC_CSHARP_STATEMENT_BIT_SET() {
            return BASIC_CSHARP_STATEMENT_BIT_SET;
        }

        @NotNull
        public final TokenSet getBASIC_CLASS_KEYWORD_BIT_SET() {
            return BASIC_CLASS_KEYWORD_BIT_SET;
        }

        private final boolean G(IElementType iElementType) {
            return BASIC_CSHARP_COMMENT_OR_WHITESPACE_BIT_SET.contains(iElementType) || iElementType == CSharpTokenType.NEW_LINE || iElementType == CSharpTokenType.SEMICOLON || iElementType == CSharpTokenType.COMMA || iElementType == CSharpTokenType.RPARENTH || iElementType == CSharpTokenType.RBRACKET || iElementType == CSharpTokenType.RBRACE || iElementType == CSharpTokenType.LBRACE || iElementType == CSharpTokenType.DOT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

