/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProvider;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpQuoteHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.UtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpElementTypes;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandler;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "CSharpBackspaceHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getOriginalHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "G", "", "G", "project", "Lcom/intellij/openapi/project/Project;", "G", "previousLine", "", "intellij.rider.languages"})
@SourceDebugExtension(value={"SMAP\nCSharpBackspaceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSharpBackspaceHandler.kt\ncom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpBackspaceHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,144:1\n1#2:145\n1069#3,2:146\n*S KotlinDebug\n*F\n+ 1 CSharpBackspaceHandler.kt\ncom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpBackspaceHandler\n*L\n143#1:146,2\n*E\n"})
public final class CSharpBackspaceHandler
extends BackspaceHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public CSharpBackspaceHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        super(originalHandler);
        this.originalHandler = originalHandler;
    }

    @NotNull
    public final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (dataContext == null || editor.getCaretModel().getCaretCount() != 1 || !this.G(editor, caret, dataContext)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    private final boolean G(Editor editor, Caret caret, DataContext dataContext) {
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null || !(psiFile.getLanguage() instanceof CSharpLanguage)) {
            return false;
        }
        Object object = this;
        try {
            CSharpBackspaceHandler cSharpBackspaceHandler = object;
            boolean bl = false;
            boolean bl2 = cSharpBackspaceHandler.G(editor, caret, project, dataContext);
            if (!bl2) {
                return false;
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            return true;
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                boolean bl = false;
                StackTraceElement[] stackTraceElementArray = throwable3.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                Object[] objectArray = stackTraceElementArray;
                String string = System.lineSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
                String string2 = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string, null, null, (int)0, null, CSharpBackspaceHandler::G, (int)30, null);
                BackspaceHandler.LOG.error("Couldn't execute backspace handler for C#: " + throwable3.getMessage() + System.lineSeparator() + string2);
                return false;
            }
            throw new KotlinNothingValueException();
        }
    }

    private final boolean G(Editor editor, Caret caret, Project project, DataContext dataContext) {
        int n;
        CharSequence charSequence;
        int n2;
        int n3 = caret.getOffset();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (document2.getLineNumber(n3) == 0) {
            return false;
        }
        CharSequence charSequence2 = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getCharsSequence(...)");
        CharSequence charSequence3 = charSequence2;
        int n4 = CharArrayUtil.shiftBackward((CharSequence)charSequence3, (int)(n3 - 1), (String)"\t ");
        if (n4 < 0 || charSequence3.charAt(n4) != '\n') {
            return false;
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(n3);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator highlighterIterator2 = highlighterIterator;
        if ((CSharpQuoteHandlerKt.getBASIC_TEXT_LITERALS().contains(highlighterIterator2.getTokenType()) || CSharpElementTypes.INSTANCE.getMULTILINE_COMMENTS().contains(highlighterIterator2.getTokenType()) && highlighterIterator2.getStart() != n3) && !Intrinsics.areEqual((Object)editor.getUserData(com.jetbrains.rider.rdclient.languages.assists.UtilsKt.getEXECUTE_ON_FRONTEND()), (Object)true)) {
            return true;
        }
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null || !UtilsKt.isCSharpFile(psiFile)) {
            return false;
        }
        int n5 = CharArrayUtil.shiftForward((CharSequence)charSequence3, (int)n3, (String)"\t ");
        boolean bl = n5 == charSequence3.length() || charSequence3.charAt(n5) == '\n';
        int n6 = document2.getLineNumber(n3);
        int n7 = n6 - 1;
        String string = new CSharpLineIndentProvider().getLineIndent(project, editor, CSharpLanguage.INSTANCE, caret.getOffset());
        if (string == null) {
            BackspaceHandler.LOG.error("currentLineExpectedIndent == null");
            return false;
        }
        CharSequence charSequence4 = charSequence3.subSequence(n4 + 1, n5);
        if (StringsKt.startsWith$default((CharSequence)charSequence4, (CharSequence)string, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)charSequence4, (Object)string)) {
            n2 = document2.getLineStartOffset(n6) + string.length();
            document2.deleteString(n2, n5);
            n5 = n2;
            if (n2 < n3) {
                return true;
            }
        } else if (!Intrinsics.areEqual((Object)charSequence4, (Object)string)) {
            String string2 = string.substring(charSequence4.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2;
            document2.insertString(n5, (CharSequence)string3);
            caret.moveToOffset(n3 + string3.length());
            n5 += string3.length();
        }
        n2 = document2.getLineStartOffset(n7);
        CharSequence charSequence5 = document2.getCharsSequence().subSequence(n2, document2.getLineEndOffset(n7));
        document2.deleteString(n4, n5);
        if (this.G(charSequence5)) {
            if (bl) {
                return true;
            }
            int n8 = CharArrayUtil.shiftBackward((CharSequence)charSequence3, (int)(caret.getOffset() - 1), (String)"\t ") + 1;
            if (n8 == caret.getOffset()) {
                document2.insertString(n8, (CharSequence)" ");
                caret.moveToOffset(caret.getOffset() + 1);
            } else {
                document2.deleteString(n8 + 1, caret.getOffset());
            }
            return true;
        }
        String string4 = new CSharpLineIndentProvider().getLineIndent(project, editor, CSharpLanguage.INSTANCE, caret.getOffset());
        CharSequence charSequence6 = charSequence = string4 != null ? (CharSequence)string4 : charSequence4;
        if (!Intrinsics.areEqual((Object)charSequence5, (Object)charSequence)) {
            if (StringsKt.startsWith$default((CharSequence)charSequence5, (CharSequence)charSequence, (boolean)false, (int)2, null)) {
                document2.deleteString(n2 + charSequence.length(), caret.getOffset());
            } else if (StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)charSequence5, (boolean)false, (int)2, null)) {
                CharSequence charSequence7 = charSequence;
                n = charSequence5.length();
                int n9 = charSequence7.length();
                String string5 = ((Object)charSequence7.subSequence(n, n9)).toString();
                document2.insertString(n2 + charSequence5.length(), (CharSequence)string5);
            } else {
                boolean bl2;
                Character c;
                block23: {
                    int n10 = CharArrayUtil.shiftForward((CharSequence)charSequence3, (int)n2, (String)"\t ");
                    document2.replaceString(n2, n10, charSequence);
                    CharSequence charSequence8 = charSequence5;
                    for (int j = 0; j < charSequence8.length(); ++j) {
                        char c2;
                        char c3 = c2 = charSequence8.charAt(j);
                        boolean bl3 = false;
                        if (!(!CharsKt.isWhitespace((char)c3))) continue;
                        c = Character.valueOf(c2);
                        break block23;
                    }
                    c = null;
                }
                boolean bl4 = bl2 = c != null;
                if (bl2) {
                    return true;
                }
            }
        }
        if (bl) {
            return true;
        }
        int n11 = CharArrayUtil.shiftBackward((CharSequence)charSequence3, (int)(caret.getOffset() - 1), (String)"\n\t ") + 1;
        int n12 = n11 >= 0 ? document2.getLineNumber(n11) : 0;
        for (n = document2.getLineNumber(caret.getOffset()) - 1; n > n12; --n) {
            document2.deleteString(document2.getLineStartOffset(n), document2.getLineEndOffset(n));
        }
        if (n < 0) {
            return true;
        }
        document2.deleteString(n11, document2.getLineEndOffset(n));
        return true;
    }

    private final boolean G(CharSequence charSequence) {
        boolean bl;
        block1: {
            CharSequence charSequence2 = charSequence;
            boolean bl2 = false;
            for (int j = 0; j < charSequence2.length(); ++j) {
                char c;
                char c2 = c = charSequence2.charAt(j);
                boolean bl3 = false;
                if (c2 == ' ' || c2 == '\t') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return !bl;
    }

    private static final CharSequence G(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

