/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services.uiContext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.ide.model.uicontext.UiContextModel;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.uiContext.UiContextListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010!\u001a\u00020$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010%\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0006\u0010+\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener;", "Lcom/jetbrains/rdclient/services/uiContext/UiContextListener;", "project", "Lcom/intellij/openapi/project/Project;", "uiContext", "Lcom/jetbrains/ide/model/uicontext/UiContextModel;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DefaultUiContextListener", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/uicontext/UiContextModel;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/diagnostic/Logger;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "selectionChanged", "", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "caretPositionChanged", "Lcom/intellij/openapi/editor/event/CaretEvent;", "increaseProperty", "property", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "lazyMessage", "Lkotlin/Function0;", "", "focusGained", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "beforeDocumentChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "G", "", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nUiContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n69#2,4:86\n*S KotlinDebug\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n*L\n57#1:86,4\n*E\n"})
public class DefaultUiContextListener
implements UiContextListener {
    @NotNull
    private final Project project;
    @NotNull
    private final UiContextModel uiContext;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    @NotNull
    private final Logger logger;

    public DefaultUiContextListener(@NotNull Project project, @NotNull UiContextModel uiContext, @NotNull FileDocumentManager fileDocumentManager, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)uiContext), (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.project = project;
        this.uiContext = uiContext;
        this.fileDocumentManager = fileDocumentManager;
        this.logger = logger;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)this);
        Topic topic2 = FileEditorManagerListener.Before.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic2, (Object)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Document document = e.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (this.G(document)) {
            return;
        }
        this.increaseProperty(this.uiContext.getSelection(), (Function0<String>)((Function0)DefaultUiContextListener::D));
    }

    public final void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Document document = e.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (this.G(document)) {
            return;
        }
        if (Intrinsics.areEqual((Object)e.getNewPosition(), (Object)e.getOldPosition())) {
            return;
        }
        this.increaseProperty(this.uiContext.getCaret(), (Function0<String>)((Function0)() -> DefaultUiContextListener.G(e)));
    }

    protected void increaseProperty(@NotNull IOptProperty<Integer> property, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        property.set((Object)(((Number)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)property))).intValue() + 1));
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            logger.trace((String)lazyMessage.invoke());
        }
    }

    public final void focusGained(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.increaseProperty(this.uiContext.getFocus(), (Function0<String>)((Function0)DefaultUiContextListener::a));
    }

    public final void focusLost(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.increaseProperty(this.uiContext.getFocus(), (Function0<String>)((Function0)DefaultUiContextListener::G));
    }

    public final void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.G(event.getOldFile()) && this.G(event.getNewFile())) {
            return;
        }
        this.increaseProperty(this.uiContext.getTextControl(), (Function0<String>)((Function0)DefaultUiContextListener::b));
    }

    public final void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (this.G(document)) {
            return;
        }
        this.increaseProperty(this.uiContext.getDocument(), (Function0<String>)((Function0)DefaultUiContextListener::r));
    }

    private final boolean G(Document document) {
        VirtualFile virtualFile = this.fileDocumentManager.getFile(document);
        return this.G(virtualFile);
    }

    private final boolean G(VirtualFile virtualFile) {
        return virtualFile == null || virtualFile instanceof LightVirtualFile;
    }

    public final void dispose() {
    }

    private static final String D() {
        return "selection's changed.";
    }

    private static final String G(CaretEvent caretEvent) {
        Editor editor = caretEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        return "caret position's changed into editor with id:" + (textControlId != null ? UtilKt.toDebugString(textControlId) : null) + ".";
    }

    private static final String a() {
        return "Focus's gained.";
    }

    private static final String G() {
        return "Focus's lost.";
    }

    private static final String b() {
        return "TextControls selection's changed.";
    }

    private static final String r() {
        return "Documents content's changed.";
    }
}

