/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services.popups;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.ide.model.popups.IRdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdEmptyPopupMenuModel;
import com.jetbrains.ide.model.popups.RdExpandSubmenuRequest;
import com.jetbrains.ide.model.popups.RdPopupMenuItemKind;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItem;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItems;
import com.jetbrains.ide.model.popups.RdPopupSubmenuModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.services.popups.FrontendIntentionAction;
import com.jetbrains.rdclient.services.popups.FrontendIntentionMenuContributor;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0012H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "G", "", "popupLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "popupModel", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModel;", "intentions", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "G", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "popupMenuModelItem", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModelItem;", "G", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "isCurrent", "", "Lcom/jetbrains/ide/model/popups/IRdPopupMenuModel;", "currentThreadId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIntentionMenuContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIntentionMenuContributor.kt\ncom/jetbrains/rdclient/services/popups/FrontendIntentionMenuContributorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n69#2,4:307\n69#2,4:316\n15#2:325\n1567#3:311\n1598#3,4:312\n1567#3:320\n1598#3,4:321\n*S KotlinDebug\n*F\n+ 1 FrontendIntentionMenuContributor.kt\ncom/jetbrains/rdclient/services/popups/FrontendIntentionMenuContributorKt\n*L\n241#1:307,4\n272#1:316,4\n50#1:325\n270#1:311\n270#1:312,4\n277#1:320\n277#1:321,4\n*E\n"})
public final class FrontendIntentionMenuContributorKt {
    @NotNull
    private static final Logger LOG;

    private static final void G(Lifetime lifetime, Project project, IdeBackend ideBackend, RdPopupMenuModel rdPopupMenuModel, ShowIntentionsPass.IntentionsInfo intentionsInfo) {
        int n;
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)((Object)rdPopupMenuModel.getItems().getValueOrNull());
        if (rdPopupMenuModelItems == null) {
            return;
        }
        RdPopupMenuModelItems rdPopupMenuModelItems2 = rdPopupMenuModelItems;
        Object object = LOG;
        int n2 = 0;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            n = 0;
            logger.trace("Got intentions (count=" + rdPopupMenuModelItems2.getValue().size() + ")");
        }
        object = ((Iterable)rdPopupMenuModelItems2.getValue()).iterator();
        n2 = 0;
        while (object.hasNext()) {
            n = n2++;
            RdPopupMenuModelItem rdPopupMenuModelItem = (RdPopupMenuModelItem)object.next();
            FrontendIntentionAction frontendIntentionAction = new FrontendIntentionAction(n, lifetime, rdPopupMenuModel, rdPopupMenuModelItem);
            List<IntentionAction> list2 = FrontendIntentionMenuContributorKt.G(lifetime, rdPopupMenuModel, rdPopupMenuModelItem);
            IconModel iconModel = rdPopupMenuModelItem.getIcon();
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = new HighlightInfo.IntentionActionDescriptor((IntentionAction)frontendIntentionAction, list2, null, iconModel != null ? UtilKt.fromModel(iconModel) : null, null, null, null, null);
            switch (WhenMappings.$EnumSwitchMapping$0[rdPopupMenuModelItem.getKind().ordinal()]) {
                case 1: {
                    boolean bl = intentionsInfo.errorFixesToShow.add(intentionActionDescriptor);
                    break;
                }
                case 2: {
                    boolean bl = intentionsInfo.inspectionFixesToShow.add(intentionActionDescriptor);
                    break;
                }
                case 3: {
                    boolean bl = intentionsInfo.guttersToShow.add(frontendIntentionAction.toAnAction(project));
                    break;
                }
                case 4: {
                    boolean bl = intentionsInfo.notificationActionsToShow.add(intentionActionDescriptor);
                    break;
                }
                default: {
                    boolean bl = intentionsInfo.intentionsToShow.add(intentionActionDescriptor);
                }
            }
        }
    }

    private static final List<IntentionAction> G(Lifetime lifetime, RdPopupMenuModel rdPopupMenuModel, RdPopupMenuModelItem rdPopupMenuModelItem) {
        Object object;
        if (!rdPopupMenuModelItem.getCanExpand()) {
            return CollectionsKt.emptyList();
        }
        List<RdPopupMenuModelItem> list2 = rdPopupMenuModelItem.getSubItems();
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            int n = 0;
            for (Object t : iterable2) {
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RdPopupMenuModelItem rdPopupMenuModelItem2 = (RdPopupMenuModelItem)t;
                int n3 = n2;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new FrontendIntentionAction(n3, lifetime, rdPopupMenuModel, rdPopupMenuModelItem2));
            }
            return (List)collection;
        }
        Object object2 = LOG;
        boolean bl = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            boolean bl4 = false;
            object.trace("Sending expand item request for item " + rdPopupMenuModelItem.getItemId() + " in " + FrontendIntentionMenuContributorKt.currentThreadId());
        }
        object2 = new RdExpandSubmenuRequest(rdPopupMenuModelItem.getItemId());
        rdPopupMenuModel.getExpandSubmenu().set(object2);
        Object object3 = ((RdExpandSubmenuRequest)((Object)object2)).getSubmenu().getValueOrNull();
        RdPopupSubmenuModel rdPopupSubmenuModel = object3 instanceof RdPopupSubmenuModel ? (RdPopupSubmenuModel)((Object)object3) : null;
        if (rdPopupSubmenuModel == null) {
            return CollectionsKt.emptyList();
        }
        RdPopupSubmenuModel rdPopupSubmenuModel2 = rdPopupSubmenuModel;
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)((Object)rdPopupSubmenuModel2.getItems().getValueOrNull());
        if (rdPopupMenuModelItems == null) {
            return CollectionsKt.emptyList();
        }
        RdPopupMenuModelItems rdPopupMenuModelItems2 = rdPopupMenuModelItems;
        object3 = rdPopupMenuModelItems2.getValue();
        boolean bl5 = false;
        Object object4 = object3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        boolean bl6 = false;
        int n = 0;
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            int n4;
            Object t = iterator2.next();
            if ((n4 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RdPopupMenuModelItem rdPopupMenuModelItem3 = (RdPopupMenuModelItem)t;
            int n5 = n4;
            object = collection;
            boolean bl7 = false;
            object.add(new FrontendIntentionAction(n5, lifetime, rdPopupMenuModel, rdPopupMenuModelItem3));
        }
        return (List)collection;
    }

    private static final ShortcutSet G(RdPopupMenuModelItem rdPopupMenuModelItem) {
        if (rdPopupMenuModelItem.getActionId() != null) {
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null) {
                Shortcut[] shortcutArray = keymapManager.getActiveKeymap().getShortcuts(rdPopupMenuModelItem.getActionId());
                return (ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutArray, shortcutArray.length));
            }
            return null;
        }
        RichAttributedTextModel richAttributedTextModel = rdPopupMenuModelItem.getOptionalText();
        if (richAttributedTextModel == null) {
            return null;
        }
        String string = RichTextHtmlUtils.INSTANCE.highlightAttributedParts(richAttributedTextModel);
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        return (ShortcutSet)new CustomShortcutSet(keyStroke);
    }

    public static final boolean isCurrent(@NotNull IRdPopupMenuModel $this$isCurrent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isCurrent), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UiContextManager uiContextManager = UiContextManager.Companion.getInstance(project);
        IRdPopupMenuModel iRdPopupMenuModel = $this$isCurrent;
        return iRdPopupMenuModel instanceof RdEmptyPopupMenuModel ? uiContextManager.isActualValues(((RdEmptyPopupMenuModel)$this$isCurrent).getTimestamps()) : (iRdPopupMenuModel instanceof RdPopupMenuModel ? uiContextManager.isActualValues(((RdPopupMenuModel)$this$isCurrent).getTimestamps()) : false);
    }

    @NotNull
    public static final String currentThreadId() {
        return ApplicationManager.getApplication().isDispatchThread() ? "EDT" : String.valueOf(Thread.currentThread().getId());
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$bindPopupModel(Lifetime popupLifetime, Project project, IdeBackend backend, RdPopupMenuModel popupModel, ShowIntentionsPass.IntentionsInfo intentions) {
        FrontendIntentionMenuContributorKt.G(popupLifetime, project, backend, popupModel, intentions);
    }

    public static final /* synthetic */ ShortcutSet access$tryGetClientShortcut(RdPopupMenuModelItem $receiver) {
        return FrontendIntentionMenuContributorKt.G($receiver);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendIntentionMenuContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdPopupMenuItemKind.values().length];
            try {
                nArray[RdPopupMenuItemKind.ErrorFix.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.InspectionFix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.Gutter.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdPopupMenuItemKind.Notification.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

