/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.remoteDev.tracing.RequestTelemetryData;
import com.intellij.remoteDev.tracing.TelemetryDataUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdFailureResponse;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequestHolder;
import com.jetbrains.rd.ide.model.RdRequests;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.model.RdResponses;
import com.jetbrains.rd.ide.model.RdRetryResponse;
import com.jetbrains.rd.ide.model.RdSuccessResponse;
import com.jetbrains.rd.ide.model.RdTelemetryData;
import com.jetbrains.rd.ide.model.RdTelemetryDataHolder;
import com.jetbrains.rd.ide.model.RequestResponseModel;
import com.jetbrains.rd.ide.model.RequestResponseModel_GeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.AppExtListener;
import com.jetbrains.rd.tracing.OpenTelemetryKt;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.diagnostics.CaretMovementTracker;
import com.jetbrains.rdclient.diagnostics.ConflictTracker;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandlerKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorBehaviour;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestListener;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import com.jetbrains.rdclient.requests.RequestStatus;
import com.jetbrains.rdclient.requests.recovering.RecoveringStrategyProvider;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelicateCoroutinesApi;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 {2\u00020\u0001:\u0004{|}~B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J,\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u00160(H\u0007J7\u0010/\u001a\u00020+2'\u00100\u001a#\b\u0001\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020+02\u0012\u0006\u0012\u0004\u0018\u0001030(\u00a2\u0006\u0002\b4H\u0087@\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u000208H\u0002J\b\u0010=\u001a\u00020\u0016H\u0007J\u0006\u0010>\u001a\u00020\u0016J\b\u0010?\u001a\u00020+H\u0007J\u000e\u0010E\u001a\u00020+H\u0086@\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010J\u0016\u0010K\u001a\u00020+2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0016\u0010M\u001a\u00020+2\u0006\u0010N\u001a\u00020OH\u0082@\u00a2\u0006\u0002\u0010PJ&\u0010Q\u001a\u00020+2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u00122\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000bH\u0002J\u0010\u0010W\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010H\u0002J\u0016\u0010X\u001a\u00020+2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0018\u0010Y\u001a\u00020+2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020SH\u0002J\u0016\u0010[\u001a\u00020+2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u0012H\u0002J\u0010\u0010\\\u001a\u00020+2\u0006\u0010]\u001a\u00020^H\u0002J0\u0010_\u001a\u00020`2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020a2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020\u0016H\u0002J,\u0010c\u001a\u00020d2\b\u0010e\u001a\u0004\u0018\u00010)2\b\u0010f\u001a\u0004\u0018\u00010)2\u0006\u0010H\u001a\u00020g2\u0006\u0010b\u001a\u00020\u0016H\u0002J(\u0010h\u001a\u00020+2\u0006\u0010Z\u001a\u00020i2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000bH\u0002J\u0018\u0010j\u001a\u00020+2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020kH\u0002J\b\u0010l\u001a\u00020+H\u0002J\u0016\u0010m\u001a\u00020+2\u0006\u0010n\u001a\u00020)H\u0082@\u00a2\u0006\u0002\u0010oJ\u001c\u0010p\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+0qH\u0082@\u00a2\u0006\u0002\u0010rJ\u0010\u0010s\u001a\u00020+2\u0006\u0010n\u001a\u00020)H\u0002J\u0018\u0010t\u001a\u00020`2\u0006\u0010n\u001a\u00020)2\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010u\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00102\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010v\u001a\u00020`2\u0006\u0010T\u001a\u00020UH\u0002J\"\u0010w\u001a\u00020+2\u0006\u0010n\u001a\u00020)2\u0006\u0010T\u001a\u00020U2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u0010J\u0016\u0010x\u001a\u00020+2\u0006\u0010y\u001a\u00020^H\u0082@\u00a2\u0006\u0002\u0010zR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u00160(8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010@\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0019R\u001a\u0010B\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0019\"\u0004\bD\u0010\u001b\u00a8\u0006\u007f"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "FrontendAsyncRequestExecutor", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "_lastQueuedRequest", "Ljava/util/concurrent/atomic/AtomicLong;", "lastQueuedRequest", "", "getLastQueuedRequest", "()J", "requestsQueue", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "requestQueueItems", "", "executionMutex", "Lkotlinx/coroutines/sync/Mutex;", "nestedExecutionGuard", "", "recoveringInProgress", "getRecoveringInProgress$intellij_rd_client", "()Z", "setRecoveringInProgress$intellij_rd_client", "(Z)V", "triggerRecoveryEditorStates", "getTriggerRecoveryEditorStates$intellij_rd_client", "setTriggerRecoveryEditorStates$intellij_rd_client", "patchHandlerRegistry", "Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "rebaseListener", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "getRebaseListener", "()Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "setRebaseListener", "(Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;)V", "forceRebase", "Lkotlin/Function2;", "Lcom/jetbrains/rd/ide/model/RdPatch;", "withForceRebase", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "check", "synchronizeWithPatchEngine", "action", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "model", "Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "isInitialized", "protocolModel", "G", "()Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "isRequestQueueEmpty", "thereArePendingRequests", "ensureRequestQueueEmpty", "executionInProgress", "G", "speculativeExecutionEnabled", "getSpeculativeExecutionEnabled", "setSpeculativeExecutionEnabled", "awaitSpeculativeRequests", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRequest", "request", "(Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitRequest", "r", "requests", "G", "respList", "Lcom/jetbrains/rd/ide/model/RdResponses;", "(Lcom/jetbrains/rd/ide/model/RdResponses;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "responses", "Lcom/jetbrains/rd/ide/model/RdResponse;", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "delta", "G", "b", "G", "response", "G", "G", "throwable", "", "G", "", "Lcom/jetbrains/rd/ide/model/RdSuccessResponse;", "isBatchMode", "G", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "speculatedPatch", "backendPatch", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "G", "Lcom/jetbrains/rd/ide/model/RdFailureResponse;", "G", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "G", "G", "patch", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "G", "G", "G", "applyBackendPatch", "G", "reason", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "MyModelListener", "RetryCustomizer", "RebaseListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TelemetryDataUtil.kt\ncom/intellij/remoteDev/tracing/TelemetryDataUtilKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 8 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion\n*L\n1#1,732:1\n116#2,10:733\n69#3,4:743\n69#3,4:747\n69#3,4:751\n69#3,4:755\n69#3,4:759\n69#3,4:763\n69#3,4:768\n69#3,4:772\n69#3,4:776\n69#3,4:780\n69#3,4:784\n69#3,4:788\n69#3,4:802\n69#3,4:806\n69#3,4:820\n69#3,4:842\n69#3,4:848\n69#3,4:852\n69#3,4:862\n69#3,4:871\n69#3,4:875\n69#3,4:885\n69#3,4:894\n69#3,4:898\n69#3,4:902\n69#3,4:906\n69#3,4:910\n69#3,4:914\n69#3,4:918\n69#3,4:922\n69#3,4:926\n69#3,4:932\n1#4:767\n31#5,7:792\n15#5,2:799\n38#5:801\n19#5,4:824\n31#5,7:828\n15#5,2:835\n38#5:837\n19#5,4:838\n756#6,10:810\n1863#6,2:930\n31#7,2:846\n33#8,6:856\n41#8,5:866\n33#8,6:879\n41#8,5:889\n33#8,13:936\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor\n*L\n124#1:733,10\n149#1:743,4\n196#1:747,4\n202#1:751,4\n204#1:755,4\n207#1:759,4\n231#1:763,4\n265#1:768,4\n304#1:772,4\n314#1:776,4\n317#1:780,4\n355#1:784,4\n360#1:788,4\n401#1:802,4\n407#1:806,4\n423#1:820,4\n480#1:842,4\n489#1:848,4\n493#1:852,4\n506#1:862,4\n579#1:871,4\n583#1:875,4\n593#1:885,4\n605#1:894,4\n612#1:898,4\n616#1:902,4\n620#1:906,4\n624#1:910,4\n630#1:914,4\n640#1:918,4\n644#1:922,4\n693#1:926,4\n279#1:932,4\n396#1:792,7\n396#1:799,2\n396#1:801\n396#1:824,4\n466#1:828,7\n466#1:835,2\n466#1:837\n466#1:838,4\n408#1:810,10\n704#1:930,2\n485#1:846,2\n500#1:856,6\n500#1:866,5\n586#1:879,6\n586#1:889,5\n296#1:936,13\n*E\n"})
public final class FrontendAsyncRequestExecutor
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final AtomicLong _lastQueuedRequest;
    @NotNull
    private final ArrayDeque<FrontendAsyncRequest> requestsQueue;
    @NotNull
    private final Mutex executionMutex;
    private volatile boolean nestedExecutionGuard;
    private boolean recoveringInProgress;
    private boolean triggerRecoveryEditorStates;
    @NotNull
    private final FrontendRdPatchHandlerRegistry patchHandlerRegistry;
    @TestOnly
    @Nullable
    private RebaseListener rebaseListener;
    @TestOnly
    @NotNull
    private Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> forceRebase;
    private boolean isInitialized;
    private boolean speculativeExecutionEnabled;

    public FrontendAsyncRequestExecutor(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this._lastQueuedRequest = new AtomicLong(-1L);
        this.requestsQueue = new ArrayDeque();
        this.executionMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.patchHandlerRegistry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        this.forceRebase = FrontendAsyncRequestExecutor::G;
        this.speculativeExecutionEnabled = true;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    public final long getLastQueuedRequest() {
        return this._lastQueuedRequest.get();
    }

    @RequiresEdt
    @NotNull
    public final List<FrontendAsyncRequest> requestQueueItems() {
        return CollectionsKt.toList((Iterable)this.requestsQueue);
    }

    public final boolean getRecoveringInProgress$intellij_rd_client() {
        return this.recoveringInProgress;
    }

    public final void setRecoveringInProgress$intellij_rd_client(boolean bl) {
        this.recoveringInProgress = bl;
    }

    public final boolean getTriggerRecoveryEditorStates$intellij_rd_client() {
        return this.triggerRecoveryEditorStates;
    }

    public final void setTriggerRecoveryEditorStates$intellij_rd_client(boolean bl) {
        this.triggerRecoveryEditorStates = bl;
    }

    @Nullable
    public final RebaseListener getRebaseListener() {
        return this.rebaseListener;
    }

    public final void setRebaseListener(@Nullable RebaseListener rebaseListener) {
        this.rebaseListener = rebaseListener;
    }

    @TestOnly
    public final void withForceRebase(@NotNull Lifetime lifetime, @NotNull Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> check) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> function2 = this.forceRebase;
        lifetime.bracketOrThrow(() -> FrontendAsyncRequestExecutor.G(this, check), () -> FrontendAsyncRequestExecutor.G(this, check, function2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @DelicateCoroutinesApi
    @Nullable
    public final Object synchronizeWithPatchEngine(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof synchronizeWithPatchEngine.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var9_3 = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.synchronizeWithPatchEngine(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        var8_4 = var9_3.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var9_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var8_4);
                var3_6 = this.executionMutex;
                var4_7 = null;
                var5_8 = false;
                var9_3.L$0 = action;
                var9_3.L$1 = var3_6;
                var9_3.label = 1;
                v0 = var3_6.lock(var4_7, (Continuation)var9_3);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                var5_9 = false;
                var4_7 = null;
                var3_6 = (Mutex)var9_3.L$1;
                action = (Function2)var9_3.L$0;
                ResultKt.throwOnFailure((Object)var8_4);
                v0 = var8_4;
lbl31:
                // 3 sources

                var6_11 = false;
                var9_3.L$0 = var3_6;
                var9_3.L$1 = null;
                var9_3.label = 2;
                v1 = CoroutineScopeKt.coroutineScope((Function2)action, (Continuation)var9_3);
                ** if (v1 != var10_5) goto lbl39
lbl38:
                // 1 sources

                return var10_5;
lbl39:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                var5_10 = false;
                var6_12 = false;
                var4_7 = null;
                var3_6 = (Mutex)var9_3.L$0;
                try {
                    ResultKt.throwOnFailure((Object)var8_4);
                    v1 = var8_4;
lbl49:
                    // 2 sources

                    var7_14 = Unit.INSTANCE;
                }
                catch (Throwable var6_13) {
                    throw var6_13;
                }
                finally {
                    var3_6.unlock(var4_7);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void G(Lifetime lifetime, RequestResponseModel requestResponseModel2) {
        Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("[service] FrontendAsyncRequestExecutor$init called");
        }
        FrontendDocumentHost.Companion.getInstance(this.session).ensureProtocolSubscriptionsReady();
        CoroutineHelpersKt.adviseSuspendPreserveClientId$default((ISource)((ISource)requestResponseModel2.getResponsesWithTime()), (Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<RdResponses, Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(RdResponses p0, Continuation<? super Unit> $completion) {
                return FrontendAsyncRequestExecutor.access$requestsCompleted((FrontendAsyncRequestExecutor)this.receiver, p0, $completion);
            }
        }), (int)6, null);
        CoroutineHelpersKt.adviseSuspendPreserveClientId$default((ISource)((ISource)requestResponseModel2.getBackendPatches()), (Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<RdPatch, Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(RdPatch p0, Continuation<? super Unit> $completion) {
                return FrontendAsyncRequestExecutor.access$backendChanged((FrontendAsyncRequestExecutor)this.receiver, p0, $completion);
            }
        }), (int)6, null);
        requestResponseModel2.getBackendBound().advise(lifetime, arg_0 -> FrontendAsyncRequestExecutor.G(this, arg_0));
    }

    private final RequestResponseModel G() {
        return RequestResponseModel_GeneratedKt.getRequestResponseModel(DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel(FrontendSessionsUtilKt.getProtocol(this.session)));
    }

    @TestOnly
    public final boolean isRequestQueueEmpty() {
        return this.requestsQueue.isEmpty();
    }

    public final boolean thereArePendingRequests() {
        int n = this.requestsQueue.size();
        FrontendAsyncRequest frontendAsyncRequest = this.requestsQueue.peek();
        return n > 1 || frontendAsyncRequest != null && !frontendAsyncRequest.getStatus().isExecuting();
    }

    @TestOnly
    public final void ensureRequestQueueEmpty() {
        boolean bl = this.isRequestQueueEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Pending Requests in the queue: " + this.requestsQueue.size() + ".\n" + CollectionsKt.joinToString$default((Iterable)this.requestsQueue, (CharSequence)"\n", null, null, (int)0, null, FrontendAsyncRequestExecutor::b, (int)30, null);
            throw new AssertionError((Object)string);
        }
    }

    private final boolean G() {
        FrontendAsyncRequest frontendAsyncRequest = this.requestsQueue.peek();
        if (frontendAsyncRequest == null) {
            return false;
        }
        FrontendAsyncRequest frontendAsyncRequest2 = frontendAsyncRequest;
        return frontendAsyncRequest2.getStatus().isExecuting();
    }

    public final boolean getSpeculativeExecutionEnabled() {
        return this.speculativeExecutionEnabled;
    }

    public final void setSpeculativeExecutionEnabled(boolean bl) {
        this.speculativeExecutionEnabled = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitSpeculativeRequests(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitSpeculativeRequests.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var11_2 = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitSpeculativeRequests((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        var10_3 = var11_2.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var11_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var10_3);
                var2_5 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                var3_6 = false;
                if (var2_5.isTraceEnabled()) {
                    var9_8 = var2_5;
                    var4_9 = false;
                    var9_8.trace("Start awaiting completion of speculative requests...");
                }
                var2_5 = CollectionsKt.toList((Iterable)this.requestsQueue);
                var3_7 = var2_5.iterator();
lbl21:
                // 6 sources

                while (var3_7.hasNext()) {
                    var4_10 = (FrontendAsyncRequest)var3_7.next();
                    if (!(var4_10 instanceof FrontendAsyncRequestWithImmediateResult) || ((FrontendAsyncRequestWithImmediateResult)var4_10).getPatch() == null || !((FrontendAsyncRequestWithImmediateResult)var4_10).getStatus().isExecuting() && !((FrontendAsyncRequestWithImmediateResult)var4_10).getStatus().isPending()) continue;
                    var5_11 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    var6_13 = false;
                    if (var5_11.isTraceEnabled()) {
                        var9_8 = var5_11;
                        var7_15 = false;
                        var9_8.trace("Awaiting " + var4_10 + "...");
                    }
                    var11_2.L$0 = var3_7;
                    var11_2.L$1 = var4_10;
                    var11_2.label = 1;
                    v0 = ((FrontendAsyncRequestWithImmediateResult)var4_10).await((Continuation<? super Unit>)var11_2);
                    ** if (v0 != var12_4) goto lbl39
lbl38:
                    // 1 sources

                    return var12_4;
lbl39:
                    // 1 sources

                    ** GOTO lbl48
                }
                break;
            }
            case 1: {
                var4_10 = (FrontendAsyncRequest)var11_2.L$1;
                var3_7 = (Iterator<E>)var11_2.L$0;
                try {
                    ResultKt.throwOnFailure((Object)var10_3);
                    v0 = var10_3;
lbl48:
                    // 2 sources

                    var5_11 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    var6_13 = false;
                    if (!var5_11.isTraceEnabled()) ** GOTO lbl21
                    var9_8 = var5_11;
                    var7_15 = false;
                    var9_8.trace("Request awaiting completed for " + var4_10);
                }
                catch (CancellationException var5_12) {
                    var6_14 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    var7_15 = false;
                    if (!var6_14.isTraceEnabled()) ** GOTO lbl21
                    var9_8 = var6_14;
                    var8_16 = false;
                    var9_8.trace("Request " + var4_10 + " was cancelled");
                }
                ** GOTO lbl21
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object executeRequest(@NotNull FrontendAsyncRequest request, @NotNull Continuation<? super Unit> $completion) {
        this.submitRequest(request);
        Object object = request.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void submitRequest(@NotNull FrontendAsyncRequest request) {
        FrontendAsyncRequest frontendAsyncRequest;
        FrontendAsyncRequest frontendAsyncRequest2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FrontendPatchEngineKt.getEngine(this.session).softAssertThereIsNoActivePatch(request + " was triggered during another patch recording");
        Object object2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            boolean bl2 = false;
            object.trace("Triggered " + request);
        }
        request.assertClientId();
        ThreadingAssertions.assertEventDispatchThread();
        if (!(!this.nestedExecutionGuard)) {
            bl = false;
            String string = request + " was triggered during another response";
            throw new IllegalArgumentException(string.toString());
        }
        object2 = null;
        object2 = request;
        ((FrontendAsyncRequest)object2).setSubmissionTime$intellij_rd_client(System.nanoTime());
        while ((frontendAsyncRequest2 = this.requestsQueue.peekLast()) != null && !Intrinsics.areEqual((Object)frontendAsyncRequest2, (Object)object2) && Intrinsics.areEqual((Object)frontendAsyncRequest2.getStatus(), (Object)RequestStatus.Companion.getPENDING()) && (frontendAsyncRequest = frontendAsyncRequest2.tryMergeWith((FrontendAsyncRequest)object2)) != null) {
            this.requestsQueue.removeLast();
            object2 = frontendAsyncRequest;
            ((FrontendAsyncRequest)object2).setSubmissionTime$intellij_rd_client(frontendAsyncRequest2.getSubmissionTime());
            frontendAsyncRequest.alsoComplete$intellij_rd_client(frontendAsyncRequest2);
            frontendAsyncRequest.alsoComplete$intellij_rd_client((FrontendAsyncRequest)object2);
        }
        ((FrontendAsyncRequest)object2).setId$intellij_rd_client(this._lastQueuedRequest.incrementAndGet());
        this.requestsQueue.addLast((FrontendAsyncRequest)object2);
        this.G((FrontendAsyncRequest)object2);
        if (!this.G() && this.isInitialized) {
            this.r((List)new SmartList(object2));
        } else {
            frontendAsyncRequest2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl3 = false;
            if (frontendAsyncRequest2.isTraceEnabled()) {
                object = frontendAsyncRequest2;
                boolean bl4 = false;
                object.trace("Queue " + object2 + " to execute");
            }
        }
    }

    private final void r(List<? extends FrontendAsyncRequest> list2) {
        if (!(!this.G())) {
            boolean bl = false;
            String string = "Can't execute next request before previous one is finished, previous: " + this.requestsQueue.peek();
            throw new IllegalArgumentException(string.toString());
        }
        if (list2.isEmpty()) {
            return;
        }
        ClientId clientId = ((FrontendAsyncRequest)CollectionsKt.first(list2)).getClientId();
        SmartList smartList = new SmartList();
        boolean bl = list2.size() > 1;
        ClientId.Companion.withExplicitClientId(clientId, () -> FrontendAsyncRequestExecutor.G(list2, smartList, this, bl));
    }

    private final Object G(RdResponses rdResponses, Continuation<? super Unit> continuation) {
        Object object = this.G((Function0<Unit>)((Function0)() -> FrontendAsyncRequestExecutor.G(this, rdResponses)), continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void G(List<? extends RdResponse> list2, FrontendRebaseSession frontendRebaseSession, long l) {
        boolean l3;
        Object object;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.recoveringInProgress) {
            Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("Skipping backend responses during recovering, request ids: [" + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, FrontendAsyncRequestExecutor::G, (int)31, null) + "]");
            }
            return;
        }
        boolean bl4 = list2.size() > 1;
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> iterator3 = iterator2;
        long l2 = System.nanoTime();
        int n = 0;
        int n2 = 0;
        Object object2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl5 = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            l3 = false;
            object.trace("Responses to process[" + list2.size() + "]: " + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, FrontendAsyncRequestExecutor::b, (int)30, null));
        }
        for (RdResponse rdResponse : list2) {
            boolean string;
            long l4 = rdResponse.getRequestId();
            Object object3 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl = false;
            if (object3.isTraceEnabled()) {
                object = object3;
                string = false;
                object.trace(">> response#" + l4);
            }
            if (!iterator3.hasNext()) {
                throw new IllegalStateException("executing request is null".toString());
            }
            object3 = iterator3.next();
            if (!(((FrontendAsyncRequest)object3).getId() == l4)) {
                string = false;
                String string2 = "Response is not corresponded to request: " + Reflection.getOrCreateKotlinClass(object3.getClass()).getSimpleName() + ", expected id: " + ((FrontendAsyncRequest)object3).getId() + ", actual id: " + l4;
                throw new IllegalArgumentException(string2.toString());
            }
            ClientIdKt.assertClientIdConsistency$default((ClientId)((FrontendAsyncRequest)object3).getClientId(), (String)"doRequestsCompleted::request.clientId", (boolean)false, (int)2, null);
            if (n > 0 && Intrinsics.areEqual((Object)((FrontendAsyncRequest)object3).getStatus(), (Object)RequestStatus.Companion.getREVERTED_EXECUTING())) {
                Intrinsics.checkNotNull((Object)object3);
                if (this.G((FrontendAsyncRequest)object3, frontendRebaseSession)) {
                    ++n2;
                    frontendRebaseSession.trackRestoredChanges(1);
                }
            }
            if (!(Intrinsics.areEqual((Object)((FrontendAsyncRequest)object3).getStatus(), (Object)RequestStatus.Companion.getEXECUTING()) || Intrinsics.areEqual((Object)((FrontendAsyncRequest)object3).getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING()))) {
                string = false;
                String string2 = "Unexpected request status on complete: " + ((FrontendAsyncRequest)object3).getStatus();
                throw new IllegalArgumentException(string2.toString());
            }
            Intrinsics.checkNotNull((Object)object3);
            this.G((FrontendAsyncRequest)object3, rdResponse);
            RdResponse bl7 = rdResponse;
            if (bl7 instanceof RdSuccessResponse) {
                n += this.G((FrontendAsyncRequest)object3, (RdSuccessResponse)rdResponse, frontendRebaseSession, l, bl4);
            } else if (bl7 instanceof RdRetryResponse) {
                if (bl4) {
                    throw new IllegalStateException(("Retrying is not allowed during batch processing; current request: " + (FrontendAsyncRequest)object3 + ". Requests in queue: " + CollectionsKt.joinToString$default((Iterable)this.requestsQueue, (CharSequence)", ", null, null, (int)0, null, FrontendAsyncRequestExecutor::G, (int)30, null)).toString());
                }
                this.G((FrontendAsyncRequest)object3, (RdRetryResponse)rdResponse);
            } else if (bl7 instanceof RdFailureResponse) {
                this.G((RdFailureResponse)rdResponse, (FrontendAsyncRequest)object3, frontendRebaseSession, l);
            } else {
                throw new IllegalStateException(("Unexpected response type: " + Reflection.getOrCreateKotlinClass(rdResponse.getClass()).getSimpleName()).toString());
            }
            if (bl4 && !((FrontendAsyncRequest)object3).getStatus().isCompleted()) {
                throw new IllegalStateException(("Retrying is not allowed during batch processing; request: " + (FrontendAsyncRequest)object3).toString());
            }
            bl7 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            string = false;
            if (!bl7.isTraceEnabled()) continue;
            object = bl7;
            boolean bl2 = false;
            object.trace("<< response#" + l4);
        }
        n2 += n > 0 ? this.G(frontendRebaseSession) : 0;
        object2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            l3 = false;
            object.trace("Responses number: " + list2.size() + ", processing time: " + (double)(System.nanoTime() - l2) / 1000000.0 + " ms, request queue size: " + this.requestsQueue.size() + ", undone requests: " + n + ", redone requests: " + n2 + ", cancelled requests: " + (n - n2));
        }
        this.G();
        this.G(list2);
    }

    private final void G(FrontendAsyncRequest frontendAsyncRequest) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestSubmitted(this.session, frontendAsyncRequest);
    }

    private final void b(List<? extends FrontendAsyncRequest> list2) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestsSent(this.session, list2);
    }

    private final void G(FrontendAsyncRequest frontendAsyncRequest, RdResponse rdResponse) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestCompleted(this.session, frontendAsyncRequest, rdResponse);
    }

    private final void G(List<? extends RdResponse> list2) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).responsesExecuted(this.session, list2);
    }

    private final void G(Throwable throwable) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).problemOccurred(this.session, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final int G(FrontendAsyncRequest var1_1, RdSuccessResponse var2_2, FrontendRebaseSession var3_3, long var4_4, boolean var6_5) {
        if (!Intrinsics.areEqual((Object)var1_1.getStatus(), (Object)RequestStatus.Companion.getEXECUTING())) {
            var8_6 = false;
            var8_7 = "Unexpected status: " + var1_1.getStatus();
            throw new IllegalArgumentException(var8_7.toString());
        }
        var7_9 = var2_2.getPatch();
        var8_8 = var1_1.createModel();
        var9_10 = null;
        var10_11 = new RdRequestHolder(var1_1.getId(), var8_8, var9_10);
        var11_12 = OpenTelemetryKt.getRemoteContext((RdTelemetryDataHolder)var10_11);
        var12_13 = "client: backend activity finished";
        var13_14 = SpanKind.CLIENT;
        var14_15 = false;
        var15_16 = TelemetryDataUtilKt.currentTimeWithAdjustment((long)var4_4);
        v0 = TelemetryDataUtilKt.rdctTracer().spanBuilder(var12_13).setSpanKind(var13_14).setParent(var11_12).setAttribute("start time", var15_16).setStartTimestamp(var15_16, TimeUnit.NANOSECONDS).startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"startSpan(...)");
        var17_17 = v0;
        var18_18 = false;
        try {
            block22: {
                block21: {
                    var19_19 = var17_17;
                    var20_21 = false;
                    var21_22 = var19_19;
                    var22_23 = false;
                    if (!(var1_1 instanceof FrontendAsyncRequestWithImmediateResult)) break block21;
                    var23_24 = ((FrontendAsyncRequestWithImmediateResult)var1_1).getPatch();
                    var24_25 /* !! */  = this.G(var23_24, var7_9, (FrontendAsyncRequestWithImmediateResult)var1_1, var6_5);
                    if (!RdPatchUtilsKt.isEqualOrEquivalent((SpeculativelyEqualsResult)var24_25 /* !! */ )) ** GOTO lbl-1000
                    var25_27 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    var26_31 = false;
                    if (var25_27.isTraceEnabled()) {
                        var27_33 = var25_27;
                        var28_34 = false;
                        var27_33.trace("Client and backend patches are " + var24_25 /* !! */ .name() + ". Skipping full rebase...");
                    }
                    if (var7_9 != null) {
                        if (var23_24 == null) {
                            var25_27 = "Required value was null.";
                            throw new IllegalArgumentException(var25_27.toString());
                        }
                        if (var24_25 /* !! */  == SpeculativelyEqualsResult.Equivalent) {
                            var25_27 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                            var26_31 = false;
                            if (var25_27.isTraceEnabled()) {
                                var27_33 = var25_27;
                                var28_34 = false;
                                var27_33.trace("Client and backend patches are Equivalent. Speculative:\n" + IPrintableKt.printToString((Object)var23_24) + "\nBackend:\n" + IPrintableKt.printToString((Object)var7_9) + "\n. Do virtual rebase");
                            }
                            var25_27 = this.requestsQueue;
                            var29_35 = var7_9;
                            var30_36 = (FrontendAsyncRequestWithImmediateResult)var1_1;
                            var27_33 = this.patchHandlerRegistry;
                            var26_31 = false;
                            var28_34 = false;
                            var31_37 = new ArrayList<T>();
                            var32_38 = var25_27.iterator();
                            while (var32_38.hasNext()) {
                                var33_39 = var32_38.next();
                                if (var28_34) {
                                    var31_37.add(var33_39);
                                    continue;
                                }
                                var34_40 = (FrontendAsyncRequest)var33_39;
                                var35_41 = false;
                                if (var34_40 != var1_1) continue;
                                var31_37.add(var33_39);
                                var28_34 = true;
                            }
                            var36_42 = var31_37;
                            var27_33.updatePendingRequestsVersions(var30_36, var29_35, var36_42);
                        }
                        var25_27 = new FrontendRdPatchHandlerContext(this.session, var7_9, var1_1, PatchItemOperationType.Perform.INSTANCE, var3_3);
                        FrontendRdPatchItemHandlerKt.withHandlerContext((FrontendRdPatchHandlerContext)var25_27, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, b(com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor com.jetbrains.rd.ide.model.RdPatch com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext ), ()Lkotlin/Unit;)((FrontendAsyncRequestExecutor)this, (RdPatch)var7_9, (FrontendRdPatchHandlerContext)var25_27));
                    }
                    var1_1.setStatus(RequestStatus.Companion.getCOMPLETED());
                    v1 = 0;
                    break block22;
                }
                if (var7_9 == null) {
                    var23_24 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    var24_26 = false;
                    if (var23_24.isTraceEnabled()) {
                        var27_33 = var23_24;
                        var25_28 = false;
                        var27_33.trace("Empty patch. Skipping rebase...");
                    }
                    var1_1.setStatus(RequestStatus.Companion.getCOMPLETED());
                    v1 = 0;
                } else lbl-1000:
                // 2 sources

                {
                    if (var7_9 == null) {
                        if (!(var1_1 instanceof FrontendAsyncRequestWithImmediateResult)) {
                            var25_29 = "Failed requirement.";
                            throw new IllegalArgumentException(var25_29.toString());
                        }
                        v2 = ((FrontendAsyncRequestWithImmediateResult)var1_1).getPatch();
                        v3 = v2;
                        Intrinsics.checkNotNull((Object)v2);
                    } else {
                        v3 = var7_9;
                    }
                    var23_24 = v3;
                    var24_25 /* !! */  = CaretRestoreHelper.Companion.getInstance();
                    var24_25 /* !! */ .setLastCaretBeforeRollbackLeansForward(null);
                    var25_30 = this.G(var23_24, var3_3);
                    var3_3.trackConflict(var1_1, var25_30);
                    var1_1.setStatus(RequestStatus.Companion.getCOMPLETED());
                    if (var7_9 != null) {
                        v4 = var1_1 instanceof FrontendEditorActionRequest != false ? (FrontendEditorActionRequest)var1_1 : null;
                        v5 = var26_32 = v4 != null && (v4 = v4.getEditorId()) != null ? FrontendTextControlHostKt.toEditorOrNull((TextControlId)v4) : null;
                        if (v5 != null) {
                            v5.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
                        }
                        this.applyBackendPatch(var7_9, var3_3, var1_1);
                        v6 = var26_32;
                        if (v6 != null) {
                            v6.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
                        }
                    }
                    var24_25 /* !! */ .setLastCaretBeforeRollbackLeansForward(null);
                    v1 = var25_30;
                }
            }
            var37_43 = v1;
        }
        finally {
            var38_44 = TelemetryDataUtilKt.currentTimeWithAdjustment((long)var4_4);
            var17_17.setAttribute("finish time", var38_44);
            var17_17.setAttribute("delta", var4_4);
            var17_17.end(var38_44, TimeUnit.NANOSECONDS);
        }
        return var37_43;
    }

    private final SpeculativelyEqualsResult G(RdPatch rdPatch, RdPatch rdPatch2, FrontendAsyncRequestWithImmediateResult frontendAsyncRequestWithImmediateResult, boolean bl) {
        if (((Boolean)this.forceRebase.invoke((Object)frontendAsyncRequestWithImmediateResult, (Object)rdPatch2)).booleanValue()) {
            return SpeculativelyEqualsResult.Different;
        }
        return RdPatchUtilsKt.speculativelyEquals(rdPatch, rdPatch2, !bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(RdFailureResponse rdFailureResponse, FrontendAsyncRequest frontendAsyncRequest, FrontendRebaseSession frontendRebaseSession, long l) {
        int n = 0;
        List<RdTelemetryData> list2 = null;
        Context context = OpenTelemetryKt.getRemoteContext((RdTelemetryDataHolder)new RdRequestHolder(frontendAsyncRequest.getId(), frontendAsyncRequest.createModel(), list2));
        String string = "client: backend activity failed";
        SpanKind spanKind = SpanKind.CLIENT;
        boolean bl = false;
        long l2 = TelemetryDataUtilKt.currentTimeWithAdjustment((long)l);
        Span span = TelemetryDataUtilKt.rdctTracer().spanBuilder(string).setSpanKind(spanKind).setParent(context).setAttribute("start time", l2).setStartTimestamp(l2, TimeUnit.NANOSECONDS).startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span span2 = span;
        boolean bl2 = false;
        try {
            Span span3 = span2;
            boolean bl3 = false;
            Span span4 = span3;
            boolean bl4 = false;
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Can't execute " + frontendAsyncRequest + ", reason: " + rdFailureResponse.getMessage());
            if (Intrinsics.areEqual((Object)frontendAsyncRequest.getStatus(), (Object)RequestStatus.Companion.getEXECUTING())) {
                frontendAsyncRequest.undo(frontendRebaseSession);
                ++n;
            }
            frontendAsyncRequest.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            long l3 = TelemetryDataUtilKt.currentTimeWithAdjustment((long)l);
            span2.setAttribute("finish time", l3);
            span2.setAttribute("delta", l);
            span2.end(l3, TimeUnit.NANOSECONDS);
        }
        frontendRebaseSession.trackConflict(frontendAsyncRequest, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(FrontendAsyncRequest frontendAsyncRequest, RdRetryResponse rdRetryResponse) {
        if (Intrinsics.areEqual((Object)frontendAsyncRequest.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING())) {
            Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Cannot re-try " + frontendAsyncRequest);
            }
            frontendAsyncRequest.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
            return;
        }
        ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
        boolean bl = false;
        Object object = RetryCustomizer.class;
        Object object2 = componentManager.getService(object);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, object);
        }
        boolean bl3 = ((RetryCustomizer)object2).retry(frontendAsyncRequest, rdRetryResponse);
        int n = frontendAsyncRequest.getRetryCounter();
        frontendAsyncRequest.setRetryCounter(n + 1);
        if (frontendAsyncRequest.getRetryCounter() <= 1 || bl3) {
            Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger3 = logger;
                boolean bl4 = false;
                logger3.trace("Re-trying " + frontendAsyncRequest + " at " + frontendAsyncRequest.getRetryCounter() + " time, reason: " + rdRetryResponse.getMessage());
            }
            frontendAsyncRequest.setStatus(RequestStatus.Companion.getPENDING());
        } else {
            Object object3 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            bl = false;
            if (object3.isTraceEnabled()) {
                Logger logger = object3;
                boolean bl5 = false;
                logger.trace("Retry trials exceeded max limit (1)");
            }
            if (!(frontendAsyncRequest instanceof FrontendAsyncRequestWithImmediateResult) || ((FrontendAsyncRequestWithImmediateResult)frontendAsyncRequest).getPatch() == null) {
                frontendAsyncRequest.undo(FrontendRebaseSession.Companion.createEmpty$default(FrontendRebaseSession.Companion, null, null, null, 7, null));
                frontendAsyncRequest.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                return;
            }
            object3 = FrontendRebaseSession.Companion;
            ClientAppSession clientAppSession = this.session;
            object = SyncEventsLogger.RebaseSessionType.RETRY;
            boolean bl6 = false;
            ConflictTracker conflictTracker = new ConflictTracker((SyncEventsLogger.RebaseSessionType)((Object)object));
            CaretMovementTracker caretMovementTracker = new CaretMovementTracker();
            FrontendRebaseSession frontendRebaseSession = ((FrontendRebaseSession.Companion)object3).createEmpty((SyncEventsLogger.RebaseSessionType)((Object)object), conflictTracker, caretMovementTracker);
            try {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener(frontendRebaseSession);
                FrontendRebaseSession frontendRebaseSession2 = frontendRebaseSession;
                boolean bl7 = false;
                RdPatch rdPatch = ((FrontendAsyncRequestWithImmediateResult)frontendAsyncRequest).getPatch();
                Intrinsics.checkNotNull((Object)rdPatch);
                int n2 = this.G(rdPatch, frontendRebaseSession2);
                frontendRebaseSession2.trackConflict(frontendAsyncRequest, n2);
                frontendAsyncRequest.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                int n3 = this.G(frontendRebaseSession2);
                Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                boolean bl8 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger4 = logger;
                    boolean bl9 = false;
                    logger4.trace("Cancelling request was done; request queue size: " + this.requestsQueue.size() + ", undone requests: " + n2 + ", redone requests: " + n3 + ", cancelled requests: " + (n2 - n3) + ".");
                }
            }
            finally {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener(frontendRebaseSession);
                caretMovementTracker.reportAllMovements(conflictTracker);
                conflictTracker.reportSummary();
            }
        }
    }

    private final void G() {
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> iterator3 = iterator2;
        SmartList smartList = new SmartList();
        FrontendAsyncRequest frontendAsyncRequest = null;
        while (iterator3.hasNext()) {
            boolean bl;
            FrontendAsyncRequest frontendAsyncRequest2 = iterator3.next();
            RequestStatus requestStatus = frontendAsyncRequest2.getStatus();
            if (requestStatus.isCompleted()) {
                iterator3.remove();
                continue;
            }
            boolean bl2 = bl = frontendAsyncRequest2.isBatchingAllowed() && FrontendAsyncRequestExecutorBehaviour.Companion.getInstance().supportBatching();
            if (!bl && !smartList.isEmpty() || frontendAsyncRequest != null && !Intrinsics.areEqual((Object)frontendAsyncRequest.getClientId(), (Object)frontendAsyncRequest2.getClientId())) break;
            smartList.add((Object)frontendAsyncRequest2);
            frontendAsyncRequest = frontendAsyncRequest2;
            if (bl && smartList.size() != 10) continue;
        }
        if (smartList.isEmpty()) {
            return;
        }
        this.r((List)smartList);
    }

    private final Object G(RdPatch rdPatch, Continuation<? super Unit> continuation) {
        Object object = this.G((Function0<Unit>)((Function0)() -> FrontendAsyncRequestExecutor.G(this, rdPatch)), continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object G(Function0<Unit> var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof runGuardedWithRecovery.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var5_3 = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrontendAsyncRequestExecutor.access$runGuardedWithRecovery(this.this$0, null, (Continuation)this);
                }
            };
        }
        var4_4 = var5_3.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var5_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var4_4);
                var5_3.L$0 = this;
                var5_3.label = 1;
                v0 = this.synchronizeWithPatchEngine((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, var1_1, null){
                    int label;
                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                    final /* synthetic */ Function0<Unit> $action;
                    {
                        this.this$0 = $receiver;
                        this.$action = $action;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (!(!FrontendAsyncRequestExecutor.access$getNestedExecutionGuard$p(this.this$0))) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                FrontendAsyncRequestExecutor.access$setNestedExecutionGuard$p(this.this$0, true);
                                try {
                                    this.$action.invoke();
                                }
                                finally {
                                    FrontendAsyncRequestExecutor.access$setNestedExecutionGuard$p(this.this$0, false);
                                }
                                if (this.this$0.getTriggerRecoveryEditorStates$intellij_rd_client()) {
                                    this.this$0.setTriggerRecoveryEditorStates$intellij_rd_client(false);
                                    String string = "Recovery Editor States is triggered manually";
                                    FrontendAsyncRequestExecutorKt.access$getLogger$p().warn(string);
                                    throw new Throwable(string);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)var5_3);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                this = (FrontendAsyncRequestExecutor)var5_3.L$0;
                try {
                    ResultKt.throwOnFailure((Object)var4_4);
                    v0 = var4_4;
                    ** GOTO lbl41
                }
                catch (Throwable var3_6) {
                    if (var3_6 instanceof ProcessCanceledException || var3_6 instanceof CancellationException) {
                        throw var3_6;
                    }
                    FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Error occurred when handling request", var3_6);
                    this.G(var3_6);
                    var5_3.L$0 = null;
                    var5_3.label = 2;
                    v1 = this.G(var3_6, (Continuation<? super Unit>)var5_3);
                    if (v1 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl41
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)var4_4);
                v1 = var4_4;
lbl41:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(RdPatch rdPatch) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.recoveringInProgress) {
            Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Skipping backend change during recovering, patch: " + IPrintableKt.printToString((Object)rdPatch));
            }
            return;
        }
        Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            boolean bl3 = false;
            logger3.trace(">> applying backend changes, patch: " + IPrintableKt.printToString((Object)rdPatch));
        }
        long l = System.nanoTime();
        FrontendRebaseSession.Companion companion = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession = this.session;
        SyncEventsLogger.RebaseSessionType rebaseSessionType = SyncEventsLogger.RebaseSessionType.BACKEND_CHANGE;
        boolean bl4 = false;
        ConflictTracker conflictTracker = new ConflictTracker(rebaseSessionType);
        CaretMovementTracker caretMovementTracker = new CaretMovementTracker();
        FrontendRebaseSession frontendRebaseSession = companion.createEmpty(rebaseSessionType, conflictTracker, caretMovementTracker);
        try {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener(frontendRebaseSession);
            FrontendRebaseSession frontendRebaseSession2 = frontendRebaseSession;
            boolean bl5 = false;
            int n = this.G(rdPatch, frontendRebaseSession2);
            frontendRebaseSession2.trackConflict(null, n);
            FrontendAsyncRequestExecutor.applyBackendPatch$default(this, rdPatch, frontendRebaseSession2, null, 4, null);
            int n2 = this.G(frontendRebaseSession2);
            Logger logger4 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl6 = false;
            if (logger4.isTraceEnabled()) {
                Logger logger5 = logger4;
                boolean bl7 = false;
                logger5.trace("<< applying backend changes; time: " + (double)(System.nanoTime() - l) / 1000000.0 + ", request queue size: " + this.requestsQueue.size() + ", undone requests: " + n + ", redone requests: " + n2 + ", cancelled requests: " + (n - n2) + ".");
            }
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener(frontendRebaseSession);
            caretMovementTracker.reportAllMovements(conflictTracker);
            conflictTracker.reportSummary();
        }
    }

    private final int G(RdPatch rdPatch, FrontendRebaseSession frontendRebaseSession) {
        Object object;
        boolean bl;
        Object object2;
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.descendingIterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boolean bl2;
            Logger logger;
            object2 = iterator2.next();
            if (Intrinsics.areEqual((Object)((FrontendAsyncRequest)object2).getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING()) || ((FrontendAsyncRequest)object2).getStatus().isReverted() || ((FrontendAsyncRequest)object2).getStatus().isCompleted()) {
                logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                bl = false;
                if (!logger.isTraceEnabled()) continue;
                object = logger;
                bl2 = false;
                object.trace("skip request with status=" + ((FrontendAsyncRequest)object2).getStatus() + " request.status.isReverted()=" + ((FrontendAsyncRequest)object2).getStatus().isReverted() + " request.status.isCompleted()=" + ((FrontendAsyncRequest)object2).getStatus().isCompleted() + " " + (FrontendAsyncRequest)object2);
                continue;
            }
            if (!(Intrinsics.areEqual((Object)((FrontendAsyncRequest)object2).getStatus(), (Object)RequestStatus.Companion.getPENDING()) || Intrinsics.areEqual((Object)((FrontendAsyncRequest)object2).getStatus(), (Object)RequestStatus.Companion.getEXECUTING()))) {
                bl = false;
                String string = "Unexpected status: " + ((FrontendAsyncRequest)object2).getStatus();
                throw new IllegalArgumentException(string.toString());
            }
            if (((FrontendAsyncRequest)object2).conflictWith(rdPatch)) {
                logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                bl = false;
                if (logger.isTraceEnabled()) {
                    object = logger;
                    bl2 = false;
                    object.trace("undoing " + (FrontendAsyncRequest)object2);
                }
                ((FrontendAsyncRequest)object2).setStatus(((FrontendAsyncRequest)object2).getStatus().revert());
                RebaseListener rebaseListener = this.rebaseListener;
                if (rebaseListener != null) {
                    Intrinsics.checkNotNull((Object)object2);
                    rebaseListener.undo((FrontendAsyncRequest)object2);
                }
                ((FrontendAsyncRequest)object2).undo(frontendRebaseSession);
                logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                bl = false;
                if (logger.isTraceEnabled()) {
                    object = logger;
                    bl2 = false;
                    object.trace((FrontendAsyncRequest)object2 + " was undone");
                }
                int n2 = n;
                n = n2 + 1;
                continue;
            }
            logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            bl = false;
            if (!logger.isTraceEnabled()) continue;
            object = logger;
            bl2 = false;
            object.trace("non-conflicting request: " + (FrontendAsyncRequest)object2);
        }
        object2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl3 = false;
        if (object2.isTraceEnabled()) {
            object = object2;
            bl = false;
            object.trace(n + " requests were undone. HasMore: " + iterator2.hasNext());
        }
        return n;
    }

    private final boolean G(FrontendAsyncRequest frontendAsyncRequest, FrontendRebaseSession frontendRebaseSession) {
        Logger logger;
        frontendAsyncRequest.setStatus(frontendAsyncRequest.getStatus().undoRevert());
        Logger logger2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            boolean bl2 = false;
            logger.trace("redoing " + frontendAsyncRequest);
        }
        RebaseListener rebaseListener = this.rebaseListener;
        if (rebaseListener != null) {
            rebaseListener.redo();
        }
        try {
            bl = frontendAsyncRequest.redo(frontendRebaseSession);
        }
        catch (Throwable throwable) {
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Redoing of request " + frontendAsyncRequest + " failed with exception", throwable);
            bl = false;
        }
        boolean bl3 = bl;
        if (!bl3) {
            Logger logger3 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl4 = false;
            if (logger3.isTraceEnabled()) {
                logger = logger3;
                boolean bl5 = false;
                logger.trace(frontendAsyncRequest + " was cancelled");
            }
            frontendAsyncRequest.setStatus(frontendAsyncRequest.getStatus().cancel());
            return false;
        }
        Logger logger4 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl6 = false;
        if (logger4.isTraceEnabled()) {
            logger = logger4;
            boolean bl7 = false;
            logger.trace(frontendAsyncRequest + " was redone");
        }
        return true;
    }

    private final int G(FrontendRebaseSession frontendRebaseSession) {
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> iterator3 = iterator2;
        int n = 0;
        while (iterator3.hasNext()) {
            FrontendAsyncRequest frontendAsyncRequest = iterator3.next();
            if (!frontendAsyncRequest.getStatus().isReverted()) continue;
            Intrinsics.checkNotNull((Object)frontendAsyncRequest);
            if (this.G(frontendAsyncRequest, frontendRebaseSession)) {
                ++n;
            }
            if (!Intrinsics.areEqual((Object)frontendAsyncRequest.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_PENDING())) continue;
            iterator3.remove();
        }
        frontendRebaseSession.trackRestoredChanges(n);
        return n;
    }

    public final void applyBackendPatch(@NotNull RdPatch patch, @NotNull FrontendRebaseSession rebaseSession, @Nullable FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        FrontendRdPatchHandlerContext frontendRdPatchHandlerContext = new FrontendRdPatchHandlerContext(this.session, patch, request, PatchItemOperationType.Perform.INSTANCE, rebaseSession);
        if (!this.patchHandlerRegistry.validate(patch.getExpectedItemVersions(), frontendRdPatchHandlerContext)) {
            throw new IllegalStateException("Not matched versions before applying patch".toString());
        }
        FrontendRdPatchItemHandlerKt.withHandlerContext(frontendRdPatchHandlerContext, () -> FrontendAsyncRequestExecutor.G(this, patch, frontendRdPatchHandlerContext));
        if (!this.patchHandlerRegistry.validate(patch.getUpdatedItemVersions(), frontendRdPatchHandlerContext)) {
            throw new IllegalStateException("Not matched versions after applying patch".toString());
        }
        this.patchHandlerRegistry.update(patch.getUpdatedItemVersions(), frontendRdPatchHandlerContext);
        FrontendRdPatchItemHandlerKt.withHandlerContext(frontendRdPatchHandlerContext, () -> FrontendAsyncRequestExecutor.r(this, patch, frontendRdPatchHandlerContext));
    }

    public static /* synthetic */ void applyBackendPatch$default(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch, FrontendRebaseSession frontendRebaseSession, FrontendAsyncRequest frontendAsyncRequest, int n, Object object) {
        if ((n & 4) != 0) {
            frontendAsyncRequest = null;
        }
        frontendAsyncRequestExecutor.applyBackendPatch(rdPatch, frontendRebaseSession, frontendAsyncRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object G(Throwable var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof recoverState.1)) ** GOTO lbl-1000
        var12_3 = var2_2;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var12_3 = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrontendAsyncRequestExecutor.access$recoverState(this.this$0, null, (Continuation)this);
                }
            };
        }
        var11_4 = var12_3.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var12_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var11_4);
                var3_6 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                var4_8 = false;
                if (var3_6.isTraceEnabled()) {
                    var10_9 = var3_6;
                    var5_10 = false;
                    var10_9.trace("recoverState called");
                }
                ThreadingAssertions.assertEventDispatchThread();
                this.recoveringInProgress = true;
                var12_3.L$0 = this;
                var12_3.L$1 = var1_1;
                var12_3.label = 1;
                v0 = YieldKt.yield((Continuation)var12_3);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl34
            }
            case 1: {
                var1_1 = (Throwable)var12_3.L$1;
                this = (FrontendAsyncRequestExecutor)var12_3.L$0;
                ResultKt.throwOnFailure((Object)var11_4);
                v0 = var11_4;
lbl34:
                // 3 sources

                FrontendAsyncRequestExecutorKt.access$getLogger$p().warn(">> Start recovering states after exception...");
                var3_6 = this.requestsQueue;
                var4_8 = false;
                var5_11 = var3_6.iterator();
                while (var5_11.hasNext()) {
                    var6_12 = var5_11.next();
                    var7_13 = (FrontendAsyncRequest)var6_12;
                    var8_14 = false;
                    var9_15 = new RdFailureResponse("Version mismatch", var7_13.getId(), null, 4, null);
                    if (!var7_13.getStatus().isCompleted()) {
                        Intrinsics.checkNotNull((Object)var7_13);
                        this.G(var7_13, var9_15);
                    }
                    var7_13.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                    this.G(CollectionsKt.listOf((Object)var9_15));
                }
                SyncEventsLogger.INSTANCE.logRecovery(this.requestsQueue.size(), var1_1.getClass());
                this.requestsQueue.clear();
                v1 = ModalTaskOwner.guess();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"guess(...)");
                var12_3.L$0 = this;
                var12_3.L$1 = null;
                var12_3.label = 2;
                v2 = TasksKt.withModalProgress((ModalTaskOwner)v1, (String)FrontendBundle.INSTANCE.message("actions.recovering.editors", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null).allowPumpProtocolUnderCurrentModality();
                                                this.label = 1;
                                                Object object3 = RecoveringStrategyProvider.Companion.getInstance().createRecoveringStrategy(this.this$0.getSession()).recover((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)var12_3);
                ** if (v2 != var13_5) goto lbl61
lbl60:
                // 1 sources

                return var13_5;
lbl61:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                this = (FrontendAsyncRequestExecutor)var12_3.L$0;
                try {
                    ResultKt.throwOnFailure((Object)var11_4);
                    v2 = var11_4;
lbl68:
                    // 2 sources

                    FrontendAsyncRequestExecutorKt.access$getLogger$p().warn("<< End recovering states");
                }
                catch (Throwable var3_7) {
                    throw var3_7;
                }
                finally {
                    this.recoveringInProgress = false;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean G(FrontendAsyncRequest frontendAsyncRequest, RdPatch rdPatch) {
        Intrinsics.checkNotNullParameter((Object)frontendAsyncRequest, (String)"request");
        return false;
    }

    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, Function2 function2) {
        frontendAsyncRequestExecutor.forceRebase = function2;
        return Unit.INSTANCE;
    }

    private static final boolean b(FrontendAsyncRequest frontendAsyncRequest, RdPatch rdPatch) {
        Intrinsics.checkNotNullParameter((Object)frontendAsyncRequest, (String)"request");
        return false;
    }

    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, Function2 function2, Function2 function22) {
        if (frontendAsyncRequestExecutor.forceRebase == function2) {
            frontendAsyncRequestExecutor.forceRebase = function22;
        } else {
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("forceRebase was changed. Incorrect scoping");
            frontendAsyncRequestExecutor.forceRebase = FrontendAsyncRequestExecutor::b;
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, boolean bl) {
        frontendAsyncRequestExecutor.isInitialized = true;
        frontendAsyncRequestExecutor.G();
        return Unit.INSTANCE;
    }

    private static final CharSequence b(FrontendAsyncRequest frontendAsyncRequest) {
        return IPrintableKt.printToString((Object)frontendAsyncRequest);
    }

    private static final Unit G(List list2, SmartList smartList, FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, boolean bl) {
        for (FrontendAsyncRequest frontendAsyncRequest : list2) {
            Logger logger = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("Start executing " + frontendAsyncRequest + " " + (String)(bl ? "[batch size: " + list2.size() + "]" : ""));
            }
            if (!Intrinsics.areEqual((Object)frontendAsyncRequest.getStatus(), (Object)RequestStatus.Companion.getPENDING())) {
                bl2 = false;
                String string = "Unexpected status: " + frontendAsyncRequest.getStatus();
                throw new IllegalArgumentException(string.toString());
            }
            frontendAsyncRequest.assertClientId();
            frontendAsyncRequest.setStatus(RequestStatus.Companion.getEXECUTING());
            logger = null;
            smartList.add((Object)new RdRequestHolder(frontendAsyncRequest.getId(), frontendAsyncRequest.createModel(), (List<RdTelemetryData>)logger));
        }
        frontendAsyncRequestExecutor.G().getRequestsWithTime().fire((Object)new RdRequests((List)smartList, TelemetryDataUtilKt.getCurrentTime()));
        frontendAsyncRequestExecutor.b(list2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdResponses rdResponses) {
        FrontendRebaseSession.Companion companion = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession = frontendAsyncRequestExecutor.session;
        SyncEventsLogger.RebaseSessionType rebaseSessionType = SyncEventsLogger.RebaseSessionType.RESPONSE_HANDLING;
        boolean bl = false;
        ConflictTracker conflictTracker = new ConflictTracker(rebaseSessionType);
        CaretMovementTracker caretMovementTracker = new CaretMovementTracker();
        FrontendRebaseSession frontendRebaseSession = companion.createEmpty(rebaseSessionType, conflictTracker, caretMovementTracker);
        try {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener(frontendRebaseSession);
            FrontendRebaseSession frontendRebaseSession2 = frontendRebaseSession;
            boolean bl2 = false;
            frontendAsyncRequestExecutor.G(rdResponses.getResponses(), frontendRebaseSession2, new RequestTelemetryData(rdResponses.getTimestamp()).getDelta());
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener(frontendRebaseSession);
            caretMovementTracker.reportAllMovements(conflictTracker);
            conflictTracker.reportSummary();
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence G(RdResponse rdResponse) {
        Intrinsics.checkNotNullParameter((Object)rdResponse, (String)"it");
        return String.valueOf(rdResponse.getRequestId());
    }

    private static final CharSequence b(RdResponse rdResponse) {
        Intrinsics.checkNotNullParameter((Object)rdResponse, (String)"it");
        return IPrintableKt.printToString((Object)rdResponse);
    }

    private static final CharSequence G(FrontendAsyncRequest frontendAsyncRequest) {
        return IPrintableKt.printToString((Object)frontendAsyncRequest);
    }

    private static final Unit b(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        frontendAsyncRequestExecutor.patchHandlerRegistry.apply(rdPatch.getFeatures(), frontendRdPatchHandlerContext);
        frontendAsyncRequestExecutor.patchHandlerRegistry.update(rdPatch.getUpdatedItemVersions(), frontendRdPatchHandlerContext);
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch) {
        frontendAsyncRequestExecutor.G(rdPatch);
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        frontendAsyncRequestExecutor.patchHandlerRegistry.apply(rdPatch.getChanges(), frontendRdPatchHandlerContext);
        return Unit.INSTANCE;
    }

    private static final Unit r(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        frontendAsyncRequestExecutor.patchHandlerRegistry.apply(rdPatch.getFeatures(), frontendRdPatchHandlerContext);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$requestsCompleted(FrontendAsyncRequestExecutor $this, RdResponses respList, Continuation $completion) {
        return $this.G(respList, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$backendChanged(FrontendAsyncRequestExecutor $this, RdPatch patch, Continuation $completion) {
        return $this.G(patch, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$runGuardedWithRecovery(FrontendAsyncRequestExecutor $this, Function0 action3, Continuation $completion) {
        return $this.G((Function0<Unit>)action3, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$getNestedExecutionGuard$p(FrontendAsyncRequestExecutor $this) {
        return $this.nestedExecutionGuard;
    }

    public static final /* synthetic */ void access$setNestedExecutionGuard$p(FrontendAsyncRequestExecutor $this, boolean bl) {
        $this.nestedExecutionGuard = bl;
    }

    public static final /* synthetic */ Object access$recoverState(FrontendAsyncRequestExecutor $this, Throwable reason, Continuation $completion) {
        return $this.G(reason, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion;", "", "FrontendAsyncRequestExecutor$Companion", "()V", "getInstance", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,732:1\n31#2,2:733\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion\n*L\n64#1:733,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendAsyncRequestExecutor getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendAsyncRequestExecutor> clazz = FrontendAsyncRequestExecutor.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendAsyncRequestExecutor)object;
        }

        @Deprecated(message="Use an overload with client app session")
        @ApiStatus.ScheduledForRemoval
        @ApiStatus.Internal
        @NotNull
        public final FrontendAsyncRequestExecutor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$MyModelListener;", "Lcom/jetbrains/rd/protocol/AppExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "FrontendAsyncRequestExecutor$MyModelListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parent", "model", "intellij.rd.client"})
    public static final class MyModelListener
    implements AppExtListener<DocumentsOperationModel, RequestResponseModel> {
        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel parent, @NotNull RequestResponseModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Companion.getInstance(session).G(lifetime, model);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "", "redo", "", "undo", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "intellij.rd.client"})
    @TestOnly
    public static interface RebaseListener {
        public void redo();

        public void undo(@NotNull FrontendAsyncRequest var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RetryCustomizer;", "", "FrontendAsyncRequestExecutor$RetryCustomizer", "()V", "retry", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "response", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "intellij.rd.client"})
    public static class RetryCustomizer {
        public boolean retry(@NotNull FrontendAsyncRequest request, @NotNull RdRetryResponse response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return false;
        }
    }
}

