/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.RdApplyPatchRequest;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "p", "Lcom/jetbrains/rd/ide/model/RdPatch;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "FrontendApplyPatchRequest", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "patchHandlerRegistry", "Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "b", "()Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "patchHandlerRegistry$delegate", "Lkotlin/Lazy;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "tryMergeWith", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "nextRequest", "G", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "old", "new", "debugDescription", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendApplyPatchRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n69#2,4:56\n69#2,4:60\n15#2:64\n*S KotlinDebug\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n*L\n40#1:56,4\n48#1:60,4\n18#1:64\n*E\n"})
public final class FrontendApplyPatchRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy patchHandlerRegistry$delegate;
    @NotNull
    private static final Logger logger;

    public FrontendApplyPatchRequest(@NotNull RdPatch p, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, p, resetUndoHistoryToken);
        this.patchHandlerRegistry$delegate = LazyKt.lazy(FrontendApplyPatchRequest::G);
    }

    private final FrontendRdPatchHandlerRegistry b() {
        Lazy lazy = this.patchHandlerRegistry$delegate;
        return (FrontendRdPatchHandlerRegistry)lazy.getValue();
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            throw new IllegalStateException("patch is null".toString());
        }
        return new RdApplyPatchRequest(rdPatch);
    }

    @Override
    @Nullable
    public FrontendAsyncRequest tryMergeWith(@NotNull FrontendAsyncRequest nextRequest) {
        Intrinsics.checkNotNullParameter((Object)nextRequest, (String)"nextRequest");
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            return null;
        }
        RdPatch rdPatch2 = rdPatch;
        Object object = nextRequest instanceof FrontendApplyPatchRequest ? (FrontendApplyPatchRequest)nextRequest : null;
        if (object == null || (object = ((FrontendAsyncRequestWithImmediateResult)object).getPatch()) == null) {
            return null;
        }
        Object object2 = object;
        Object object3 = CollectionsKt.singleOrNull(rdPatch2.getChanges());
        RdSelectionChangeBase rdSelectionChangeBase = object3 instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object3 : null;
        if (rdSelectionChangeBase == null) {
            return null;
        }
        RdSelectionChangeBase rdSelectionChangeBase2 = rdSelectionChangeBase;
        Object object4 = CollectionsKt.singleOrNull(((RdPatch)object2).getChanges());
        RdSelectionChangeBase rdSelectionChangeBase3 = object4 instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object4 : null;
        if (rdSelectionChangeBase3 == null) {
            return null;
        }
        RdSelectionChangeBase rdSelectionChangeBase4 = rdSelectionChangeBase3;
        RdSelectionChangeBase rdSelectionChangeBase5 = this.G(rdSelectionChangeBase2, rdSelectionChangeBase4);
        if (rdSelectionChangeBase5 == null) {
            return null;
        }
        object3 = rdSelectionChangeBase5;
        this.b().update(rdPatch2.getUpdatedItemVersions(), new FrontendRdPatchHandlerContext(this.getSession(), rdPatch2, nextRequest, PatchItemOperationType.Merge.INSTANCE, null, 16, null));
        return new FrontendApplyPatchRequest(RdPatch.copy$default(rdPatch2, CollectionsKt.listOf((Object)object3), null, null, null, null, 30, null), this.getSession(), this.getResetUndoHistoryToken());
    }

    private final RdSelectionChangeBase G(RdSelectionChangeBase rdSelectionChangeBase, RdSelectionChangeBase rdSelectionChangeBase2) {
        RdSelectionChangeBase rdSelectionChangeBase3;
        if (!Intrinsics.areEqual((Object)rdSelectionChangeBase.getEditorId(), (Object)rdSelectionChangeBase2.getEditorId())) {
            Logger logger = FrontendApplyPatchRequest.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Failed to merge caret changes with different editorId: " + rdSelectionChangeBase.getEditorId() + " and " + rdSelectionChangeBase2.getEditorId());
            }
            return null;
        }
        TextControlId textControlId = rdSelectionChangeBase.getEditorId();
        if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase3 = rdSelectionChangeBase2;
        } else if (rdSelectionChangeBase instanceof RdCaretStateChange && rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase3 = new RdCaretStateChange(((RdCaretStateChange)rdSelectionChangeBase).getOldState(), ((RdCaretStateChange)rdSelectionChangeBase2).getNewState(), textControlId);
        } else {
            Logger logger = FrontendApplyPatchRequest.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger3 = logger;
                boolean bl3 = false;
                logger3.trace("Failed to merge the following caret changes, old: " + rdSelectionChangeBase + ", new: " + rdSelectionChangeBase2);
            }
            rdSelectionChangeBase3 = null;
        }
        return rdSelectionChangeBase3;
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    private static final FrontendRdPatchHandlerRegistry G() {
        return FrontendRdPatchHandlerRegistry.Companion.getInstance();
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendApplyPatchRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendApplyPatchRequest.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest$Companion;", "", "FrontendApplyPatchRequest$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

