/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.SearchItemData;
import com.jetbrains.rd.ide.model.SearchPopup;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.gotoType.GotoHost;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItemRendererData;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J%\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J5\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase;", "Lcom/intellij/navigation/ChooseByNameContributor;", "key", "Lcom/jetbrains/rd/ide/model/GotoKey;", "ProtocolGotoContributorBase", "(Lcom/jetbrains/rd/ide/model/GotoKey;)V", "getKey", "()Lcom/jetbrains/rd/ide/model/GotoKey;", "getPopup", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "getNames", "", "", "includeNonProjectItems", "", "(Lcom/intellij/openapi/project/Project;Z)[Ljava/lang/String;", "getItemsByName", "Lcom/intellij/navigation/NavigationItem;", "name", "pattern", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Z)[Lcom/intellij/navigation/NavigationItem;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolGotoContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolGotoContributorBase.kt\ncom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n69#2,4:75\n15#2:88\n1#3:79\n1557#4:80\n1628#4,3:81\n37#5:84\n36#5,3:85\n*S KotlinDebug\n*F\n+ 1 ProtocolGotoContributorBase.kt\ncom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase\n*L\n35#1:75,4\n19#1:88\n67#1:80\n67#1:81,3\n71#1:84\n71#1:85,3\n*E\n"})
public abstract class ProtocolGotoContributorBase
implements ChooseByNameContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GotoKey key;
    @NotNull
    private static final Logger logger;

    public ProtocolGotoContributorBase(@NotNull GotoKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    public final GotoKey getKey() {
        return this.key;
    }

    @Nullable
    protected Disposable getPopup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        return concurrentHashMap != null && (concurrentHashMap = (JBPopup)concurrentHashMap.get(ClientId.Companion.getCurrent())) != null ? (Disposable)concurrentHashMap : (Disposable)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
    }

    @NotNull
    public String[] getNames(@NotNull Project project, boolean includeNonProjectItems) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GotoHost gotoHost = GotoHost.Companion.getInstance(project);
        String string = (String)project.getUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN);
        if (string == null) {
            return new String[0];
        }
        String string2 = string;
        Disposable disposable = this.getPopup(project);
        if (disposable == null) {
            return new String[0];
        }
        Disposable disposable2 = disposable;
        if (logger.isTraceEnabled()) {
            object = logger;
            boolean bl = false;
            if (object.isTraceEnabled()) {
                Object object2 = object;
                boolean bl2 = false;
                object2.trace("getting names for " + this.key + " contributor...");
            }
        }
        object = gotoHost.getSessionForPopup(disposable2, this.key);
        long l = System.currentTimeMillis();
        String[] stringArray = ((GotoPopupSession)object).getItemsSync(string2, includeNonProjectItems, null);
        long l2 = System.currentTimeMillis() - l;
        logger.debug("Done getting items from backend for " + this.key + ". Time = " + l2 + ". Items count = " + stringArray.length);
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(@NotNull String name, @NotNull String pattern, @NotNull Project project, boolean includeNonProjectItems) {
        Object object;
        GotoPopupSession gotoPopupSession;
        Object object2;
        Disposable disposable;
        Ref.ObjectRef objectRef;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GotoHost gotoHost = GotoHost.Companion.getInstance(project);
        Ref.ObjectRef objectRef2 = objectRef = new Ref.ObjectRef();
        Disposable disposable2 = this.getPopup(project);
        if (disposable2 != null) {
            disposable = disposable2;
            object2 = objectRef2;
            boolean bl = false;
            gotoPopupSession = gotoHost.getSessionForPopup(disposable, this.key);
            objectRef2 = object2;
        } else {
            gotoPopupSession = null;
        }
        objectRef2.element = gotoPopupSession;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = CollectionsKt.emptyList();
        if (objectRef.element == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                return new NavigationItem[0];
            }
            object = new LifetimeDefinition();
            objectRef.element = new GotoPopupSession(project, (Lifetime)object, this.key);
            disposable = new Ref.BooleanRef();
            ((GotoPopupSession)objectRef.element).getItemsAsync((Lifetime)object, name, includeNonProjectItems, (Function1<? super String[], Unit>)((Function1)arg_0 -> ProtocolGotoContributorBase.G(objectRef3, objectRef, name, (Ref.BooleanRef)disposable, arg_0)));
            ExtensionsKt.pumpMessages$default(null, () -> ProtocolGotoContributorBase.G((Ref.BooleanRef)disposable), 1, null);
            LifetimeDefinition.terminate$default((LifetimeDefinition)object, (boolean)false, (int)1, null);
        } else {
            objectRef3.element = ((GotoPopupSession)objectRef.element).getItemByShortName(name);
        }
        object = (Iterable)objectRef3.element;
        boolean bl = false;
        Object object3 = object;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = object3.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            GotoResult gotoResult = (GotoResult)t;
            object2 = collection;
            boolean bl3 = false;
            SearchItemData searchItemData = gotoResult.component1();
            SearchPopup searchPopup = gotoResult.component2();
            VirtualFile virtualFile = ProtocolNavigationItem.Companion.calculateVirtualFile(searchItemData, true, project);
            ProtocolNavigationItemRendererData protocolNavigationItemRendererData = ProtocolNavigationItemRendererData.Companion.calculateRenderData$default(ProtocolNavigationItemRendererData.Companion, virtualFile, true, project, null, 8, null);
            object2.add(new ProtocolNavigationItem(searchItemData, searchPopup, project, (GotoPopupSession)objectRef.element, virtualFile, protocolNavigationItemRendererData));
        }
        object = (List)collection;
        bl = false;
        object3 = object;
        return object3.toArray(new ProtocolNavigationItem[0]);
    }

    private static final Unit G(Ref.ObjectRef objectRef, Ref.ObjectRef objectRef2, String string, Ref.BooleanRef booleanRef, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"it");
        objectRef.element = ((GotoPopupSession)objectRef2.element).getItemByShortName(string);
        booleanRef.element = true;
        return Unit.INSTANCE;
    }

    private static final boolean G(Ref.BooleanRef booleanRef) {
        return booleanRef.element;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ProtocolGotoContributorBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolGotoContributorBase.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolGotoContributorBase$Companion;", "", "ProtocolGotoContributorBase$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

