/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.FilterHyperlinkModel;
import com.jetbrains.rd.ide.model.FilterKind;
import com.jetbrains.rd.ide.model.FilterNavigationContext;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.filters.FrontendFilterNavigationContext;
import com.jetbrains.rdclient.filters.FrontendHeavyFilterFrame;
import com.jetbrains.rdclient.filters.FrontendHyperlinkInfoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "kind", "Lcom/jetbrains/rd/ide/model/FilterKind;", "navigation", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/jetbrains/rd/ide/model/FilterNavigationContext;", "hyperlink", "Lcom/jetbrains/rd/ide/model/FilterHyperlinkModel;", "frame", "Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;", "FrontendHyperlinkInfo", "(Lcom/jetbrains/rd/ide/model/FilterKind;Lcom/jetbrains/rd/util/reactive/ISignal;Lcom/jetbrains/rd/ide/model/FilterHyperlinkModel;Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;)V", "getKind", "()Lcom/jetbrains/rd/ide/model/FilterKind;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "includeInOccurenceNavigation", "", "intellij.rd.client"})
public class FrontendHyperlinkInfo
implements HyperlinkInfo {
    @NotNull
    private final FilterKind kind;
    @NotNull
    private final ISignal<FilterNavigationContext> navigation;
    @NotNull
    private final FilterHyperlinkModel hyperlink;
    @NotNull
    private final FrontendHeavyFilterFrame frame;

    public FrontendHyperlinkInfo(@NotNull FilterKind kind, @NotNull ISignal<FilterNavigationContext> navigation, @NotNull FilterHyperlinkModel hyperlink, @NotNull FrontendHeavyFilterFrame frame) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(navigation, (String)"navigation");
        Intrinsics.checkNotNullParameter((Object)hyperlink, (String)"hyperlink");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.kind = kind;
        this.navigation = navigation;
        this.hyperlink = hyperlink;
        this.frame = frame;
    }

    @NotNull
    public final FilterKind getKind() {
        return this.kind;
    }

    public void navigate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FrontendFilterNavigationContext frontendFilterNavigationContext = this.frame.getNavigationContext(this.hyperlink.getStart(), this.hyperlink.getEnd());
        FilterHyperlinkModel filterHyperlinkModel = FrontendHyperlinkInfoKt.shiftRight(this.hyperlink, frontendFilterNavigationContext.getDelta());
        this.navigation.fire((Object)new FilterNavigationContext(frontendFilterNavigationContext.getText(), this.kind, filterHyperlinkModel));
    }

    public boolean includeInOccurenceNavigation() {
        return this.hyperlink.getIncludeInOccurenceNavigation();
    }
}

