/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.PsiAwareFileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.fileEditor.FileEntry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016Ja\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020!0 H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J$\u0010(\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0016H\u0094@\u00a2\u0006\u0002\u0010+R$\u0010\b\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "FrontendFileEditorManager", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "request", "Lcom/jetbrains/rd/util/Boxed;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "createCompositeAndModel", "file", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "fileEntry", "Lcom/intellij/platform/fileEditor/FileEntry;", "openFileFromBackend", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "requestFocus", "", "selectAsCurrent", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "isSingletonEditorInWindow", "isPinned", "initialize", "Lkotlin/Function1;", "", "openFileFromBackend$intellij_rd_client", "closeFile", "composite", "closeFile$intellij_rd_client", "G", "canOpenFile", "canOpenFileAsync", "providers", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n69#2,4:157\n69#2,4:165\n69#2,4:169\n69#2,4:174\n69#2,4:179\n69#2,4:187\n69#2,4:196\n69#2,4:201\n15#2:205\n55#3,4:161\n61#3:173\n55#3,4:183\n61#3:191\n55#3,4:192\n61#3:200\n1#4:178\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n*L\n45#1:157,4\n54#1:165,4\n57#1:169,4\n60#1:174,4\n84#1:179,4\n95#1:187,4\n110#1:196,4\n123#1:201,4\n33#1:205\n52#1:161,4\n52#1:173\n94#1:183,4\n94#1:191\n109#1:192,4\n109#1:200\n*E\n"})
public class FrontendFileEditorManager
extends PsiAwareFileEditorManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boxed<Pair<VirtualFile, EditorComposite>> request;
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EditorComposite createCompositeAndModel(@NotNull VirtualFile file, @NotNull EditorWindow window, @Nullable FileEntry fileEntry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Logger logger = LOG;
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            bl = false;
            logger2.trace("[file] createComposite called. file.name=" + file.getName() + ", isEdt=" + SwingUtilities.isEventDispatchThread());
        }
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.createCompositeAndModel(file, window, fileEntry);
        }
        if (this.request == null) {
            logger = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value2) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value2);
                }
            };
            Boxed boxed = new Boxed((Object)TuplesKt.to((Object)file, null));
            bl = false;
            Object object = logger.get();
            try {
                RdFileEditorCompositeId rdFileEditorCompositeId;
                boolean bl3;
                Logger logger3;
                logger.set((Object)boxed);
                boolean bl4 = false;
                LOG.warn("Synchronously waiting for editor for " + file);
                Object object2 = LOG;
                boolean bl5 = false;
                if (object2.isTraceEnabled()) {
                    logger3 = object2;
                    bl3 = false;
                    logger3.trace("[file] createComposite: Synchronously waiting for editor (start)");
                }
                if (FrontendFileEditorHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(this.getProject())).requestCompositeFromBackendSync(((IProtocolVirtualFile)file).getFileId(), this.getProject()) == null) {
                    FrontendFileEditorManager frontendFileEditorManager = this;
                    boolean bl6 = false;
                    Logger logger4 = LOG;
                    boolean bl7 = false;
                    if (logger4.isTraceEnabled()) {
                        Logger logger5 = logger4;
                        boolean bl8 = false;
                        logger5.trace("[file] createComposite: Synchronously waiting for editor (finish with failure)). compositeId=null");
                    }
                    EditorComposite editorComposite = null;
                    return editorComposite;
                }
                object2 = rdFileEditorCompositeId;
                Logger logger6 = LOG;
                bl3 = false;
                if (logger6.isTraceEnabled()) {
                    logger3 = logger6;
                    boolean bl9 = false;
                    logger3.trace("[file] createComposite: Synchronously waiting for editor (finish with success)). compositeId=" + (RdFileEditorCompositeId)object2);
                }
                Boxed<Pair<VirtualFile, EditorComposite>> boxed2 = this.request;
                Intrinsics.checkNotNull(boxed2);
                logger6 = (Pair)boxed2.getValue();
                VirtualFile virtualFile = (VirtualFile)logger6.component1();
                EditorComposite editorComposite = (EditorComposite)logger6.component2();
                boolean bl10 = Intrinsics.areEqual((Object)virtualFile, (Object)file);
                if (_Assertions.ENABLED && !bl10) {
                    boolean bl11 = false;
                    String string = "File mismatch after sync wait: expected: " + file + ", actual: " + virtualFile;
                    throw new AssertionError((Object)string);
                }
                EditorComposite editorComposite2 = editorComposite;
                return editorComposite2;
            }
            finally {
                logger.set(object);
            }
        }
        Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
        Intrinsics.checkNotNull(boxed);
        logger = (Pair)boxed.getValue();
        VirtualFile virtualFile = (VirtualFile)logger.component1();
        EditorComposite editorComposite = (EditorComposite)logger.component2();
        boolean bl12 = Intrinsics.areEqual((Object)virtualFile, (Object)file);
        if (_Assertions.ENABLED && !bl12) {
            boolean bl13 = false;
            String string = "File mismatch on backend open: expected: " + file + ", actual: " + virtualFile;
            throw new AssertionError((Object)string);
        }
        return editorComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FileEditorComposite openFileFromBackend$intellij_rd_client(@NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders, boolean requestFocus, boolean selectAsCurrent, @Nullable FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow, boolean isPinned, @NotNull Function1<? super EditorComposite, Unit> initialize2) {
        boolean bl;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
        Intrinsics.checkNotNullParameter(initialize2, (String)"initialize");
        Logger logger2 = LOG;
        boolean bl2 = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            boolean bl3 = false;
            logger.trace("[file] openFileFromBackend called. file.name=" + file.getName());
        }
        Flow flow = this.createCompositeModelByProvidedList(editorsWithProviders);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EditorComposite editorComposite = super.createCompositeByEditorWithModel(file, flow, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)string, null, (boolean)false, (int)6, null));
        Intrinsics.checkNotNull((Object)editorComposite);
        logger2 = editorComposite;
        initialize2.invoke((Object)logger2);
        Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
        if (boxed == null) {
            KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value2) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value2);
                }
            };
            Boxed boxed2 = new Boxed((Object)TuplesKt.to((Object)logger2.getFile(), (Object)logger2));
            boolean bl4 = false;
            Object object = kMutableProperty0.get();
            try {
                kMutableProperty0.set((Object)boxed2);
                boolean bl5 = false;
                Logger logger3 = LOG;
                boolean bl6 = false;
                if (logger3.isTraceEnabled()) {
                    Logger logger4 = logger3;
                    boolean bl7 = false;
                    logger4.trace("[file] openFileFromBackend: currentRequest is null. Call openFile(...)");
                }
                FileEditorComposite fileEditorComposite = this.openFile(logger2.getFile(), null, new FileEditorOpenOptions(selectAsCurrent, false, false, requestFocus, isPinned, 0, false, openMode, false, isSingletonEditorInWindow, 356, null));
                return fileEditorComposite;
            }
            finally {
                kMutableProperty0.set(object);
            }
        }
        Pair pair = (Pair)boxed.getValue();
        VirtualFile virtualFile = (VirtualFile)pair.component1();
        EditorComposite editorComposite2 = (EditorComposite)pair.component2();
        if (!Intrinsics.areEqual((Object)virtualFile, (Object)logger2.getFile())) {
            KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value2) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value2);
                }
            };
            Boxed boxed3 = new Boxed((Object)TuplesKt.to((Object)logger2.getFile(), (Object)logger2));
            boolean bl8 = false;
            Object object = kMutableProperty0.get();
            try {
                kMutableProperty0.set((Object)boxed3);
                boolean bl9 = false;
                Logger logger5 = LOG;
                boolean bl10 = false;
                if (logger5.isTraceEnabled()) {
                    Logger logger6 = logger5;
                    boolean bl11 = false;
                    logger6.trace("[file] openFileFromBackend: currentRequest is not null, but `request.value.first != composite.file`. Call openFile(...). currentRequest.value=" + boxed.getValue() + ", composite.file=" + logger2.getFile());
                }
                FileEditorComposite fileEditorComposite = this.openFile(logger2.getFile(), null, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, openMode, false, isSingletonEditorInWindow, 373, null));
                return fileEditorComposite;
            }
            finally {
                kMutableProperty0.set(object);
            }
        }
        Logger logger7 = LOG;
        boolean bl12 = false;
        if (logger7.isTraceEnabled()) {
            logger = logger7;
            boolean bl13 = false;
            logger.trace("[file] openFileFromBackend: request is nit null. DO NOT call openFile(...), just put `composite` into `request`.");
        }
        boolean bl14 = bl = editorComposite2 == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boxed.setValue((Object)TuplesKt.to((Object)logger2.getFile(), (Object)logger2));
        return (FileEditorComposite)logger2;
    }

    public final void closeFile$intellij_rd_client(@NotNull EditorComposite composite) {
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        EditorWindow editorWindow = this.G(composite);
        if (editorWindow == null) {
            return;
        }
        EditorWindow editorWindow2 = editorWindow;
        this.closeFile(composite.getFile(), editorWindow2);
    }

    private final EditorWindow G(EditorComposite editorComposite) {
        for (EditorsSplitters editorsSplitters : this.getAllSplitters()) {
            for (EditorWindow editorWindow : editorsSplitters.windows()) {
                if (!Intrinsics.areEqual((Object)editorWindow.getComposite(editorComposite.getFile()), (Object)editorComposite)) continue;
                return editorWindow;
            }
        }
        return null;
    }

    public boolean canOpenFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof IProtocolVirtualFile || super.canOpenFile(file);
    }

    @Nullable
    protected Object canOpenFileAsync(@NotNull VirtualFile file, @NotNull List<? extends FileEditorProvider> providers, @NotNull Continuation<? super Boolean> $completion) {
        return FrontendFileEditorManager.canOpenFileAsync$suspendImpl(this, file, providers, $completion);
    }

    static /* synthetic */ Object canOpenFileAsync$suspendImpl(FrontendFileEditorManager $this, VirtualFile file, List<? extends FileEditorProvider> providers, Continuation<? super Boolean> $completion) {
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.canOpenFileAsync(file, providers, $completion);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    public static final /* synthetic */ Boxed access$getRequest$p(FrontendFileEditorManager $this) {
        return $this.request;
    }

    public static final /* synthetic */ void access$setRequest$p(FrontendFileEditorManager $this, Boxed boxed) {
        $this.request = boxed;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendFileEditorManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager$Companion;", "", "FrontendFileEditorManager$Companion", "()V", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager");
            return (FrontendFileEditorManager)fileEditorManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

