/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchExtension;
import com.jetbrains.rd.ide.model.RdPatchInitialCaretStateHintExtension;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendSelectionChangeHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "FrontendSelectionChangeHandler", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "G", "step", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "G", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendSelectionChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 FrontendRdPatchHandlerContext.kt\ncom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n69#2,4:95\n69#2,4:106\n69#2,4:110\n69#2,4:114\n37#3:99\n38#3,3:101\n41#3:105\n1863#4:100\n1864#4:104\n*S KotlinDebug\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n*L\n18#1:95,4\n49#1:106,4\n54#1:110,4\n61#1:114,4\n48#1:99\n48#1:101,3\n48#1:105\n48#1:100\n48#1:104\n*E\n"})
public final class FrontendSelectionChangeHandler
implements FrontendRdPatchItemHandler<RdPatchItemVersion, RdSelectionChangeBase> {
    @Override
    public void apply(@NotNull RdSelectionChangeBase item, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Applying selection change step: " + item.getEditorId() + " with operation type " + patchItemOperationType);
        }
        object = patchItemOperationType;
        if (Intrinsics.areEqual((Object)object, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            this.G(item, context, context.getRebaseSession());
        } else if (Intrinsics.areEqual((Object)object, (Object)PatchItemOperationType.Redo.INSTANCE)) {
            this.G(item, context.getRebaseSession());
        } else {
            Editor editor = FrontendTextControlHostKt.toEditorOrNull(item.getEditorId());
            if (editor == null) {
                FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
                boolean bl3 = false;
                FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + item.getEditorId());
                return;
            }
            Editor editor2 = editor;
            if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback) {
                return;
            }
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
            Intrinsics.checkNotNull((Object)editorSynchronizer);
            EditorSynchronizer editorSynchronizer2 = editorSynchronizer;
            if (patchItemOperationType instanceof PatchItemOperationType.SoftPerform || patchItemOperationType instanceof PatchItemOperationType.SoftRedo) {
                RdAbstractEditorVersion rdAbstractEditorVersion = editorSynchronizer2.getVersion();
                Intrinsics.checkNotNull((Object)rdAbstractEditorVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdEditorVersion");
                RdEditorVersion rdEditorVersion = (RdEditorVersion)rdAbstractEditorVersion;
                editorSynchronizer2.resetVersion(EditorVersionsKt.increment(rdEditorVersion));
            } else {
                editorSynchronizer2.receiveSelection(item);
            }
        }
    }

    private final void G(RdSelectionChangeBase rdSelectionChangeBase, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext, FrontendRebaseSession frontendRebaseSession) {
        RdEditorChange rdEditorChange;
        boolean bl;
        boolean bl2;
        Object object;
        block8: {
            object = frontendRdPatchHandlerContext;
            bl2 = false;
            Iterable iterable = ((FrontendRdPatchHandlerContext)object).getPatch().getExtensions();
            bl = false;
            for (Object t : iterable) {
                RdPatchExtension rdPatchExtension = (RdPatchExtension)t;
                boolean bl3 = false;
                if (!(rdPatchExtension instanceof RdPatchInitialCaretStateHintExtension)) continue;
                RdPatchInitialCaretStateHintExtension rdPatchInitialCaretStateHintExtension = (RdPatchInitialCaretStateHintExtension)rdPatchExtension;
                boolean bl4 = false;
                rdEditorChange = rdPatchInitialCaretStateHintExtension.getInitialCaretStateHint();
                break block8;
            }
            rdEditorChange = null;
        }
        if (Intrinsics.areEqual((Object)(rdEditorChange != null ? rdEditorChange.getEditorId() : null), (Object)rdSelectionChangeBase.getEditorId())) {
            Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean bl5 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                bl2 = false;
                logger2.trace("Do not rollback initial caret state hint: " + rdSelectionChangeBase.getEditorId() + " - RdPatchInitialCaretStateHintExtension for " + rdSelectionChangeBase.getEditorId() + " is not present");
            }
            return;
        }
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor == null) {
            object = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            bl2 = false;
            if (object.isTraceEnabled()) {
                Object object2 = object;
                boolean bl6 = false;
                object2.trace("Do not rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation() + " because editor does not exist");
            }
            return;
        }
        object = CaretRestoreHelper.Companion.getInstance();
        if (((CaretRestoreHelper)object).getLastCaretBeforeRollbackLeansForward() == null) {
            ((CaretRestoreHelper)object).setLastCaretBeforeRollbackLeansForward(editor.getCaretModel().getPrimaryCaret().getLogicalPosition().leansForward);
        }
        Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl7 = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            bl = false;
            logger3.trace("Rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation());
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
        if (editorSynchronizer == null) {
            throw new IllegalStateException("editor synchronizer is null".toString());
        }
        editorSynchronizer.receiveSelection(UtilKt.reverse(rdSelectionChangeBase));
        frontendRebaseSession.record(rdSelectionChangeBase);
    }

    private final void G(RdSelectionChangeBase rdSelectionChangeBase, FrontendRebaseSession frontendRebaseSession) {
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor == null) {
            FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
            boolean bl = false;
            FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + rdSelectionChangeBase.getEditorId());
            return;
        }
        Editor editor2 = editor;
        RdCaretState rdCaretState = UtilKt.getActualState(frontendRebaseSession.replay(rdSelectionChangeBase));
        for (RdCaret rdCaret : rdCaretState.getCarets()) {
            RdSelection rdSelection;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            Caret caret = UtilKt.getCaretById(caretModel, rdCaret.getId());
            if (caret == null) {
                LogicalPosition logicalPosition;
                boolean bl = Intrinsics.areEqual((Object)rdCaret.getId(), (Object)rdCaretState.getPrimaryCaretId());
                Intrinsics.checkNotNullExpressionValue((Object)editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()), (String)"offsetToLogicalPosition(...)");
                Caret caret2 = caret = editor2.getCaretModel().addCaret(logicalPosition, bl);
                if (caret2 != null) {
                    UtilKt.setId(caret2, rdCaret.getId());
                }
            }
            if (rdCaret.getOffset().getOffset() != -1) {
                Caret caret3 = caret;
                if (caret3 != null) {
                    caret3.moveToOffset(rdCaret.getOffset().getOffset());
                }
            }
            if ((rdSelection = rdCaret.getSelection()).getStart().getOffset() == -1 || rdSelection.getEnd().getOffset() == -1 || rdSelection.getStart().getOffset() >= rdSelection.getEnd().getOffset()) continue;
            Caret caret4 = caret;
            if (caret4 == null) continue;
            caret4.setSelection(rdSelection.getStart().getOffset(), rdSelection.getEnd().getOffset());
        }
    }
}

